/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.CometSupport;
import org.atmosphere.util.LoggerUtils;

public abstract class AsynchronousProcessor
implements CometSupport<AtmosphereResourceImpl> {
    protected static final AtmosphereServlet.Action timedoutAction = new AtmosphereServlet.Action(AtmosphereServlet.Action.TYPE.TIMEOUT);
    protected static final AtmosphereServlet.Action cancelledAction = new AtmosphereServlet.Action(AtmosphereServlet.Action.TYPE.CANCELLED);
    protected final Logger logger = LoggerUtils.getLogger();
    protected final AtmosphereServlet.AtmosphereConfig config;
    protected final ConcurrentHashMap<HttpServletRequest, AtmosphereResource<HttpServletRequest, HttpServletResponse>> aliveRequests = new ConcurrentHashMap();
    private final ScheduledExecutorService closedDetector = Executors.newScheduledThreadPool(1);

    public AsynchronousProcessor(AtmosphereServlet.AtmosphereConfig config) {
        this.config = config;
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
        String maxInactive;
        String string = maxInactive = sc.getInitParameter(MAX_INACTIVE) != null ? sc.getInitParameter(MAX_INACTIVE) : this.config.getInitParameter(MAX_INACTIVE);
        if (maxInactive != null) {
            final long maxInactiveTime = Long.parseLong(maxInactive);
            if (maxInactiveTime <= 0L) {
                return;
            }
            this.closedDetector.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    for (HttpServletRequest req : AsynchronousProcessor.this.aliveRequests.keySet()) {
                        long l = (Long)req.getAttribute(CometSupport.MAX_INACTIVE);
                        if (l <= 0L || System.currentTimeMillis() - l <= maxInactiveTime) continue;
                        try {
                            AsynchronousProcessor.this.cancelled(req, AsynchronousProcessor.this.aliveRequests.get(req).getResponse());
                            req.setAttribute(CometSupport.MAX_INACTIVE, -1L);
                        }
                        catch (IOException e) {
                        }
                        catch (ServletException e) {}
                    }
                }
            }, 0L, 1L, TimeUnit.SECONDS);
        }
    }

    protected boolean supportSession() {
        return this.config.isSupportSession();
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo();
    }

    public AtmosphereServlet.Action suspended(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("(suspend) invoked:\n HttpServletRequest: " + req + "\n HttpServletResponse: " + res);
        }
        return this.action(req, res);
    }

    AtmosphereServlet.Action action(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (this.supportSession()) {
            HttpSession session = req.getSession(true);
            session.setMaxInactiveInterval(-1);
        }
        req.setAttribute("org.atmosphere.cpr.AsynchronousProcessor.supportSession", this.supportSession());
        AtmosphereServlet.AtmosphereHandlerWrapper g = this.map(req);
        AtmosphereResourceImpl re = new AtmosphereResourceImpl(this.config, g.broadcaster, req, res, this);
        req.setAttribute(AtmosphereServlet.ATMOSPHERE_RESOURCE, re);
        req.setAttribute(AtmosphereServlet.ATMOSPHERE_HANDLER, g.atmosphereHandler);
        g.atmosphereHandler.onRequest(re);
        this.config.mapBroadcasterToAtmosphereHandler(re.getBroadcaster(), g);
        if (re.getAtmosphereResourceEvent().isSuspended()) {
            req.setAttribute(MAX_INACTIVE, System.currentTimeMillis());
            this.aliveRequests.put(req, re);
        }
        return re.action();
    }

    @Override
    public void action(AtmosphereResourceImpl r) {
        this.aliveRequests.remove(r.getRequest());
    }

    protected AtmosphereServlet.AtmosphereHandlerWrapper map(HttpServletRequest req) throws ServletException {
        AtmosphereServlet.AtmosphereHandlerWrapper atmosphereHandlerWrapper;
        String path = req.getServletPath();
        if (path == null || path.equals("")) {
            path = "/";
        }
        if ((atmosphereHandlerWrapper = this.config.handlers().get(path)) == null) {
            path = !path.endsWith("/") ? path + "/*" : path + "*";
            atmosphereHandlerWrapper = this.config.handlers().get(path);
            if (atmosphereHandlerWrapper == null && (atmosphereHandlerWrapper = this.config.handlers().get("/*")) == null) {
                path = req.getServletPath() + req.getPathInfo();
                atmosphereHandlerWrapper = this.config.handlers().get(path);
                if (atmosphereHandlerWrapper == null) {
                    path = !path.endsWith("/") ? path + "/*" : path + "*";
                    atmosphereHandlerWrapper = this.config.handlers().get(path);
                    if (atmosphereHandlerWrapper == null) {
                        this.logger.warning("No AtmosphereHandler maps request for " + path);
                        for (String m : this.config.handlers().keySet()) {
                            this.logger.warning("\tAtmosphereHandler registered: " + m);
                        }
                        throw new ServletException("No AtmosphereHandler maps request for " + path);
                    }
                }
            }
        }
        this.config.getBroadcasterFactory().add(atmosphereHandlerWrapper.broadcaster, atmosphereHandlerWrapper.broadcaster.getID());
        return atmosphereHandlerWrapper;
    }

    public AtmosphereServlet.Action resumed(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("(resumed) invoked:\n HttpServletRequest: " + req + "\n HttpServletResponse: " + res);
        }
        return this.action(req, res);
    }

    public AtmosphereServlet.Action timedout(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        long l = (Long)req.getAttribute(MAX_INACTIVE);
        if (l == -1L) {
            return timedoutAction;
        }
        req.setAttribute(MAX_INACTIVE, -1L);
        if (req == null || res == null) {
            this.logger.warning("Invalid Request/Response: " + req + "/" + res);
            return timedoutAction;
        }
        AtmosphereResourceImpl re = (AtmosphereResourceImpl)req.getAttribute(AtmosphereServlet.ATMOSPHERE_RESOURCE);
        if (re != null) {
            re.getAtmosphereResourceEvent().isResumedOnTimeout = true;
            if (re.getRequest().getAttribute(AtmosphereServlet.RESUMED_ON_TIMEOUT) != null) {
                re.getAtmosphereResourceEvent().isResumedOnTimeout = (Boolean)re.getRequest().getAttribute(AtmosphereServlet.RESUMED_ON_TIMEOUT);
            }
            this.invokeAtmosphereHandler(re);
        }
        return timedoutAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeAtmosphereHandler(AtmosphereResourceImpl r) throws IOException {
        HttpServletRequest req = r.getRequest();
        HttpServletResponse res = r.getResponse();
        String disableOnEvent = r.getAtmosphereConfig().getInitParameter("org.atmosphere.disableOnStateEvent");
        try {
            if (!r.getResponse().equals(res)) {
                this.logger.warning("Invalid response: " + res);
            } else if (disableOnEvent == null || !disableOnEvent.equals(String.valueOf(true))) {
                AtmosphereHandler atmosphereHandler = (AtmosphereHandler)req.getAttribute(AtmosphereServlet.ATMOSPHERE_HANDLER);
                atmosphereHandler.onStateChange(r.getAtmosphereResourceEvent());
            } else {
                r.getResponse().flushBuffer();
            }
        }
        finally {
            try {
                this.aliveRequests.remove(req);
                r.notifyListeners();
            }
            finally {
                r.removeEventListeners();
                r.getBroadcaster().removeAtmosphereResource(r);
            }
        }
    }

    public AtmosphereServlet.Action cancelled(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        block4: {
            AtmosphereResourceImpl re = null;
            long l = (Long)req.getAttribute(MAX_INACTIVE);
            if (l == -1L) {
                return timedoutAction;
            }
            req.setAttribute(MAX_INACTIVE, -1L);
            try {
                re = (AtmosphereResourceImpl)req.getAttribute(AtmosphereServlet.ATMOSPHERE_RESOURCE);
                if (re != null) {
                    re.getAtmosphereResourceEvent().setCancelled(true);
                    this.invokeAtmosphereHandler(re);
                    re.setIsInScope(false);
                }
            }
            catch (Throwable ex) {
                if (!this.logger.isLoggable(Level.FINE)) break block4;
                this.logger.log(Level.FINE, "", ex);
            }
        }
        return cancelledAction;
    }

    void shutdown() {
        this.closedDetector.shutdownNow();
        for (AtmosphereResource<HttpServletRequest, HttpServletResponse> r : this.aliveRequests.values()) {
            try {
                r.resume();
            }
            catch (Throwable t) {
                if (!this.logger.isLoggable(Level.FINE)) continue;
                this.logger.log(Level.FINE, "", t);
            }
        }
    }

    @Override
    public boolean supportWebSocket() {
        return false;
    }
}

