/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.spade;

import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.servlet.deployer.WebAppAdapter;
import com.sun.grizzly.standalone.comet.Comet;
import com.sun.grizzly.tcp.Adapter;
import org.atmosphere.grizzly.AtmosphereAdapter;

public final class AtmosphereSpadeLauncher
extends Comet {
    private String resourcesPackage = null;
    private String servletPath = "";

    private AtmosphereSpadeLauncher() {
    }

    public static void main(String[] args) throws Exception {
        AtmosphereSpadeLauncher sl = new AtmosphereSpadeLauncher();
        sl.start(args);
    }

    @Override
    public void printHelpAndExit() {
        System.err.println("Usage: " + AtmosphereSpadeLauncher.class.getCanonicalName() + " [options]");
        System.err.println();
        System.err.println("    -p, --port=port                   Runs AtmosphereSpadeServer on the specified port.");
        System.err.println("                                      Default: 8080");
        System.err.println("    -a, --apps=application path       The AtmosphereServlet folder or jar or war location.");
        System.err.println("                                      Default: .");
        System.err.println("    -rp, --respourcespackage=package  The resources package name");
        System.err.println("                                      Default: ");
        System.err.println("    -sp, --servletPath=path           The path AtmosphereServlet will serve resources");
        System.err.println("                                      Default: .");
        System.err.println("    -h, --help                        Show this help message.");
        System.exit(1);
    }

    @Override
    public boolean parseOptions(String[] args) {
        for (int i = 0; i < args.length - 1; ++i) {
            String val;
            String arg = args[i];
            if ("-h".equals(arg) || "--help".equals(arg)) {
                this.printHelpAndExit();
                continue;
            }
            if ("-a".equals(arg)) {
                this.applicationLoc = args[++i];
                continue;
            }
            if (arg.startsWith("--application=")) {
                this.applicationLoc = arg.substring("--application=".length(), arg.length());
                continue;
            }
            if ("-p".equals(arg)) {
                this.setPort(args[++i]);
                continue;
            }
            if (arg.startsWith("--port=")) {
                String num = arg.substring("--port=".length(), arg.length());
                this.setPort(num);
                continue;
            }
            if ("-rp".equals(arg)) {
                this.resourcesPackage = args[++i];
                continue;
            }
            if (arg.startsWith("--resourcespackage=")) {
                this.resourcesPackage = val = arg.substring("--resourcespackage=".length(), arg.length());
                continue;
            }
            if ("-sp".equals(arg)) {
                this.servletPath = args[++i];
                continue;
            }
            if (!arg.startsWith("--servletpath=")) continue;
            this.servletPath = val = arg.substring("--servletpath=".length(), arg.length());
        }
        if (this.applicationLoc == null) {
            System.err.println("Illegal War|Jar file or folder location.");
            this.printHelpAndExit();
        }
        return true;
    }

    @Override
    public Adapter configureAdapter(SelectorThread st) {
        st.setDisplayConfiguration(true);
        AtmosphereAdapter adapter = new AtmosphereAdapter();
        adapter.addRootFolder(st.getWebAppRootPath());
        adapter.setHandleStaticResources(true);
        this.applicationLoc = this.applicationLoc.replaceAll("\\\\", "/");
        String warName = "";
        warName = this.applicationLoc.lastIndexOf("/") > -1 ? this.applicationLoc.substring(this.applicationLoc.lastIndexOf("/"), this.applicationLoc.lastIndexOf(".")) : this.applicationLoc;
        adapter.setContextPath(warName);
        if (!this.servletPath.startsWith("/")) {
            this.servletPath = "/" + this.servletPath;
        }
        adapter.setServletPath(WebAppAdapter.getServletPath(this.servletPath));
        adapter.setResourcePackage(this.resourcesPackage);
        return adapter;
    }
}

