/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.atmosphere.util.LoggerUtils;
import org.atmosphere.websocket.WebSocketSupport;

public class WebSocketHttpServletResponse<A extends WebSocketSupport>
extends HttpServletResponseWrapper {
    private final ArrayList<Cookie> cookies = new ArrayList();
    private final HashMap<String, String> headers = new HashMap();
    private final A webSocketSupport;
    private int status = 200;
    private String statusMessage = "";
    private String charSet = "UTF-8";
    private byte frame;
    private long contentLength = -1L;
    private String contentType = "txt/html";
    private boolean isCommited = false;
    private Locale locale;

    public WebSocketHttpServletResponse(A webSocketSupport) {
        super(new HttpServletResponse(){

            @Override
            public void addCookie(Cookie cookie) {
            }

            @Override
            public boolean containsHeader(String name) {
                return false;
            }

            @Override
            public String encodeURL(String url) {
                return null;
            }

            @Override
            public String encodeRedirectURL(String url) {
                return null;
            }

            @Override
            public String encodeUrl(String url) {
                return null;
            }

            @Override
            public String encodeRedirectUrl(String url) {
                return null;
            }

            @Override
            public void sendError(int sc, String msg) throws IOException {
            }

            @Override
            public void sendError(int sc) throws IOException {
            }

            @Override
            public void sendRedirect(String location) throws IOException {
            }

            @Override
            public void setDateHeader(String name, long date) {
            }

            @Override
            public void addDateHeader(String name, long date) {
            }

            @Override
            public void setHeader(String name, String value) {
            }

            @Override
            public void addHeader(String name, String value) {
            }

            @Override
            public void setIntHeader(String name, int value) {
            }

            @Override
            public void addIntHeader(String name, int value) {
            }

            @Override
            public void setStatus(int sc) {
            }

            @Override
            public void setStatus(int sc, String sm) {
            }

            public int getStatus() {
                return 0;
            }

            public String getHeader(String name) {
                return null;
            }

            public Collection<String> getHeaders(String name) {
                return null;
            }

            public Collection<String> getHeaderNames() {
                return null;
            }

            @Override
            public String getCharacterEncoding() {
                return null;
            }

            @Override
            public String getContentType() {
                return null;
            }

            @Override
            public ServletOutputStream getOutputStream() throws IOException {
                return null;
            }

            @Override
            public PrintWriter getWriter() throws IOException {
                return null;
            }

            @Override
            public void setCharacterEncoding(String charset) {
            }

            @Override
            public void setContentLength(int len) {
            }

            @Override
            public void setContentType(String type) {
            }

            @Override
            public void setBufferSize(int size) {
            }

            @Override
            public int getBufferSize() {
                return 0;
            }

            @Override
            public void flushBuffer() throws IOException {
            }

            @Override
            public void resetBuffer() {
            }

            @Override
            public boolean isCommitted() {
                return false;
            }

            @Override
            public void reset() {
            }

            @Override
            public void setLocale(Locale loc) {
            }

            @Override
            public Locale getLocale() {
                return null;
            }
        });
        this.webSocketSupport = webSocketSupport;
    }

    @Override
    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    @Override
    public boolean containsHeader(String name) {
        return this.headers.get(name) != null;
    }

    @Override
    public String encodeURL(String url) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String encodeRedirectURL(String url) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String encodeUrl(String url) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String encodeRedirectUrl(String url) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sendError(int sc, String msg) throws IOException {
        this.webSocketSupport.writeError(sc, msg);
    }

    @Override
    public void sendError(int sc) throws IOException {
        this.webSocketSupport.writeError(sc, "");
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        this.webSocketSupport.redirect(location);
    }

    @Override
    public void setDateHeader(String name, long date) {
        this.headers.put(name, String.valueOf(date));
    }

    @Override
    public void addDateHeader(String name, long date) {
        this.headers.put(name, String.valueOf(date));
    }

    @Override
    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Override
    public void setIntHeader(String name, int value) {
        this.headers.put(name, String.valueOf(value));
    }

    @Override
    public void addIntHeader(String name, int value) {
        this.headers.put(name, String.valueOf(value));
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public void setStatus(int status, String statusMessage) {
        this.statusMessage = statusMessage;
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Collection<String> getHeaders(String name) {
        ArrayList<String> s = new ArrayList<String>();
        s.add(this.headers.get(name));
        return Collections.unmodifiableList(s);
    }

    public Collection<String> getHeaderNames() {
        return Collections.unmodifiableSet(this.headers.keySet());
    }

    @Override
    public void setCharacterEncoding(String charset) {
        this.charSet = this.charSet;
    }

    @Override
    public String getCharacterEncoding() {
        return this.charSet;
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        return new ServletOutputStream(){

            @Override
            public void write(int i) throws IOException {
                WebSocketHttpServletResponse.this.webSocketSupport.write(WebSocketHttpServletResponse.this.frame, new byte[]{(byte)i});
            }

            @Override
            public void write(byte[] bytes) throws IOException {
                WebSocketHttpServletResponse.this.webSocketSupport.write(WebSocketHttpServletResponse.this.frame, bytes);
            }

            @Override
            public void write(byte[] bytes, int start, int offset) throws IOException {
                WebSocketHttpServletResponse.this.webSocketSupport.write(WebSocketHttpServletResponse.this.frame, bytes, start, offset);
            }
        };
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        return new PrintWriter(this.getOutputStream()){

            @Override
            public void write(char[] chars, int offset, int lenght) {
                try {
                    WebSocketHttpServletResponse.this.webSocketSupport.write(WebSocketHttpServletResponse.this.frame, new String(chars, offset, lenght));
                }
                catch (IOException e) {
                    LoggerUtils.getLogger().log(Level.INFO, "", e);
                }
            }

            @Override
            public void write(char[] chars) {
                try {
                    WebSocketHttpServletResponse.this.webSocketSupport.write(WebSocketHttpServletResponse.this.frame, new String(chars));
                }
                catch (IOException e) {
                    LoggerUtils.getLogger().log(Level.INFO, "", e);
                }
            }

            @Override
            public void write(String s, int offset, int lenght) {
                try {
                    WebSocketHttpServletResponse.this.webSocketSupport.write(WebSocketHttpServletResponse.this.frame, new String(s.substring(offset, lenght)));
                }
                catch (IOException e) {
                    LoggerUtils.getLogger().log(Level.INFO, "", e);
                }
            }

            @Override
            public void write(String s) {
                try {
                    WebSocketHttpServletResponse.this.webSocketSupport.write(WebSocketHttpServletResponse.this.frame, new String(s));
                }
                catch (IOException e) {
                    LoggerUtils.getLogger().log(Level.INFO, "", e);
                }
            }
        };
    }

    @Override
    public void setContentLength(int len) {
        this.contentLength = len;
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void setBufferSize(int size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getBufferSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flushBuffer() throws IOException {
    }

    @Override
    public boolean isCommitted() {
        return this.isCommited;
    }

    @Override
    public void reset() {
    }

    @Override
    public void resetBuffer() {
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public boolean isWrapperFor(ServletResponse wrapped) {
        return false;
    }

    public boolean isWrapperFor(Class wrappedType) {
        return false;
    }

    public A getWebSocketSupport() {
        return this.webSocketSupport;
    }
}

