/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.servlet.deployer.conf;

import com.sun.grizzly.http.servlet.deployer.conf.DeployableConfiguration;
import com.sun.grizzly.http.servlet.deployer.conf.DeployerServerConfiguration;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigurationParser {
    private static Logger logger = Logger.getLogger(ConfigurationParser.class.getName());

    public static DeployerServerConfiguration parseOptions(String[] args, String canonicalName) {
        return ConfigurationParser.parseOptions(args, canonicalName, null);
    }

    public static DeployerServerConfiguration parseOptions(String[] args, String canonicalName, DeployerServerConfiguration conf) {
        if (args == null) {
            ConfigurationParser.printHelpAndExit(canonicalName);
        }
        if (conf == null) {
            conf = new DeployerServerConfiguration();
        }
        String forcedContext = null;
        Boolean forceWarDeployment = null;
        for (int i = 0; i < args.length; ++i) {
            String[] locations;
            String arg = args[i];
            if ("-h".equals(arg) || "--help".equals(arg)) {
                ConfigurationParser.printHelpAndExit(canonicalName);
                continue;
            }
            if ("--longhelp".equals(arg)) {
                ConfigurationParser.printLongHelpAndExit(canonicalName);
                continue;
            }
            if ("-a".equals(arg)) {
                if (++i >= args.length) continue;
                for (String location : locations = args[i].split(File.pathSeparator)) {
                    conf.applicationsList.add(new DeployableConfiguration(location));
                }
                continue;
            }
            if (arg.startsWith("--application=")) {
                for (String location : locations = args[i].split(File.pathSeparator)) {
                    conf.applicationsList.add(new DeployableConfiguration(location));
                }
                continue;
            }
            if ("-p".equals(arg)) {
                if (++i >= args.length) continue;
                conf.port = Integer.parseInt(args[i]);
                continue;
            }
            if (arg.startsWith("--port=")) {
                String num = arg.substring("--port=".length(), arg.length());
                conf.port = Integer.parseInt(num);
                continue;
            }
            if ("-c".equals(arg)) {
                if (++i >= args.length) continue;
                forcedContext = args[i];
                continue;
            }
            if (arg.startsWith("--context=")) {
                forcedContext = arg.substring("--context=".length(), arg.length());
                continue;
            }
            if (arg.startsWith("--dontstart=")) {
                conf.waitToStart = Boolean.parseBoolean(arg.substring("--dontstart=".length(), arg.length()));
                continue;
            }
            if (arg.startsWith("--libraryPath=")) {
                conf.libraryPath = arg.substring("--libraryPath=".length(), arg.length());
                continue;
            }
            if (arg.startsWith("--webdefault=")) {
                conf.webdefault = arg.substring("--webdefault=".length(), arg.length());
                continue;
            }
            if (arg.startsWith("--autodeploy=")) {
                conf.webdefault = arg.substring("--autodeploy=".length(), arg.length());
                continue;
            }
            if (arg.startsWith("--cometEnabled=")) {
                conf.cometEnabled = Boolean.parseBoolean(arg.substring("--cometEnabled=".length(), arg.length()));
                continue;
            }
            if (arg.startsWith("--forceWar")) {
                forceWarDeployment = Boolean.parseBoolean(arg.substring("--forceWar=".length(), arg.length()));
                continue;
            }
            if (arg.startsWith("--ajpEnabled")) {
                conf.ajpEnabled = Boolean.parseBoolean(arg.substring("--ajpEnabled=".length(), arg.length()));
                continue;
            }
            if (arg.startsWith("--websocketsEnabled=")) {
                conf.websocketsEnabled = Boolean.parseBoolean(arg.substring("--websocketsEnabled=".length(), arg.length()));
                continue;
            }
            if (arg.startsWith("--watchInterval=")) {
                conf.watchInterval = Long.parseLong(arg.substring("--watchInterval=".length(), arg.length()));
                continue;
            }
            if (!arg.startsWith("--watchFolder=")) continue;
            conf.watchFolder = arg.substring("--watchFolder=".length(), arg.length());
        }
        if (conf.applicationsList != null && !conf.applicationsList.isEmpty()) {
            for (DeployableConfiguration config : conf.applicationsList) {
                if (forcedContext != null) {
                    config.forcedContext = forcedContext;
                }
                if (forceWarDeployment == null) continue;
                config.forceWarDeployment = forceWarDeployment;
            }
        }
        return conf;
    }

    private static void printHelpAndExit(String canonicalName) {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("\nUsage: ").append(canonicalName).append("\n  --application=[path]        Application(s) path(s).\n").append("  --port=[port]               Runs Servlet on the specified port.\n").append("  --context=[context]         Force the context for a servlet.\n").append("  --dontstart=[true/false]    Won't start the server.\n").append("  --libraryPath=[path]        Add a libraries folder to the classpath.\n").append("  --autodeploy=[path]         AutoDeploy to each applications\n").append("  --webdefault=[path]         webdefault to be used by all applications, can be file or dir with multipe web.xmls\n").append("  --cometEnabled              Starts the AsyncFilter for Comet\n").append("  --websocketsEnabled         Starts the AsyncFilter for Websockets\n").append("  --forceWar                  Force war's deployment over a expanded folder.\n").append("  --ajpEnabled                Enable mod_jk.\n").append("  --watchInterval=            Watch interval to scan for new applications to deploy in work folder\n").append("  --watchFolder=              Folder to scan for new applications to deploy in work folder\n").append("  --help                      Show this help message.\n").append("  --longhelp                  Show detailled help message.\n\n").append("  * are mandatory");
        logger.log(Level.SEVERE, sb.toString());
        System.exit(1);
    }

    private static void printLongHelpAndExit(String canonicalName) {
        System.err.println();
        System.err.println("Usage: " + canonicalName);
        System.err.println();
        System.err.println("  -a, --application=[path]    Application(s) path(s).");
        System.err.println();
        System.err.println("                              Application(s) deployed can be :");
        System.err.println("                              Servlet(s), war(s) and expanded war folder(s).");
        System.err.println("                              To deploy multiple applications");
        System.err.println("                              use File.pathSeparator");
        System.err.println();
        System.err.println("                              Example : -a /app.war:/servlet/web.xml:/warfolder/");
        System.err.println();
        System.err.println("  -p, --port=[port]           Runs Servlet on the specified port.");
        System.err.println("                              Default: 8080");
        System.err.println();
        System.err.println("  -c, --context=[context]     Force the context for a servlet.");
        System.err.println("                              Only valid for servlet deployed using");
        System.err.println("                              -a [path]/[filename].xml");
        System.err.println();
        System.err.println("  --dontstart=[true/false]    Won't start the server.");
        System.err.println("                              You will need to call the start method.");
        System.err.println("                              Useful for Unit testing.");
        System.err.println("                              Default : false");
        System.err.println();
        System.err.println("  --libraryPath=[path]        Add a libraries folder to the classpath.");
        System.err.println("                              You can append multiple folders using");
        System.err.println("                              File.pathSeparator");
        System.err.println();
        System.err.println("                              Example : --libraryPath=/libs:/common_libs");
        System.err.println();
        System.err.println("  --autodeploy=[path]         AutoDeploy to each applications.");
        System.err.println("                              You could add JSP support.");
        System.err.println("                              Just add a web.xml that contains Jasper");
        System.err.println();
        System.err.println("                              Example : --autodeploy=/autodeploy");
        System.err.println();
        System.err.println("  --webdefault=[path]         webdefault to be used by all applications, can be file or dir with multipe web.xmls.");
        System.err.println("                              If you want to add only one webdefault point it to web.xml file,");
        System.err.println("                              If you want multiple files to be included put them in one dir and provide this location here.");
        System.err.println();
        System.err.println("                              Example : --webdefault=webdefault.xml");
        System.err.println();
        System.err.println("  --cometEnabled=[true/false] Starts the AsyncFilter for Comet.");
        System.err.println("                              You need to active this for comet applications.");
        System.err.println("                              Default : false");
        System.err.println();
        System.err.println("  --websocketsEnabled=[true/false] Starts the AsyncFilter for Websockets.");
        System.err.println("                              You need to active this for websockets applications.");
        System.err.println("                              Default : false");
        System.err.println();
        System.err.println("  --forceWar=[true/false]     Force war's deployment over a expanded folder.");
        System.err.println("                              Will deploy the war instead of the folder.");
        System.err.println("                              Default : false");
        System.err.println();
        System.err.println("  --ajpEnabled=[true/false]   Enable mod_jk.");
        System.err.println("                              Default : false");
        System.err.println();
        System.err.println("  --watchInterval=[seconds]   Watch interval to scan for new applications to deploy in work folder.");
        System.err.println("                              Default : -1 ; disabled");
        System.err.println();
        System.err.println("  --watchFolder=[path]   \t  Folder to scan for new applications to deploy in work folder");
        System.err.println("                              Default : none");
        System.err.println();
        System.err.println("  Default values will be applied if invalid values are passed.");
        System.err.println();
        System.err.println("  * are mandatory");
        System.exit(1);
    }
}

