/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereEventLifecycle;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.CometSupport;
import org.atmosphere.cpr.Serializer;
import org.atmosphere.util.LoggerUtils;

public class AtmosphereResourceImpl
implements AtmosphereResource<HttpServletRequest, HttpServletResponse>,
AtmosphereEventLifecycle {
    public static final String PRE_SUSPEND = AtmosphereResourceImpl.class.getName() + ".preSuspend";
    private final HttpServletRequest req;
    private final HttpServletResponse res;
    protected final AtmosphereServlet.Action action = new AtmosphereServlet.Action();
    protected Broadcaster broadcaster;
    private final AtmosphereServlet.AtmosphereConfig config;
    protected final CometSupport cometSupport;
    private Serializer serializer;
    private boolean isInScope = true;
    private final AtmosphereResourceEventImpl event;
    private static final String beginCompatibleData = AtmosphereResourceImpl.createCompatibleStringJunk();
    private boolean useWriter = true;
    private final ConcurrentLinkedQueue<AtmosphereResourceEventListener> listeners = new ConcurrentLinkedQueue();
    private final AtomicBoolean isSuspendEvent = new AtomicBoolean(false);

    public AtmosphereResourceImpl(AtmosphereServlet.AtmosphereConfig config, Broadcaster broadcaster, HttpServletRequest req, HttpServletResponse res, CometSupport cometSupport) {
        this.req = req;
        this.res = res;
        this.broadcaster = broadcaster;
        this.config = config;
        this.cometSupport = cometSupport;
        this.event = new AtmosphereResourceEventImpl(this);
    }

    @Override
    public AtmosphereResourceEventImpl getAtmosphereResourceEvent() {
        return this.event;
    }

    @Override
    public void resume() {
        if (!this.event.isResuming() && !this.event.isResumedOnTimeout() && this.event.isSuspended() && this.isInScope) {
            block5: {
                this.action.type = AtmosphereServlet.Action.TYPE.RESUME;
                this.notifyListeners();
                this.listeners.clear();
                this.broadcaster.removeAtmosphereResource(this);
                try {
                    this.req.setAttribute(AtmosphereServlet.RESUMED_ON_TIMEOUT, Boolean.FALSE);
                }
                catch (Exception ex) {
                    if (!LoggerUtils.getLogger().isLoggable(Level.FINE)) break block5;
                    LoggerUtils.getLogger().fine("Cannot resume an already resumed/cancelled request ");
                }
            }
            this.cometSupport.action(this);
        } else if (LoggerUtils.getLogger().isLoggable(Level.FINE)) {
            LoggerUtils.getLogger().fine("Cannot resume an already resumed/cancelled request ");
        }
    }

    @Override
    public void suspend() {
        this.suspend(-1L);
    }

    @Override
    public void suspend(long timeout) {
        this.suspend(timeout, true);
    }

    @Override
    public void suspend(long timeout, boolean flushComment) {
        if (this.req.getSession(false) != null && this.req.getSession().getMaxInactiveInterval() != -1 && (long)this.req.getSession().getMaxInactiveInterval() < timeout) {
            throw new IllegalStateException("Cannot suspend a response longer than the session timeout. Increase the value of session-timeout in web.xml");
        }
        if (!this.event.isResumedOnTimeout()) {
            String upgrade = this.req.getHeader("Connection");
            if (upgrade != null && upgrade.equalsIgnoreCase("Upgrade")) {
                if (!this.cometSupport.supportWebSocket()) {
                    this.res.addHeader("X-Atmosphere-error", "Websocket protocol not supported");
                } else {
                    flushComment = false;
                }
            }
            this.res.setHeader("Expires", "-1");
            this.res.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
            this.res.setHeader("Pragma", "no-cache");
            if (flushComment) {
                this.write();
            }
            this.req.setAttribute(PRE_SUSPEND, "true");
            this.action.type = AtmosphereServlet.Action.TYPE.SUSPEND;
            this.action.timeout = timeout;
            if (this.broadcaster.getScope() == Broadcaster.SCOPE.REQUEST) {
                String id = this.broadcaster.getID();
                Class<?> clazz = this.broadcaster.getClass();
                this.broadcaster = BroadcasterFactory.getDefault().lookup(clazz, id, false);
                if (this.broadcaster == null || this.broadcaster.getAtmosphereResources().size() > 0) {
                    this.broadcaster = BroadcasterFactory.getDefault().lookup(clazz, id + "/" + UUID.randomUUID(), true);
                }
            }
            this.broadcaster.addAtmosphereResource(this);
            this.req.removeAttribute(PRE_SUSPEND);
            this.notifyListeners();
        }
    }

    void write() {
        block7: {
            try {
                if (this.useWriter && !((Boolean)this.req.getAttribute("org.atmosphere.useStream")).booleanValue()) {
                    try {
                        this.res.getWriter();
                    }
                    catch (IllegalStateException e) {
                        return;
                    }
                    this.res.getWriter().write(beginCompatibleData);
                    this.res.getWriter().flush();
                    break block7;
                }
                try {
                    this.res.getOutputStream();
                }
                catch (IllegalStateException e) {
                    return;
                }
                this.res.getOutputStream().write(beginCompatibleData.getBytes());
                this.res.getOutputStream().flush();
            }
            catch (Throwable ex) {
                LoggerUtils.getLogger().log(Level.WARNING, "", ex);
            }
        }
    }

    @Override
    public HttpServletRequest getRequest() {
        if (!this.isInScope) {
            throw new IllegalStateException("Request object no longer valid. This object has been cancelled");
        }
        return this.req;
    }

    @Override
    public HttpServletResponse getResponse() {
        if (!this.isInScope) {
            throw new IllegalStateException("Response object no longer valid. This object has been cancelled");
        }
        return this.res;
    }

    @Override
    public Broadcaster getBroadcaster() {
        return this.broadcaster;
    }

    @Override
    public void setBroadcaster(Broadcaster broadcaster) {
        this.broadcaster = broadcaster;
    }

    @Override
    public AtmosphereServlet.AtmosphereConfig getAtmosphereConfig() {
        return this.config;
    }

    public AtmosphereServlet.Action action() {
        return this.action;
    }

    protected void setIsInScope(boolean isInScope) {
        this.isInScope = isInScope;
    }

    public boolean isInScope() {
        return this.isInScope;
    }

    @Override
    public void setSerializer(Serializer s) {
        this.serializer = s;
    }

    @Override
    public void write(OutputStream os, Object o) throws IOException {
        if (o == null) {
            throw new IllegalStateException("Object cannot be null");
        }
        if (this.serializer != null) {
            this.serializer.write(os, o);
        } else {
            this.res.getOutputStream().write(o.toString().getBytes());
        }
    }

    @Override
    public Serializer getSerializer() {
        return this.serializer;
    }

    public static String createCompatibleStringJunk() {
        StringBuilder s = new StringBuilder();
        s.append("<!-- ---------------------------------------------------------------- http://github.com/Atmosphere ------------------------------------------------------------------------ -->\n");
        s.append("<!-- Welcome to the Atmosphere Framework. To work with all the browsers when suspending connection, Atmosphere must output some data to makes WebKit based browser working.-->\n");
        for (int i = 0; i < 10; ++i) {
            s.append("<!-- --------------------------------------------------------------------------------------------------------------------------------------------------------------------- -->\n");
        }
        s.append("<!-- EOD -->");
        return s.toString();
    }

    @Override
    public void addEventListener(AtmosphereResourceEventListener e) {
        if (this.listeners.contains(e)) {
            return;
        }
        this.listeners.add(e);
    }

    @Override
    public void removeEventListener(AtmosphereResourceEventListener e) {
        this.listeners.remove(e);
    }

    @Override
    public void removeEventListeners() {
        this.listeners.clear();
    }

    @Override
    public void notifyListeners() {
        this.notifyListeners(this.event);
    }

    @Override
    public void notifyListeners(AtmosphereResourceEvent event) {
        if (event.isResuming() || event.isResumedOnTimeout()) {
            this.onResume(event);
        } else if (event.isCancelled()) {
            this.onDisconnect(event);
        } else if (!this.isSuspendEvent.getAndSet(true) && event.isSuspended()) {
            this.onSuspend(event);
        } else {
            this.onBroadcast(event);
        }
    }

    void onSuspend(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> e) {
        for (AtmosphereResourceEventListener r : this.listeners) {
            r.onSuspend(e);
        }
    }

    void onResume(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> e) {
        for (AtmosphereResourceEventListener r : this.listeners) {
            r.onResume(e);
        }
    }

    void onDisconnect(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> e) {
        for (AtmosphereResourceEventListener r : this.listeners) {
            r.onDisconnect(e);
        }
    }

    void onBroadcast(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> e) {
        for (AtmosphereResourceEventListener r : this.listeners) {
            r.onBroadcast(e);
        }
    }
}

