/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jersey;

import com.sun.jersey.api.JResponseAsResponse;
import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ResourceFilter;
import com.sun.jersey.spi.container.ResourceFilterFactory;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriInfo;
import org.atmosphere.annotation.Broadcast;
import org.atmosphere.annotation.Cluster;
import org.atmosphere.annotation.Resume;
import org.atmosphere.annotation.Schedule;
import org.atmosphere.annotation.Suspend;
import org.atmosphere.cpr.AtmosphereEventLifecycle;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.ClusterBroadcastFilter;
import org.atmosphere.jersey.Broadcastable;
import org.atmosphere.jersey.SuspendResponse;
import org.atmosphere.util.LoggerUtils;

public class AtmosphereFilter
implements ResourceFilterFactory {
    private static Logger logger = LoggerUtils.getLogger();
    public static final String CONTAINER_RESPONSE = "cr";
    public static final String SUSPENDED_RESOURCE = AtmosphereFilter.class.getName() + ".suspendedResource";
    public static final String RESUME_UUID = AtmosphereFilter.class.getName() + ".uuid";
    public static final String RESUME_CANDIDATES = AtmosphereFilter.class.getName() + ".resumeCandidates";
    public static final String INJECTED_BROADCASTER = AtmosphereFilter.class.getName() + "injectedBroadcaster";
    @Context
    private HttpServletRequest servletReq;
    @Context
    private UriInfo uriInfo;
    private final ConcurrentHashMap<String, AtmosphereResource<HttpServletRequest, HttpServletResponse>> resumeCandidates = new ConcurrentHashMap();

    @Override
    public List<ResourceFilter> create(AbstractMethod am) {
        Filter f;
        LinkedList<ResourceFilter> list = new LinkedList<ResourceFilter>();
        if (logger.isLoggable(Level.FINE)) {
            for (Annotation a : am.getAnnotations()) {
                logger.log(Level.FINE, "AtmosphereFilter processing annotation: " + a);
            }
        }
        if (SuspendResponse.class.isAssignableFrom(am.getMethod().getReturnType())) {
            list.addLast(new Filter(Action.SUSPEND_RESPONSE));
            return list;
        }
        if (am.isAnnotationPresent(Broadcast.class)) {
            int delay = am.getAnnotation(Broadcast.class).delay();
            Class<? extends BroadcastFilter>[] suspendTimeout = am.getAnnotation(Broadcast.class).value();
            f = am.getAnnotation(Broadcast.class).resumeOnBroadcast() ? new Filter(Action.RESUME_ON_BROADCAST, delay, 0, Suspend.SCOPE.APPLICATION, true, suspendTimeout) : new Filter(Action.BROADCAST, delay, 0, Suspend.SCOPE.APPLICATION, true, suspendTimeout);
            list.addLast(f);
            if (am.isAnnotationPresent(Cluster.class)) {
                for (Class<? extends BroadcastFilter> c : suspendTimeout = am.getAnnotation(Cluster.class).value()) {
                    try {
                        ClusterBroadcastFilter cbf = (ClusterBroadcastFilter)c.newInstance();
                        cbf.setClusterName(am.getAnnotation(Cluster.class).name());
                        f.addCluster(cbf);
                    }
                    catch (Throwable t) {
                        logger.log(Level.WARNING, "Invalid ClusterBroadcastFilter", t);
                    }
                }
            }
        }
        if (am.isAnnotationPresent(Suspend.class)) {
            long suspendTimeout = am.getAnnotation(Suspend.class).period();
            TimeUnit tu = am.getAnnotation(Suspend.class).timeUnit();
            suspendTimeout = this.translateTimeUnit(suspendTimeout, tu);
            Suspend.SCOPE scope = am.getAnnotation(Suspend.class).scope();
            boolean outputComments = am.getAnnotation(Suspend.class).outputComments();
            f = am.getAnnotation(Suspend.class).resumeOnBroadcast() ? new Filter(Action.SUSPEND_RESUME, suspendTimeout, 0, scope, outputComments) : new Filter(Action.SUSPEND, suspendTimeout, 0, scope, outputComments);
            f.setListeners(am.getAnnotation(Suspend.class).listeners());
            list.addFirst(f);
        }
        if (am.isAnnotationPresent(Resume.class)) {
            int suspendTimeout = am.getAnnotation(Resume.class).value();
            list.addFirst(new Filter(Action.RESUME, suspendTimeout));
        }
        if (am.isAnnotationPresent(Schedule.class)) {
            int period = am.getAnnotation(Schedule.class).period();
            int waitFor = am.getAnnotation(Schedule.class).waitFor();
            if (am.getAnnotation(Schedule.class).resumeOnBroadcast()) {
                list.addFirst(new Filter(Action.SCHEDULE_RESUME, period, waitFor));
            } else {
                list.addFirst(new Filter(Action.SCHEDULE, period, waitFor));
            }
        }
        return list.size() > 0 ? list : null;
    }

    private long translateTimeUnit(long period, TimeUnit tu) {
        if (period == -1L) {
            return period;
        }
        switch (tu) {
            case SECONDS: {
                return TimeUnit.MILLISECONDS.convert(period, TimeUnit.SECONDS);
            }
            case MINUTES: {
                return TimeUnit.MILLISECONDS.convert(period, TimeUnit.MINUTES);
            }
            case HOURS: {
                return TimeUnit.MILLISECONDS.convert(period, TimeUnit.HOURS);
            }
            case DAYS: {
                return TimeUnit.MILLISECONDS.convert(period, TimeUnit.DAYS);
            }
            case MILLISECONDS: {
                return period;
            }
            case MICROSECONDS: {
                return TimeUnit.MILLISECONDS.convert(period, TimeUnit.MICROSECONDS);
            }
            case NANOSECONDS: {
                return TimeUnit.MILLISECONDS.convert(period, TimeUnit.NANOSECONDS);
            }
        }
        return period;
    }

    private class Filter
    implements ResourceFilter,
    ContainerResponseFilter {
        private final Action action;
        private final long suspendTimeout;
        private final int waitFor;
        private final Suspend.SCOPE scope;
        private final Class<BroadcastFilter>[] filters;
        private Class<? extends AtmosphereResourceEventListener>[] listeners = null;
        private final boolean outputComments;
        private final ArrayList<ClusterBroadcastFilter> clusters = new ArrayList();

        protected Filter(Action action) {
            this(action, -1L);
        }

        protected Filter(Action action, long suspendTimeout) {
            this(action, suspendTimeout, 0);
        }

        protected Filter(Action action, long suspendTimeout, int waitFor) {
            this(action, suspendTimeout, waitFor, Suspend.SCOPE.APPLICATION);
        }

        protected Filter(Action action, long suspendTimeout, int waitFor, Suspend.SCOPE scope) {
            this(action, suspendTimeout, waitFor, Suspend.SCOPE.APPLICATION, true);
        }

        protected Filter(Action action, long suspendTimeout, int waitFor, Suspend.SCOPE scope, boolean outputComments) {
            this(action, suspendTimeout, waitFor, scope, outputComments, null);
        }

        protected Filter(Action action, long suspendTimeout, int waitFor, Suspend.SCOPE scope, boolean outputComments, Class<BroadcastFilter>[] filters) {
            this.action = action;
            this.suspendTimeout = suspendTimeout;
            this.scope = scope;
            this.outputComments = outputComments;
            this.waitFor = waitFor;
            this.filters = filters;
        }

        @Override
        public ContainerRequestFilter getRequestFilter() {
            return null;
        }

        @Override
        public ContainerResponseFilter getResponseFilter() {
            return this;
        }

        boolean resumeOnBroadcast(ContainerRequest request, boolean resumeOnBroadcast) {
            String transport = request.getHeaderValue("X-Atmosphere-Transport");
            if (transport != null && transport.equals("long-polling")) {
                return true;
            }
            return resumeOnBroadcast;
        }

        boolean outputJunk(ContainerRequest request, boolean outputJunk) {
            String upgrade = AtmosphereFilter.this.servletReq.getHeader("Connection");
            String transport = request.getHeaderValue("X-Atmosphere-Transport");
            if (upgrade != null && upgrade.equalsIgnoreCase("Upgrade")) {
                return false;
            }
            if (transport != null && transport.equals("long-polling")) {
                return false;
            }
            return outputJunk;
        }

        @Override
        public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
            if (response.getMappedThrowable() != null) {
                return response;
            }
            AtmosphereResource r = (AtmosphereResource)AtmosphereFilter.this.servletReq.getAttribute(AtmosphereServlet.ATMOSPHERE_RESOURCE);
            boolean sessionSupported = (Boolean)AtmosphereFilter.this.servletReq.getAttribute("org.atmosphere.cpr.AsynchronousProcessor.supportSession");
            switch (this.action) {
                case SUSPEND_RESPONSE: {
                    SuspendResponse s = (SuspendResponse)SuspendResponse.class.cast(((JResponseAsResponse)JResponseAsResponse.class.cast(response.getResponse())).getJResponse());
                    boolean outputJunk = this.outputJunk(request, s.outputComments());
                    boolean resumeOnBroadcast = this.resumeOnBroadcast(request, s.resumeOnBroadcast());
                    for (AtmosphereResourceEventListener el : s.listeners()) {
                        if (!(r instanceof AtmosphereEventLifecycle)) continue;
                        ((AtmosphereEventLifecycle)((Object)r)).addEventListener(el);
                    }
                    Broadcaster bc = s.broadcaster();
                    if (bc == null) {
                        bc = (Broadcaster)AtmosphereFilter.this.servletReq.getAttribute(INJECTED_BROADCASTER);
                    }
                    this.suspend(sessionSupported, resumeOnBroadcast, outputJunk, AtmosphereFilter.this.translateTimeUnit(s.period().value(), s.period().timeUnit()), request, response, bc, r);
                    break;
                }
                case SUSPEND: 
                case SUSPEND_RESUME: {
                    boolean outputJunk = this.outputJunk(request, this.outputComments);
                    boolean resumeOnBroadcast = this.resumeOnBroadcast(request, this.action == Action.SUSPEND_RESUME);
                    for (Class<? extends AtmosphereResourceEventListener> e : this.listeners) {
                        try {
                            AtmosphereResourceEventListener el = e.newInstance();
                            if (!(r instanceof AtmosphereEventLifecycle)) continue;
                            ((AtmosphereEventLifecycle)((Object)r)).addEventListener(el);
                        }
                        catch (Throwable t) {
                            throw new WebApplicationException(new IllegalStateException("Invalid AtmosphereResourceEventListener " + e));
                        }
                    }
                    this.suspend(sessionSupported, resumeOnBroadcast, outputJunk, this.suspendTimeout, request, response, (Broadcaster)AtmosphereFilter.this.servletReq.getAttribute(INJECTED_BROADCASTER), r);
                    break;
                }
                case RESUME: {
                    if (response.getEntity() != null) {
                        try {
                            response.write();
                        }
                        catch (IOException ex) {
                            throw new WebApplicationException(ex);
                        }
                    }
                    if (sessionSupported) {
                        r = (AtmosphereResource)AtmosphereFilter.this.servletReq.getSession().getAttribute(SUSPENDED_RESOURCE);
                    } else {
                        String path = response.getContainerRequest().getPath();
                        r = (AtmosphereResource)AtmosphereFilter.this.resumeCandidates.remove(path.substring(path.lastIndexOf("/") + 1));
                    }
                    if (r != null) {
                        this.resume(r);
                        break;
                    }
                    throw new WebApplicationException(new IllegalStateException("Unable to retrieve suspended Response. Either session-support is not enabled in atmosphere.xml or thepath used to resume is invalid."));
                }
                case BROADCAST: 
                case RESUME_ON_BROADCAST: {
                    AtmosphereResource ar = (AtmosphereResource)AtmosphereFilter.this.servletReq.getAttribute(SUSPENDED_RESOURCE);
                    if (ar != null) {
                        r = ar;
                    }
                    this.broadcast(response, r, this.suspendTimeout);
                    break;
                }
                case SCHEDULE: 
                case SCHEDULE_RESUME: {
                    Object o = response.getEntity();
                    Broadcaster b = r.getBroadcaster();
                    if (response.getEntity() instanceof Broadcastable) {
                        b = ((Broadcastable)response.getEntity()).getBroadcaster();
                        o = ((Broadcastable)response.getEntity()).getMessage();
                        response.setEntity(((Broadcastable)response.getEntity()).getResponseMessage());
                    }
                    if (response.getEntity() != null) {
                        try {
                            response.write();
                        }
                        catch (IOException ex) {
                            throw new WebApplicationException(ex);
                        }
                    }
                    if (this.action == Action.SCHEDULE_RESUME) {
                        this.configureResumeOnBroadcast(b);
                    }
                    b.scheduleFixedBroadcast(o, this.waitFor, this.suspendTimeout, TimeUnit.SECONDS);
                }
            }
            return response;
        }

        void configureResumeOnBroadcast(Broadcaster b) {
            Iterator<AtmosphereResource<?, ?>> i = b.getAtmosphereResources().iterator();
            while (i.hasNext()) {
                HttpServletRequest r = (HttpServletRequest)i.next().getRequest();
                r.setAttribute("org.atmosphere.resumeOnBroadcast", new Boolean(true));
            }
        }

        void configureFilter(Broadcaster bc) {
            if (bc == null) {
                throw new WebApplicationException(new IllegalStateException("Broadcaster cannot be null"));
            }
            BroadcasterConfig c = bc.getBroadcasterConfig();
            if (c.hasFilters()) {
                return;
            }
            for (ClusterBroadcastFilter cbf : this.clusters) {
                cbf.setBroadcaster(bc);
                c.addFilter(cbf);
            }
            BroadcastFilter f = null;
            if (this.filters != null) {
                for (Class<BroadcastFilter> filter : this.filters) {
                    try {
                        f = filter.newInstance();
                    }
                    catch (Throwable t) {
                        logger.warning("Invalid @BroadcastFilter: " + filter);
                    }
                    c.addFilter(f);
                }
            }
        }

        private void setListeners(Class<? extends AtmosphereResourceEventListener>[] listeners) {
            this.listeners = listeners;
        }

        void broadcast(ContainerResponse r, AtmosphereResource ar, long delay) {
            Object o = r.getEntity();
            Broadcaster b = ar.getBroadcaster();
            Object msg = o;
            String returnMsg = null;
            if (o instanceof Broadcastable) {
                b = ((Broadcastable)o).getBroadcaster();
                msg = ((Broadcastable)o).getMessage();
                returnMsg = ((Broadcastable)o).getResponseMessage().toString();
            }
            if (this.action == Action.RESUME_ON_BROADCAST) {
                this.configureResumeOnBroadcast(b);
            }
            if (o != null) {
                this.addFilter(b);
                try {
                    r.setEntity(msg);
                    if (msg == null) {
                        return;
                    }
                    if (delay == -1L) {
                        Future<Object> f = b.broadcast(msg);
                        if (f == null) {
                            return;
                        }
                        Object t = f.get();
                        if (o instanceof Broadcastable) {
                            r.setEntity(returnMsg);
                        }
                    } else if (delay == 0L) {
                        b.delayBroadcast(msg);
                    } else {
                        b.delayBroadcast(msg, delay, TimeUnit.SECONDS);
                    }
                }
                catch (InterruptedException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        }

        void addFilter(Broadcaster bc) {
            this.configureFilter(bc);
        }

        void resume(AtmosphereResource r) {
            AtmosphereHandler a = r.getAtmosphereConfig().getAtmosphereHandler(r.getBroadcaster());
            r.resume();
        }

        void addCluster(ClusterBroadcastFilter f) {
            this.clusters.add(f);
        }

        void suspend(boolean sessionSupported, boolean resumeOnBroadcast, boolean comments, long timeout, ContainerRequest request, ContainerResponse response, Broadcaster bc, AtmosphereResource<HttpServletRequest, HttpServletResponse> r) {
            if (response.getStatus() == 204) {
                response.setStatus(200);
            }
            BroadcasterFactory bf = (BroadcasterFactory)AtmosphereFilter.this.servletReq.getAttribute("org.atmosphere.cpr.broadcasterFactory");
            if (!sessionSupported && !resumeOnBroadcast && response.getHttpHeaders().getFirst("Location") == null) {
                String uuid = UUID.randomUUID().toString();
                response.getHttpHeaders().putSingle("Location", AtmosphereFilter.this.uriInfo.getAbsolutePathBuilder().path(uuid).build(""));
                AtmosphereFilter.this.resumeCandidates.put(uuid, r);
                AtmosphereFilter.this.servletReq.setAttribute(RESUME_UUID, uuid);
                AtmosphereFilter.this.servletReq.setAttribute(RESUME_CANDIDATES, AtmosphereFilter.this.resumeCandidates);
            }
            if (bc == null) {
                bc = r.getBroadcaster();
            }
            if (sessionSupported && AtmosphereFilter.this.servletReq.getSession().getAttribute(SUSPENDED_RESOURCE) != null) {
                AtmosphereResource cached = (AtmosphereResource)AtmosphereFilter.this.servletReq.getSession().getAttribute(SUSPENDED_RESOURCE);
                bc = cached.getBroadcaster();
                bc.removeAtmosphereResource(cached);
            }
            if (response.getEntity() instanceof Broadcastable) {
                Broadcastable b = (Broadcastable)response.getEntity();
                bc = b.getBroadcaster();
                response.setEntity(b.getResponseMessage());
                if (this.scope == Suspend.SCOPE.REQUEST && bc.getScope() != Broadcaster.SCOPE.REQUEST) {
                    bc.setScope(Broadcaster.SCOPE.REQUEST);
                }
            } else if (this.scope == Suspend.SCOPE.REQUEST && bc.getScope() != Broadcaster.SCOPE.REQUEST) {
                try {
                    String id = bc.getID();
                    bc.setID(bc.getClass().getSimpleName() + "-" + new Random().nextInt());
                    bc = bf.get();
                    bc.setScope(Broadcaster.SCOPE.REQUEST);
                    bc.setID(id);
                }
                catch (InstantiationException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
                catch (IllegalAccessException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            this.configureFilter(bc);
            r.setBroadcaster(bc);
            if (sessionSupported) {
                AtmosphereFilter.this.servletReq.getSession().setAttribute(SUSPENDED_RESOURCE, r);
                AtmosphereFilter.this.servletReq.getSession().setAttribute(AtmosphereFilter.CONTAINER_RESPONSE, response);
            }
            AtmosphereFilter.this.servletReq.setAttribute(SUSPENDED_RESOURCE, r);
            AtmosphereFilter.this.servletReq.setAttribute(AtmosphereFilter.CONTAINER_RESPONSE, response);
            if (resumeOnBroadcast) {
                AtmosphereFilter.this.servletReq.setAttribute("org.atmosphere.resumeOnBroadcast", new Boolean(true));
            }
            try {
                MediaType contentType = response.getMediaType();
                if (contentType == null && response.getEntity() != null) {
                    LinkedList<MediaType> l = new LinkedList<MediaType>();
                    l.add(request.getAcceptableMediaType(new LinkedList<MediaType>()));
                    contentType = response.getMessageBodyWorkers().getMessageBodyWriterMediaType(response.getEntity().getClass(), response.getEntityType(), response.getAnnotations(), l);
                    if (contentType == null || contentType.isWildcardType() || contentType.isWildcardSubtype()) {
                        contentType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
                    }
                }
                r.getResponse().setContentType(contentType != null ? contentType.toString() : "text/html;charset=ISO-8859-1");
                r.suspend(timeout, comments && !resumeOnBroadcast);
                if (response.getEntity() != null) {
                    response.write();
                }
            }
            catch (IOException ex) {
                throw new WebApplicationException(ex);
            }
        }
    }

    static enum Action {
        SUSPEND,
        RESUME,
        BROADCAST,
        SUSPEND_RESUME,
        SCHEDULE_RESUME,
        RESUME_ON_BROADCAST,
        NONE,
        SCHEDULE,
        SUSPEND_RESPONSE;

    }
}

