/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.async;

import com.sun.grizzly.BaseSelectionKeyHandler;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.async.AbstractAsyncQueueReader;
import com.sun.grizzly.async.AsyncQueueDataProcessor;
import com.sun.grizzly.async.OperationResult;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;

public class TCPAsyncQueueReader
extends AbstractAsyncQueueReader {
    public TCPAsyncQueueReader(SelectorHandler selectorHandler) {
        super(selectorHandler);
    }

    protected OperationResult doRead(ReadableByteChannel channel, ByteBuffer byteBuffer, AsyncQueueDataProcessor readPostProcessor, OperationResult dstResult) throws IOException {
        int totalReadBytes = 0;
        if (readPostProcessor != null) {
            ByteBuffer inputByteBuffer = null;
            int oldPosition = byteBuffer.position();
            do {
                int readBytes;
                if ((readBytes = this.doRead(channel, inputByteBuffer = readPostProcessor.getInternalByteBuffer())) > 0) {
                    readPostProcessor.process(byteBuffer);
                } else if (readBytes == -1) {
                    if (byteBuffer.position() == oldPosition) {
                        throw new EOFException();
                    }
                    break;
                }
                totalReadBytes += readBytes;
            } while (byteBuffer.hasRemaining() && !inputByteBuffer.hasRemaining());
        } else {
            totalReadBytes = this.doRead(channel, byteBuffer);
        }
        dstResult.bytesProcessed = totalReadBytes;
        dstResult.address = ((SocketChannel)channel).socket().getRemoteSocketAddress();
        return dstResult;
    }

    private int doRead(ReadableByteChannel channel, ByteBuffer byteBuffer) throws IOException {
        int readBytes = 0;
        int lastReadBytes = -1;
        try {
            do {
                if ((lastReadBytes = channel.read(byteBuffer)) > 0) {
                    readBytes += lastReadBytes;
                    continue;
                }
                if (lastReadBytes != -1 || readBytes != 0) continue;
                readBytes = -1;
            } while (lastReadBytes > 0 && byteBuffer.hasRemaining());
        }
        catch (IOException ex) {
            lastReadBytes = -1;
            throw ex;
        }
        finally {
            SelectionKeyHandler skh;
            if ((lastReadBytes == -1 || readBytes == -1) && (skh = this.selectorHandler.getSelectionKeyHandler()) instanceof BaseSelectionKeyHandler) {
                ((BaseSelectionKeyHandler)skh).notifyRemotlyClose(this.selectorHandler.keyFor((SelectableChannel)((Object)channel)));
            }
        }
        return readBytes;
    }
}

