/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.SocketChannelOutputBuffer;
import com.sun.grizzly.tcp.ActionCode;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.StaticResourcesAdapter;
import com.sun.grizzly.util.OutputWriter;
import com.sun.grizzly.util.WorkerThreadImpl;
import com.sun.grizzly.util.http.MimeHeaders;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SelectableChannel;
import java.util.Iterator;
import java.util.Queue;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCache {
    public static final String DEFAULT_SERVLET_NAME = "default";
    private final ConcurrentHashMap<String, FileCacheEntry> fileCache = new ConcurrentHashMap();
    protected static final ByteBuffer nullByteBuffer = ByteBuffer.allocate(0);
    protected static final ByteBuffer connectionCloseBB = ByteBuffer.wrap("Connection: close\r\n\r\n".getBytes());
    protected static final ByteBuffer connectionKaBB = ByteBuffer.wrap("Connection: keep-alive\r\n\r\n".getBytes());
    private static final String NEWLINE = "\r\n";
    public static final String OK = "HTTP/1.1 200 OK\r\n";
    private int port = 8080;
    private InetAddress address;
    private ScheduledThreadPoolExecutor cacheResourcesThread = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

        public Thread newThread(Runnable r) {
            return new WorkerThreadImpl(new ThreadGroup("Grizzly"), r);
        }
    });
    private Queue<FileCacheEntry> cacheManager;
    private int secondsMaxAge = -1;
    private int maxCacheEntries = 1024;
    private long minEntrySize = Long.MIN_VALUE;
    private long maxEntrySize = Long.MAX_VALUE;
    private long maxLargeFileCacheSize = Long.MAX_VALUE;
    private long maxSmallFileCacheSize = 0x100000L;
    private long mappedMemorySize = 0L;
    private long heapSize = 0L;
    private boolean isEnabled = true;
    private boolean isLargeFileCacheEnabled = true;
    private boolean isMonitoringEnabled = false;
    private int openCacheEntries = 0;
    private int maxOpenCacheEntries = 0;
    private long maxHeapCacheSize = 0L;
    private long maxMappedMemory = 0L;
    private int countHits = 0;
    private int countMisses = 0;
    private int countCacheHits;
    private int countCacheMisses;
    private int countMappedHits;
    private int countMappedMisses;
    private int headerBBSize = 4096;
    public static final int SC_NOT_MODIFIED = 304;
    public static final int SC_PRECONDITION_FAILED = 412;

    public synchronized void add(String mappedServlet, String baseDir, String requestURI, String host, MimeHeaders headers, boolean xPoweredBy) {
        if (requestURI == null || this.fileCache.get(requestURI) != null) {
            return;
        }
        if (this.fileCache.size() > this.maxCacheEntries) {
            return;
        }
        if (mappedServlet.equals(DEFAULT_SERVLET_NAME)) {
            FileCacheEntry entry;
            File file = new File(baseDir + requestURI);
            ByteBuffer bb = this.mapFile(file);
            SelectorThread selectorThread = SelectorThread.getSelector(this.address, this.port);
            String root = selectorThread.getWebAppRootPath();
            if (bb == null && !root.equals(baseDir)) {
                Adapter a = selectorThread.getAdapter();
                if (a instanceof StaticResourcesAdapter) {
                    String s;
                    Queue<String> rootFolders = ((StaticResourcesAdapter)a).getRootFolders();
                    Iterator i$ = rootFolders.iterator();
                    while (i$.hasNext() && !(file = new File((s = (String)i$.next()) + requestURI)).exists()) {
                    }
                } else {
                    file = new File(root + requestURI);
                }
                bb = this.mapFile(file);
            }
            if (bb == null) {
                bb = nullByteBuffer;
            }
            if ((entry = this.cacheManager.poll()) == null) {
                entry = new FileCacheEntry();
            }
            entry.bb = bb;
            entry.requestURI = requestURI;
            if (bb != nullByteBuffer) {
                String ifModif = headers.getHeader("Last-Modified");
                entry.lastModified = ifModif == null ? String.valueOf(file.lastModified()) : ifModif;
                entry.contentType = headers.getHeader("Content-type");
                entry.xPoweredBy = xPoweredBy;
                entry.isInHeap = file.length() < this.minEntrySize;
                entry.date = headers.getHeader("Date");
                entry.Etag = headers.getHeader("Etag");
                entry.contentLength = headers.getHeader("Content-Length");
                entry.host = host;
                this.incOpenCacheEntries();
                if (this.isMonitoringEnabled) {
                    if (this.openCacheEntries > this.maxOpenCacheEntries) {
                        this.maxOpenCacheEntries = this.openCacheEntries;
                    }
                    if (this.heapSize > this.maxHeapCacheSize) {
                        this.maxHeapCacheSize = this.heapSize;
                    }
                    if (this.mappedMemorySize > this.maxMappedMemory) {
                        this.maxMappedMemory = this.mappedMemorySize;
                    }
                }
                if (this.secondsMaxAge > 0) {
                    entry.future = this.cacheResourcesThread.schedule(entry, (long)this.secondsMaxAge, TimeUnit.SECONDS);
                }
            }
            this.fileCache.put(requestURI, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer mapFile(File file) {
        MappedByteBuffer mappedByteBuffer;
        FileChannel fileChannel = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            fileChannel = stream.getChannel();
            long size = fileChannel.size();
            if (size > this.maxEntrySize) {
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            if (size > this.minEntrySize) {
                this.addMappedMemorySize(size);
            } else {
                this.addHeapSize(size);
            }
            if (this.mappedMemorySize > this.maxLargeFileCacheSize) {
                this.subMappedMemorySize(size);
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            if (this.heapSize > this.maxSmallFileCacheSize) {
                this.subHeapSize(size);
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            MappedByteBuffer bb = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
            if (size < this.minEntrySize) {
                bb.load();
            }
            mappedByteBuffer = bb;
        }
        catch (IOException ioe) {
            ByteBuffer byteBuffer = null;
            return byteBuffer;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ignored) {}
            }
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException ignored) {}
            }
        }
        return mappedByteBuffer;
    }

    protected final FileCacheEntry map(Request request) {
        FileCacheEntry entry = null;
        if (this.fileCache.size() != 0) {
            String host;
            String uri = request.requestURI().toString();
            entry = this.fileCache.get(uri);
            if (entry != null && !(host = request.serverName().toString()).equals(entry.host)) {
                entry = null;
            }
            this.recalcCacheStatsIfMonitoring(entry);
        } else {
            this.recalcCacheStatsIfMonitoring(null);
        }
        return entry;
    }

    protected void recalcCacheStatsIfMonitoring(FileCacheEntry entry) {
        if (this.isMonitoringEnabled) {
            this.recalcCacheStats(entry);
        }
    }

    protected final void recalcCacheStats(FileCacheEntry entry) {
        if (entry != null && entry.bb != null && entry.bb != nullByteBuffer) {
            if (entry.isInHeap) {
                this.countInfoHit();
            } else {
                this.countContentHit();
            }
            this.countHit();
        } else {
            this.countMiss();
        }
    }

    public boolean sendCache(Request req) {
        if (req.method().toString().equalsIgnoreCase("HEAD")) {
            return false;
        }
        try {
            FileCacheEntry entry = this.map(req);
            if (entry != null && entry.bb != nullByteBuffer) {
                this.sendCache(req, entry);
                return true;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            SelectorThread.logger().fine("File Cache exception:" + t.getMessage());
        }
        return false;
    }

    public void setCacheManager(Queue<FileCacheEntry> cacheManager) {
        this.cacheManager = cacheManager;
    }

    protected void sendCache(Request request, FileCacheEntry entry) throws IOException {
        boolean flushBody = this.checkIfHeaders(request, entry);
        request.getResponse().setContentType(entry.contentType);
        request.getResponse().setContentLength(Integer.valueOf(entry.contentLength));
        if (flushBody) {
            ByteBuffer sliced = entry.bb.slice();
            ByteBuffer ob = ((SocketChannelOutputBuffer)request.getResponse().getOutputBuffer()).getOutputByteBuffer();
            int left = ob.remaining();
            if (left > sliced.limit()) {
                request.getResponse().action(ActionCode.ACTION_COMMIT, null);
                ob.put(sliced);
                ((SocketChannelOutputBuffer)request.getResponse().getOutputBuffer()).flushBuffer();
            } else {
                request.getResponse().flush();
                OutputWriter.flushChannel((SelectableChannel)request.getResponse().getChannel(), sliced);
            }
        } else {
            request.getResponse().flush();
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public int getFlagEnabled() {
        return this.isEnabled ? 1 : 0;
    }

    public int getSecondsMaxAge() {
        return this.secondsMaxAge;
    }

    public long getCountEntries() {
        return this.fileCache.size();
    }

    public long getMaxEntries() {
        return this.maxCacheEntries;
    }

    protected void incOpenCacheEntries() {
        ++this.openCacheEntries;
    }

    protected void decOpenCacheEntries() {
        --this.openCacheEntries;
    }

    public long getCountOpenEntries() {
        return this.openCacheEntries;
    }

    public long getMaxOpenEntries() {
        return this.maxOpenCacheEntries;
    }

    protected void addHeapSize(long size) {
        this.heapSize += size;
    }

    protected void subHeapSize(long size) {
        this.heapSize -= size;
    }

    public long getSizeHeapCache() {
        return this.heapSize;
    }

    public long getMaxHeapCacheSize() {
        return this.maxHeapCacheSize;
    }

    protected void addMappedMemorySize(long size) {
        this.mappedMemorySize += size;
    }

    protected void subMappedMemorySize(long size) {
        this.mappedMemorySize -= size;
    }

    public long getSizeMmapCache() {
        return this.mappedMemorySize;
    }

    public long getMaxMmapCacheSize() {
        return this.maxMappedMemory;
    }

    protected void countHit() {
        ++this.countHits;
    }

    public long getCountHits() {
        return this.countHits;
    }

    protected void countMiss() {
        ++this.countMisses;
    }

    public long getCountMisses() {
        return this.countMisses;
    }

    protected void countInfoHit() {
        ++this.countCacheHits;
    }

    public long getCountInfoHits() {
        return this.countCacheHits;
    }

    protected void countInfoMiss() {
        ++this.countCacheMisses;
    }

    public long getCountInfoMisses() {
        return this.countCacheMisses;
    }

    protected void countContentHit() {
        ++this.countMappedHits;
    }

    public long getCountContentHits() {
        return this.countMappedHits;
    }

    protected void countContentMiss() {
        ++this.countMappedMisses;
    }

    public int getCountContentMisses() {
        return this.countMappedMisses;
    }

    public void setIsMonitoringEnabled(boolean isMe) {
        this.isMonitoringEnabled = isMe;
    }

    public void setSecondsMaxAge(int sMaxAges) {
        this.secondsMaxAge = sMaxAges;
    }

    public void setMaxCacheEntries(int mEntries) {
        this.maxCacheEntries = mEntries;
    }

    public int getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public void setMinEntrySize(long mSize) {
        this.minEntrySize = mSize;
    }

    public long getMinEntrySize() {
        return this.minEntrySize;
    }

    public void setMaxEntrySize(long mEntrySize) {
        this.maxEntrySize = mEntrySize;
    }

    public long getMaxEntrySize() {
        return this.maxEntrySize;
    }

    public void setMaxLargeCacheSize(long mCacheSize) {
        this.maxLargeFileCacheSize = mCacheSize;
    }

    public long getMaxLargeCacheSize() {
        return this.maxLargeFileCacheSize;
    }

    public void setMaxSmallCacheSize(long mCacheSize) {
        this.maxSmallFileCacheSize = mCacheSize;
    }

    public long getMaxSmallCacheSize() {
        return this.maxSmallFileCacheSize;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setLargeFileCacheEnabled(boolean isLargeEnabled) {
        this.isLargeFileCacheEnabled = isLargeEnabled;
    }

    public boolean getLargeFileCacheEnabled() {
        return this.isLargeFileCacheEnabled;
    }

    public ConcurrentHashMap<String, FileCacheEntry> getCache() {
        return this.fileCache;
    }

    public int getHeaderBBSize() {
        return this.headerBBSize;
    }

    public void setHeaderBBSize(int headerBBSize) {
        this.headerBBSize = headerBBSize;
    }

    private boolean checkIfModifiedSince(Request request, FileCacheEntry entry) throws IOException {
        try {
            long headerValue;
            Response response = request.getResponse();
            String h = request.getHeader("If-Modified-Since");
            long l = headerValue = h == null ? -1L : Long.parseLong(h);
            if (headerValue != -1L) {
                long lastModified = Long.parseLong(entry.lastModified);
                if (request.getHeader("If-None-Match") == null && lastModified < headerValue + 1000L) {
                    response.setStatus(304);
                    response.setHeader("ETag", this.getETag(entry));
                    return false;
                }
            }
        }
        catch (IllegalArgumentException illegalArgument) {
            return true;
        }
        return true;
    }

    private boolean checkIfNoneMatch(Request request, FileCacheEntry entry) throws IOException {
        Response response = request.getResponse();
        String eTag = this.getETag(entry);
        String headerValue = request.getHeader("If-None-Match");
        if (headerValue != null) {
            boolean conditionSatisfied = false;
            if (!headerValue.equals("*")) {
                StringTokenizer commaTokenizer = new StringTokenizer(headerValue, ",");
                while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                    String currentToken = commaTokenizer.nextToken();
                    if (!currentToken.trim().equals(eTag)) continue;
                    conditionSatisfied = true;
                }
            } else {
                conditionSatisfied = true;
            }
            if (conditionSatisfied) {
                if ("GET".equals(request.method().getString()) || "HEAD".equals(request.method().getString())) {
                    response.setStatus(304);
                    response.setHeader("ETag", eTag);
                    return false;
                }
                response.setStatus(412);
                return false;
            }
        }
        return true;
    }

    protected boolean checkIfUnmodifiedSince(Request request, FileCacheEntry entry) throws IOException {
        try {
            long headerValue;
            Response response = request.getResponse();
            long lastModified = Long.parseLong(entry.lastModified);
            String h = request.getHeader("If-Unmodified-Since");
            long l = headerValue = h == null ? -1L : Long.parseLong(h);
            if (headerValue != -1L && lastModified >= headerValue + 1000L) {
                response.setStatus(412);
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgument) {
            return true;
        }
        return true;
    }

    private String getETag(FileCacheEntry entry) {
        String result = entry.Etag;
        if (result == null) {
            long contentLength = Long.parseLong(entry.contentLength);
            long lastModified = Long.parseLong(entry.lastModified);
            if (contentLength >= 0L || lastModified >= 0L) {
                entry.Etag = result = "W/\"" + contentLength + "-" + lastModified + "\"";
            }
        }
        return result;
    }

    protected boolean checkIfHeaders(Request request, FileCacheEntry entry) throws IOException {
        return this.checkIfMatch(request, entry) && this.checkIfModifiedSince(request, entry) && this.checkIfNoneMatch(request, entry) && this.checkIfUnmodifiedSince(request, entry);
    }

    protected boolean checkIfMatch(Request request, FileCacheEntry entry) throws IOException {
        Response response = request.getResponse();
        String eTag = this.getETag(entry);
        String headerValue = request.getHeader("If-Match");
        if (headerValue != null && headerValue.indexOf(42) == -1) {
            StringTokenizer commaTokenizer = new StringTokenizer(headerValue, ",");
            boolean conditionSatisfied = false;
            while (!conditionSatisfied && commaTokenizer.hasMoreTokens()) {
                String currentToken = commaTokenizer.nextToken();
                if (!currentToken.trim().equals(eTag)) continue;
                conditionSatisfied = true;
            }
            if (!conditionSatisfied) {
                response.setStatus(412);
                return false;
            }
        }
        return true;
    }

    public final class FileCacheEntry
    implements Runnable {
        public String host;
        public String requestURI;
        public String lastModified = "";
        public String contentType;
        public ByteBuffer bb;
        public boolean xPoweredBy;
        public boolean isInHeap = false;
        public String date;
        public String Etag;
        public Future future;
        public String contentLength;
        public String keepAlive;

        public void run() {
            FileCache.this.fileCache.remove(this.requestURI);
            if (this.requestURI == null) {
                return;
            }
            if (this.bb != null) {
                if (this.bb.position() != 0) {
                    this.future = FileCache.this.cacheResourcesThread.schedule(this, 10L, TimeUnit.SECONDS);
                    return;
                }
                if (!this.isInHeap) {
                    FileCache.this.subMappedMemorySize(this.bb.limit());
                } else {
                    FileCache.this.subHeapSize(this.bb.limit());
                }
                this.bb = null;
                FileCache.this.decOpenCacheEntries();
            }
            if (this.future != null) {
                this.future.cancel(false);
                this.future = null;
            }
            this.requestURI = null;
            FileCache.this.cacheManager.offer(this);
        }
    }
}

