/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.servlet.deployer;

import com.sun.grizzly.arp.AsyncHandler;
import com.sun.grizzly.arp.DefaultAsyncHandler;
import com.sun.grizzly.comet.CometAsyncFilter;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.deployer.DeployException;
import com.sun.grizzly.http.deployer.DeploymentID;
import com.sun.grizzly.http.embed.GrizzlyWebServer;
import com.sun.grizzly.http.servlet.deployer.WarDeployer;
import com.sun.grizzly.http.servlet.deployer.WarDeploymentConfiguration;
import com.sun.grizzly.http.servlet.deployer.WebAppAdapter;
import com.sun.grizzly.http.servlet.deployer.comparator.WarFileComparator;
import com.sun.grizzly.http.servlet.deployer.conf.ConfigurationParser;
import com.sun.grizzly.http.servlet.deployer.conf.DeployableConfiguration;
import com.sun.grizzly.http.servlet.deployer.conf.DeployerServerConfiguration;
import com.sun.grizzly.http.servlet.deployer.watchdog.Watchdog;
import com.sun.grizzly.http.servlet.deployer.watchdog.WatchedFile;
import com.sun.grizzly.http.webxml.WebappLoader;
import com.sun.grizzly.http.webxml.schema.WebApp;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.util.ExpandJar;
import com.sun.grizzly.websockets.WebSocketAsyncFilter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyWebServerDeployer {
    private static Logger logger = Logger.getLogger(GrizzlyWebServerDeployer.class.getName());
    protected static final String ROOT = "/";
    protected static final String WEB_XML = "web.xml";
    public static final String WEB_XML_PATH = File.separator + "WEB-INF" + File.separator + "web.xml";
    protected GrizzlyWebServer ws = null;
    protected String webxmlPath;
    protected WarDeployer deployer = new WarDeployer();
    protected URLClassLoader serverLibLoader;
    protected WebApp webDefault;
    protected Map<String, DeploymentID> deployedApplicationMap = new HashMap<String, DeploymentID>();
    protected ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    protected long watchInterval = -1L;
    protected String watchDogFolder;
    protected Map<String, WatchedFile> watchedFileMap = new HashMap<String, WatchedFile>();

    public static void main(String[] args) {
        new GrizzlyWebServerDeployer().launch(GrizzlyWebServerDeployer.init(args));
    }

    public static DeployerServerConfiguration init(String[] args) {
        DeployerServerConfiguration cfg = ConfigurationParser.parseOptions(args, GrizzlyWebServerDeployer.class.getCanonicalName());
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, cfg.toString());
        }
        return cfg;
    }

    public void launch(DeployerServerConfiguration conf) {
        try {
            this.ws = new GrizzlyWebServer(conf.port);
            this.configureServer(conf);
            this.deployApplications(conf);
            if (!conf.waitToStart) {
                this.start();
            }
            if (this.watchInterval > 0L) {
                this.executor.submit(new Watchdog(this));
                this.executor.schedule(new Watchdog(this), this.watchInterval, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error while launching deployer.", e);
        }
    }

    public String getWorkFolder() {
        String workFolder = this.deployer.getWorkFolder();
        if (workFolder == null) {
            workFolder = ".";
        }
        return workFolder;
    }

    public String getWatchDogFolder() {
        return this.watchDogFolder;
    }

    public void deployApplications(DeployerServerConfiguration conf) throws Exception {
        if (conf.applicationsList != null && !conf.applicationsList.isEmpty()) {
            for (DeployableConfiguration location : conf.applicationsList) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Application path = " + location.location);
                }
                this.deployApplication(location, this.serverLibLoader, this.webDefault);
            }
        }
    }

    public void deployApplication(DeployableConfiguration conf) throws Exception {
        this.deployApplication(conf, this.serverLibLoader, this.webDefault);
    }

    public void undeployApplication(String context) throws Exception {
        if (this.deployedApplicationMap.containsKey(context)) {
            this.getWarDeployer().undeploy(this.ws, this.deployedApplicationMap.get(context));
            this.deployedApplicationMap.remove(context);
            this.watchedFileMap.remove(context);
        }
    }

    public void deployApplication(DeployableConfiguration conf, URLClassLoader serverLibLoader, WebApp webDefault) throws Exception {
        if (conf.location.endsWith(".war")) {
            this.deployWar(conf, serverLibLoader, webDefault);
        } else if (conf.location.endsWith(".xml")) {
            this.deployServlet(conf, serverLibLoader, webDefault);
        } else {
            Collection<File> files = GrizzlyWebServerDeployer.getFiles(conf.location, conf.forceWarDeployment);
            if (files != null) {
                for (File file : files) {
                    if (file.getName().endsWith(".war")) {
                        this.deployWar(new DeployableConfiguration(file.getPath()), serverLibLoader, webDefault);
                        continue;
                    }
                    if (GrizzlyWebServerDeployer.isWebXmlInWebInf(conf.location)) {
                        this.deployExpandedWar(String.format("%s%s", conf.location, File.separator), serverLibLoader, webDefault);
                        continue;
                    }
                    File webxmlFile2 = new File(String.format("%s%s%s", conf.location, File.separator, WEB_XML));
                    if (webxmlFile2.exists()) {
                        this.deployServlet(new DeployableConfiguration(webxmlFile2.getPath()), serverLibLoader, webDefault);
                        continue;
                    }
                    File webapp = new File(String.format("%s%s%s", file.getPath(), File.separator, WEB_XML_PATH));
                    if (webapp.exists()) {
                        this.deployExpandedWar(String.format("%s%s", file.getPath(), File.separator), serverLibLoader, webDefault);
                        continue;
                    }
                    this.deployCustom(String.format("%s%s", file.getPath(), File.separator), serverLibLoader, webDefault);
                }
            }
        }
    }

    private static boolean isWebXmlInWebInf(String location) {
        return new File(String.format("%s%s%s", location, File.separator, WEB_XML_PATH)).exists();
    }

    protected WarDeployer getWarDeployer() {
        return this.deployer;
    }

    public void deployWar(DeployableConfiguration conf, URLClassLoader serverLibLoader, WebApp defaultWebApp) throws DeployException {
        int i;
        String ctx = conf.forcedContext;
        if (ctx == null && (i = (ctx = GrizzlyWebServerDeployer.getContext(conf.location)).lastIndexOf(46)) > 0) {
            ctx = ctx.substring(0, i);
        }
        WarDeploymentConfiguration config = new WarDeploymentConfiguration(ctx, serverLibLoader, defaultWebApp, conf);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, String.format("Configuration for deployment: %s.", config));
        }
        this.deployedApplicationMap.put(ctx, this.deployWar(this.getWarDeployer(), new File(conf.location).toURI(), config));
    }

    private DeploymentID deployWar(WarDeployer warDeployer, URI toDeploy, WarDeploymentConfiguration config) throws DeployException {
        return warDeployer.deploy(this.ws, toDeploy, config);
    }

    private URLClassLoader createServerLibClassLoader(String libraryPath) throws IOException {
        String[] libPaths;
        String separator = System.getProperty("os.name").toLowerCase().startsWith("win") ? ROOT : "//";
        ArrayList<URL> urls = new ArrayList<URL>();
        if (libraryPath != null && (libPaths = libraryPath.split(File.pathSeparator)) != null && libPaths.length > 0) {
            for (String libPath : libPaths) {
                File libFolder = new File(libPath);
                if (!libFolder.exists() || !libFolder.isDirectory()) continue;
                for (File file : libFolder.listFiles(new ExtensionFileNameFilter(Arrays.asList(".jar")))) {
                    urls.add(new URL(String.format("jar:file:%s%s!/", separator, file.getCanonicalPath().replace('\\', '/'))));
                }
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, String.format("Server library path contains=%s", urls));
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]));
    }

    private void deployServlet(DeployableConfiguration conf, URLClassLoader serverLibLoader, WebApp defaultWebApp) throws Exception {
        String ctx = conf.forcedContext;
        if (ctx == null) {
            ctx = GrizzlyWebServerDeployer.getContext(ROOT);
        }
        Map.Entry<String, URLClassLoader> loaderEntry = GrizzlyWebServerDeployer.explodeAndCreateWebAppClassLoader(null, serverLibLoader);
        this.webxmlPath = loaderEntry.getKey();
        this.deploy(null, ctx, conf.location, loaderEntry.getValue(), defaultWebApp);
    }

    private void deployExpandedWar(String location, URLClassLoader serverLibLoader, WebApp defaultWebApp) throws Exception {
        Map.Entry<String, URLClassLoader> loaderEntry = GrizzlyWebServerDeployer.explodeAndCreateWebAppClassLoader(location, serverLibLoader);
        this.webxmlPath = loaderEntry.getKey();
        this.deploy(this.webxmlPath, GrizzlyWebServerDeployer.getContext(this.webxmlPath), this.webxmlPath + WEB_XML_PATH, loaderEntry.getValue(), defaultWebApp);
    }

    private static Collection<File> getFiles(String location, boolean forceWarDeployment) {
        File[] files;
        HashMap<String, File> result = null;
        File folder = GrizzlyWebServerDeployer.getFileNotTrailingSlash(location);
        if (folder.exists() && folder.isDirectory() && (files = folder.listFiles(new DeployableFilter())) != null && files.length != 0) {
            Arrays.sort(files, new WarFileComparator());
            result = new HashMap<String, File>(files.length);
            for (File file : files) {
                String name;
                String filename = file.getName();
                if (file.isDirectory()) {
                    result.put(filename, file);
                    continue;
                }
                if (filename.endsWith(".war") && !forceWarDeployment) {
                    name = filename.substring(0, filename.length() - ".war".length());
                    if (result.containsKey(name)) {
                        logger.log(Level.INFO, "War file skipped");
                        continue;
                    }
                    result.put(name, file);
                    continue;
                }
                if (filename.endsWith(".war") && forceWarDeployment) {
                    name = filename.substring(0, filename.length() - ".war".length());
                    if (result.containsKey(name)) {
                        result.remove(name);
                    }
                    result.put(name, file);
                    continue;
                }
                result.put(filename, file);
            }
        }
        return result == null ? null : result.values();
    }

    private static File getFileNotTrailingSlash(String name) {
        return new File(GrizzlyWebServerDeployer.removeTrailingPathSeparator(name));
    }

    public static String getContext(String path) {
        String result;
        if (path == null || path.trim().length() == 0) {
            result = ROOT;
        } else {
            result = GrizzlyWebServerDeployer.removeTrailingPathSeparator(GrizzlyWebServerDeployer.fixPath(path));
            int lastIndex = result.lastIndexOf(ROOT);
            if (lastIndex > 0) {
                result = ROOT + result.substring(lastIndex + 1);
            } else if (lastIndex == -1) {
                result = ROOT + result;
            }
        }
        return result;
    }

    public static String fixPath(String path) {
        return path.replaceAll("[/\\\\]+", "\\/").replaceAll("\\\\", "\\/");
    }

    private static String removeTrailingPathSeparator(String path) {
        String result = path;
        if (result.endsWith(ROOT) && result.length() > 1) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private static String getRootFolder(String location, String context) {
        String result;
        if (location == null || context == null) {
            result = location;
        } else {
            result = GrizzlyWebServerDeployer.fixPath(location);
            int index = result.lastIndexOf(context);
            if (index > -1) {
                result = result.substring(0, index);
            }
        }
        return result;
    }

    protected void deployCustom(String location, URLClassLoader serverLibLoader, WebApp defaultSupportWebApp) throws Exception {
        Map.Entry<String, URLClassLoader> loaderEntry = GrizzlyWebServerDeployer.explodeAndCreateWebAppClassLoader(location, serverLibLoader);
        this.webxmlPath = loaderEntry.getKey();
        String context = GrizzlyWebServerDeployer.getContext(this.webxmlPath);
        String root = GrizzlyWebServerDeployer.getRootFolder(location, context);
        this.deploy(root, context, root + context, loaderEntry.getValue(), defaultSupportWebApp);
    }

    public void deploy(String rootFolder, String context, String path, URLClassLoader webAppCL, WebApp superApp) throws Exception {
        String root = rootFolder;
        if (rootFolder != null) {
            root = GrizzlyWebServerDeployer.fixPath(rootFolder);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Will deploy application path=" + path);
        }
        if (path != null) {
            WebApp webApp = path.toLowerCase().endsWith(".xml") ? GrizzlyWebServerDeployer.parseWebXml(path) : new WebApp();
            try {
                for (Map.Entry<GrizzlyAdapter, Set<String>> grizzlyAdapterSetEntry : new WebAppAdapter(root, context, webApp, webAppCL, superApp).getToRegister().entrySet()) {
                    this.ws.addGrizzlyAdapter(grizzlyAdapterSetEntry.getKey(), grizzlyAdapterSetEntry.getValue().toArray(new String[grizzlyAdapterSetEntry.getValue().size()]));
                }
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Not a valid WebApp, will be ignored : path=" + path);
                logger.log(Level.INFO, "Error follows.", e);
            }
        }
    }

    public static Map.Entry<String, URLClassLoader> explodeAndCreateWebAppClassLoader(String appliPath, final URLClassLoader serverLibLoader) throws IOException {
        File libFiles;
        if (appliPath != null && appliPath.endsWith(File.pathSeparator)) {
            appliPath = appliPath + File.pathSeparator;
        }
        String separator = System.getProperty("os.name").toLowerCase().startsWith("win") ? ROOT : "//";
        final ArrayList<URL> classpathList = new ArrayList<URL>();
        String path = null;
        URL appRoot = null;
        URL classesURL = null;
        if (appliPath != null && (appliPath.endsWith(".war") || appliPath.endsWith(".jar"))) {
            File file = new File(appliPath);
            appRoot = new URL("jar:file:" + file.getCanonicalPath() + "!/");
            classesURL = new URL("jar:file:" + file.getCanonicalPath() + "!/WEB-INF/classes/");
            path = ExpandJar.expand(appRoot);
        } else if (appliPath != null) {
            path = appliPath;
            classesURL = new URL("file:///" + path + "WEB-INF/classes/");
            appRoot = new URL("file:///" + path);
        }
        if (appliPath != null && (libFiles = new File(new File(path).getAbsolutePath() + File.separator + "WEB-INF" + File.separator + "lib")).exists() && libFiles.isDirectory()) {
            for (File file : libFiles.listFiles()) {
                classpathList.add(new URL(String.format("jar:file:%s%s!/", separator, file.toString().replace('\\', '/'))));
            }
        }
        if (appliPath != null) {
            classpathList.add(appRoot);
            classpathList.add(classesURL);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, String.format("Classpath contains=%s", classpathList));
        }
        if (path != null && !path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        final String finalPath = path;
        return new Map.Entry<String, URLClassLoader>(){

            @Override
            public String getKey() {
                return finalPath;
            }

            @Override
            public URLClassLoader getValue() {
                return new URLClassLoader(classpathList.toArray(new URL[classpathList.size()]), (ClassLoader)serverLibLoader);
            }

            @Override
            public URLClassLoader setValue(URLClassLoader value) {
                throw new UnsupportedOperationException("This is read-only Entry");
            }
        };
    }

    private static WebApp parseWebXml(String webxml) throws Exception {
        return webxml == null ? null : WebappLoader.load(webxml);
    }

    private void configureServer(DeployerServerConfiguration conf) throws Exception {
        AsyncHandler asyncHandler;
        SelectorThread st;
        this.serverLibLoader = this.createServerLibClassLoader(conf.libraryPath);
        this.webDefault = GrizzlyWebServerDeployer.getDefaultSupportWebApp(conf.webdefault);
        if (conf.cometEnabled) {
            st = this.ws.getSelectorThread();
            asyncHandler = new DefaultAsyncHandler();
            asyncHandler.addAsyncFilter(new CometAsyncFilter());
            st.setAsyncHandler(asyncHandler);
            st.setEnableAsyncExecution(true);
        }
        if (conf.websocketsEnabled) {
            st = this.ws.getSelectorThread();
            asyncHandler = st.getAsyncHandler();
            if (asyncHandler == null) {
                asyncHandler = new DefaultAsyncHandler();
                st.setAsyncHandler(asyncHandler);
            }
            st.getAsyncHandler().addAsyncFilter(new WebSocketAsyncFilter());
            st.setEnableAsyncExecution(true);
        }
        if (conf.ajpEnabled) {
            this.ws.enableProtocol(GrizzlyWebServer.PROTOCOL.AJP);
        }
        if (conf.watchInterval > 0L) {
            this.watchInterval = conf.watchInterval;
        }
        if (conf.watchFolder != null) {
            this.watchDogFolder = conf.watchFolder;
        }
        this.deployer.setWorkFolder(new File("work").getAbsolutePath());
        WarDeployer.cleanup(this.deployer.getWorkFolder());
    }

    public void stop() {
        if (this.ws != null) {
            this.ws.stop();
        }
        this.executor.shutdownNow();
    }

    public void start() throws IOException {
        if (this.ws != null) {
            this.ws.start();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static WebApp getDefaultSupportWebApp(String webdefault) throws Exception {
        WebApp result = new WebApp();
        if (webdefault == null) return result;
        File webdefaultFile = GrizzlyWebServerDeployer.getFileNotTrailingSlash(webdefault);
        if (!webdefaultFile.exists()) throw new IllegalArgumentException("Webdefault location is not existent.");
        if (!webdefaultFile.isDirectory()) return GrizzlyWebServerDeployer.extractWebAppAndMerge(result, webdefaultFile.getPath());
        File[] xmlFiles = webdefaultFile.listFiles(new ExtensionFileNameFilter(Arrays.asList(".xml")));
        if (xmlFiles == null) throw new IllegalArgumentException("Webdefault is empty directory.");
        if (xmlFiles.length == 0) throw new IllegalArgumentException("Webdefault is empty directory.");
        File[] arr$ = xmlFiles;
        int len$ = arr$.length;
        int i$ = 0;
        while (i$ < len$) {
            File xmlFile = arr$[i$];
            result = GrizzlyWebServerDeployer.extractWebAppAndMerge(result, xmlFile.getPath());
            ++i$;
        }
        return result;
    }

    private static WebApp extractWebAppAndMerge(WebApp mergeTo, String webxmlLocation) throws Exception {
        WebApp webApp = GrizzlyWebServerDeployer.parseWebXml(webxmlLocation);
        if (webApp == null) {
            throw new Exception("Invalid webdefault: " + webxmlLocation);
        }
        return mergeTo.mergeWith(webApp);
    }

    public Map<String, WatchedFile> getWatchedFileMap() {
        return this.watchedFileMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtensionFileNameFilter
    implements FilenameFilter {
        private List<String> extensions;

        public ExtensionFileNameFilter(List<String> extensions) {
            this.extensions = Collections.unmodifiableList(extensions);
        }

        @Override
        public boolean accept(File dir, String name) {
            boolean result = false;
            for (String extension : this.extensions) {
                if (!name.endsWith(extension)) continue;
                result = true;
                break;
            }
            return result;
        }
    }

    public static class DeployableFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            File file;
            boolean result = name.endsWith(".war") ? true : (file = new File(dir + File.separator + name)).exists() && file.isDirectory();
            return result;
        }
    }
}

