/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.InternalInputBuffer;
import com.sun.grizzly.tcp.http11.InternalOutputBuffer;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.websockets.BaseWebSocket;
import com.sun.grizzly.websockets.WebSocketListener;
import java.io.IOException;
import java.nio.channels.SocketChannel;

public class BaseServerWebSocket
extends BaseWebSocket {
    private SocketChannel channel;
    private final Request request;
    private final Response response;
    private final InternalInputBuffer inputBuffer;
    private final InternalOutputBuffer outputBuffer;

    public BaseServerWebSocket(WebSocketListener listener, Request request, Response response) {
        this.request = request;
        this.response = response;
        this.inputBuffer = (InternalInputBuffer)request.getInputBuffer();
        this.outputBuffer = (InternalOutputBuffer)response.getOutputBuffer();
        this.add(listener);
    }

    protected void unframe() throws IOException {
        ByteChunk chunk = new ByteChunk(8192);
        while (this.inputBuffer.doRead(chunk, this.request) > 0) {
            this.unframe(chunk.toByteBuffer());
        }
    }

    protected void write(byte[] bytes) throws IOException {
        ByteChunk chunk = new ByteChunk(bytes.length);
        chunk.setBytes(bytes, 0, bytes.length);
        this.outputBuffer.doWrite(chunk, this.response);
        this.outputBuffer.flush();
    }
}

