/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.handler;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.util.LoggerUtils;

public abstract class AbstractReflectorAtmosphereHandler
implements AtmosphereHandler<HttpServletRequest, HttpServletResponse> {
    @Override
    public void onStateChange(AtmosphereResourceEvent<HttpServletRequest, HttpServletResponse> event) throws IOException {
        Object o = event.getMessage();
        if (o == null || event.isCancelled()) {
            return;
        }
        if (event.getResource().getSerializer() != null) {
            try {
                event.getResource().getSerializer().write(event.getResource().getResponse().getOutputStream(), o);
            }
            catch (Throwable ex) {
                LoggerUtils.getLogger().log(Level.WARNING, "Serializer exception", ex);
            }
        } else {
            boolean isUsingStream = false;
            try {
                event.getResource().getResponse().getWriter();
            }
            catch (IllegalStateException e) {
                isUsingStream = true;
            }
            if (o instanceof List) {
                for (String s : (List)o) {
                    if (isUsingStream) {
                        event.getResource().getResponse().getOutputStream().write(s.getBytes());
                        event.getResource().getResponse().getOutputStream().flush();
                        continue;
                    }
                    event.getResource().getResponse().getWriter().write(s);
                    event.getResource().getResponse().getWriter().flush();
                }
            } else if (isUsingStream) {
                event.getResource().getResponse().getOutputStream().write(o.toString().getBytes());
                event.getResource().getResponse().getOutputStream().flush();
            } else {
                event.getResource().getResponse().getWriter().write(o.toString());
                event.getResource().getResponse().getWriter().flush();
            }
            Boolean resumeOnBroadcast = (Boolean)event.getResource().getRequest().getAttribute("org.atmosphere.resumeOnBroadcast");
            if (resumeOnBroadcast != null && resumeOnBroadcast.booleanValue()) {
                event.getResource().resume();
            }
        }
    }
}

