/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jersey;

import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.util.LoggerUtils;

public class Broadcastable {
    private final Object message;
    private final Broadcaster b;
    private final Object callerMessage;

    public Broadcastable(Broadcaster b) {
        this.b = b;
        this.message = "";
        this.callerMessage = "";
    }

    public Broadcastable(Object message, Broadcaster b) {
        this.b = b;
        this.message = message;
        this.callerMessage = message;
    }

    public Broadcastable(Object message, Object callerMessage, Broadcaster b) {
        this.b = b;
        this.message = message;
        this.callerMessage = callerMessage;
    }

    public Object broadcast() {
        try {
            return this.b.broadcast(this.message).get();
        }
        catch (InterruptedException ex) {
            LoggerUtils.getLogger().log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            LoggerUtils.getLogger().log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public Object getMessage() {
        return this.message;
    }

    public Broadcaster getBroadcaster() {
        return this.b;
    }

    public Object getResponseMessage() {
        return this.callerMessage;
    }
}

