/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.websockets.FrameType;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public class DataFrame {
    private static final Logger logger = Logger.getLogger("websocket");
    private String payload;
    private byte[] bytes;
    private FrameType type;

    public DataFrame(ByteBuffer buffer) throws IOException {
        byte leading = buffer.get();
        for (FrameType frameType : FrameType.values()) {
            if (!frameType.accept(leading)) continue;
            this.type = frameType;
            this.bytes = this.type.unframe(buffer);
        }
    }

    public DataFrame(String data) {
        this.type = FrameType.TEXT;
        this.payload = data;
        try {
            this.bytes = data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public FrameType getType() {
        return this.type;
    }

    public String getTextPayload() {
        if (this.payload == null && this.bytes != null) {
            try {
                this.payload = new String(this.bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return this.payload;
    }

    public byte[] getBinaryPayload() {
        return this.bytes;
    }

    public byte[] frame() {
        return this.frame(this.type);
    }

    public byte[] frame(FrameType type) {
        return type.frame(this.bytes);
    }

    public String toString() {
        return this.payload;
    }
}

