/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jersey.util;

import com.sun.jersey.spi.container.ContainerResponse;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.atmosphere.cpr.AtmosphereEventLifecycle;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.jersey.AtmosphereFilter;
import org.atmosphere.util.LoggerUtils;

public final class JerseyBroadcasterUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void broadcast(AtmosphereResource<?, ?> r, AtmosphereResourceEvent e) {
        HttpServletRequest res = (HttpServletRequest)r.getRequest();
        try {
            ContainerResponse cr = (ContainerResponse)res.getAttribute("cr");
            if (cr == null) {
                LoggerUtils.getLogger().log(Level.SEVERE, "Unexpected state. ContainerResponse cannot be null. The connection hasn't been suspended yet");
                return;
            }
            MediaType m = (MediaType)cr.getHttpHeaders().getFirst("Content-Type");
            if (e.getMessage() instanceof Response) {
                cr.setResponse((Response)e.getMessage());
                cr.getHttpHeaders().add("Content-Type", m);
                cr.write();
            } else if (e.getMessage() instanceof List) {
                for (String msg : (List)e.getMessage()) {
                    cr.setResponse(Response.ok(msg).build());
                    cr.getHttpHeaders().add("Content-Type", m);
                    cr.write();
                    cr.getOutputStream().flush();
                }
            } else {
                cr.setResponse(Response.ok(e.getMessage()).build());
                cr.getHttpHeaders().add("Content-Type", m);
                cr.write();
            }
            cr.getOutputStream().flush();
        }
        catch (Throwable t) {
            JerseyBroadcasterUtil.onException(t, r);
        }
        finally {
            Boolean resumeOnBroadcast = (Boolean)res.getAttribute("org.atmosphere.resumeOnBroadcast");
            if (resumeOnBroadcast != null && resumeOnBroadcast.booleanValue()) {
                String uuid = (String)res.getAttribute(AtmosphereFilter.RESUME_UUID);
                if (uuid != null && res.getAttribute(AtmosphereFilter.RESUME_CANDIDATES) != null) {
                    ((ConcurrentHashMap)res.getAttribute(AtmosphereFilter.RESUME_CANDIDATES)).remove(uuid);
                }
                r.resume();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void onException(Throwable t, AtmosphereResource<?, ?> r) {
        try {
            if (LoggerUtils.getLogger().isLoggable(Level.FINE)) {
                LoggerUtils.getLogger().log(Level.FINE, "", t);
            }
            if (t instanceof IOException && r instanceof AtmosphereEventLifecycle) {
                ((AtmosphereEventLifecycle)((Object)r)).notifyListeners(new AtmosphereResourceEventImpl((AtmosphereResourceImpl)r, true, false));
                ((AtmosphereEventLifecycle)((Object)r)).removeEventListeners();
            }
        }
        finally {
            r.getBroadcaster().removeAtmosphereResource(r);
        }
    }
}

