/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.grizzly;

import com.sun.grizzly.http.servlet.ServletAdapter;
import com.sun.grizzly.http.servlet.deployer.WarDeployer;
import com.sun.grizzly.http.servlet.deployer.WarDeploymentConfiguration;
import com.sun.grizzly.http.servlet.deployer.WebAppAdapter;
import java.io.File;
import java.io.FileFilter;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.grizzly.AtmosphereAdapter;
import org.atmosphere.grizzly.AtmosphereWebAppAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereWarDeployer
extends WarDeployer {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereWarDeployer.class);
    private List<AtmosphereHandler> atmosphereHandlerList;

    @Override
    protected WebAppAdapter getWebAppAdapter(ClassLoader webAppCL) {
        try {
            this.atmosphereHandlerList = this.findAtmosphereHandlers((URLClassLoader)webAppCL);
        }
        catch (Throwable t) {
            logger.warn("Error finding AtmosphereHandlers", t);
        }
        return new AtmosphereWebAppAdapter();
    }

    @Override
    protected void setExtraConfig(ServletAdapter sa, WarDeploymentConfiguration configuration) {
        AtmosphereAdapter adapter = (AtmosphereAdapter)sa;
        if (this.atmosphereHandlerList != null && !this.atmosphereHandlerList.isEmpty()) {
            for (AtmosphereHandler handler : this.atmosphereHandlerList) {
                adapter.addAtmosphereHandler(adapter.getServletPath(), handler);
            }
        }
    }

    public List<AtmosphereHandler> findAtmosphereHandlers(URLClassLoader classLoader) throws Exception {
        if (classLoader == null) {
            return null;
        }
        LinkedList<AtmosphereHandler> atmosphereHandlerList = new LinkedList<AtmosphereHandler>();
        URL[] urls = classLoader.getURLs();
        ArrayList<String> list = new ArrayList<String>();
        for (URL url : urls) {
            if ("file".equals(url.getProtocol())) {
                if (!url.getPath().endsWith("WEB-INF/lib/") && !url.getPath().endsWith("WEB-INF/classes/")) continue;
                File file = null;
                try {
                    file = new File(url.toURI());
                }
                catch (Exception e) {
                    URI uri = new URI(url.toString());
                    file = uri.getAuthority() == null ? new File(uri) : new File("//" + uri.getAuthority() + url.getFile());
                }
                if (file == null || !file.isDirectory()) continue;
                list.addAll(this.listFilesAndFolders(file.getCanonicalPath(), 0));
                continue;
            }
            if (!"jar".equals(url.getProtocol())) continue;
            JarURLConnection conn = (JarURLConnection)url.openConnection();
            JarFile jar = conn.getJarFile();
            Enumeration<JarEntry> en = jar.entries();
            while (en.hasMoreElements()) {
                JarEntry jarEntry = en.nextElement();
                String classname = jarEntry.getName();
                if (!classname.endsWith(".class")) continue;
                classname = classname.replace("WEB-INF/classes/", "").replace('\\', '/').replace('/', '.').replace('$', '.');
                list.add(classname);
            }
        }
        logger.debug("Number of classes to check for AtmosphereHandler: {}", list.size());
        for (String classname : list) {
            try {
                Object obj;
                Class<?> clazz = classLoader.loadClass(classname.substring(0, classname.indexOf(".class")));
                if (!AtmosphereHandler.class.isAssignableFrom(clazz) || !((obj = clazz.newInstance()) instanceof AtmosphereHandler) || classname.startsWith("org.atmosphere.websocket") || classname.startsWith("org.atmosphere.cpr") || classname.startsWith("org.atmosphere.handler")) continue;
                atmosphereHandlerList.add((AtmosphereHandler)obj);
            }
            catch (Throwable t) {}
        }
        return atmosphereHandlerList;
    }

    public List<String> listFilesAndFolders(String folder, int tabCounter) {
        ArrayList<String> list = new ArrayList<String>();
        File file = new File(folder);
        if (!file.exists() || !file.isDirectory()) {
            logger.info("Parameter is not a directory: {}", (Object)folder);
            return list;
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().endsWith(".class");
            }
        });
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                list.addAll(this.listFilesAndFolders(fileArray[i].getAbsolutePath(), tabCounter + 1));
                continue;
            }
            String toSkip = "WEB-INF" + File.separator + "classes" + File.separator;
            String path = fileArray[i].getPath();
            path = path.substring(path.indexOf(toSkip) + toSkip.length());
            String classname = path.replace('\\', '/').replace('/', '.');
            list.add(classname);
        }
        --tabCounter;
        return list;
    }
}

