/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AtmosphereConfigReader {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereConfigReader.class);
    private final Map<String, String> tuples = new HashMap<String, String>();
    private final Map<String, ArrayList<Property>> atmosphereHandlerProperties = new HashMap<String, ArrayList<Property>>();
    private final Map<String, String> broadcasters = new HashMap<String, String>();
    private final Map<String, String> broadcasterCache = new HashMap<String, String>();
    private String cometSupportClass = null;
    private String supportSession = "";
    private String[] broadcastFilterClasses;

    public AtmosphereConfigReader(InputStream stream) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            this.parse(factory.newDocumentBuilder().parse(stream));
        }
        catch (SAXException e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    private void parse(Document document) {
        Element element = document.getDocumentElement();
        NodeList atmosphereHandlers = element.getElementsByTagName("atmosphere-handler");
        for (int i = 0; i < atmosphereHandlers.getLength(); ++i) {
            String bc;
            String broadcasterClass;
            Node atmosphereHandler = atmosphereHandlers.item(i);
            NamedNodeMap attrs = atmosphereHandler.getAttributes();
            NodeList properties = atmosphereHandler.getChildNodes();
            ArrayList<Property> list = new ArrayList<Property>();
            for (int j = 0; j < properties.getLength(); ++j) {
                Node property = properties.item(j);
                NamedNodeMap values = property.getAttributes();
                if (values == null) continue;
                list.add(new Property(values.getNamedItem("name").getNodeValue(), values.getNamedItem("value").getNodeValue()));
            }
            if (attrs == null) continue;
            this.atmosphereHandlerProperties.put(attrs.getNamedItem("context-root").getNodeValue(), list);
            this.addAtmosphereHandler(attrs.getNamedItem("context-root").getNodeValue(), attrs.getNamedItem("class-name").getNodeValue());
            if (attrs.getNamedItem("broadcaster") != null && (broadcasterClass = attrs.getNamedItem("broadcaster").getNodeValue()) != null) {
                this.broadcasters.put(attrs.getNamedItem("context-root").getNodeValue(), broadcasterClass);
            }
            if (attrs.getNamedItem("broadcastFilterClasses") != null) {
                this.broadcastFilterClasses = attrs.getNamedItem("broadcastFilter").getNodeValue().split(",");
            }
            if (attrs.getNamedItem("broadcasterCache") != null && (bc = attrs.getNamedItem("broadcasterCache").getNodeValue()) != null) {
                this.broadcasterCache.put(attrs.getNamedItem("context-root").getNodeValue(), bc);
            }
            if (attrs.getNamedItem("comet-support") != null) {
                this.cometSupportClass = attrs.getNamedItem("comet-support").getNodeValue();
            }
            if (attrs.getNamedItem("support-session") == null) continue;
            this.supportSession = attrs.getNamedItem("support-session").getNodeValue();
        }
    }

    public String supportSession() {
        return this.supportSession;
    }

    void addAtmosphereHandler(String contextPath, String className) {
        if (this.tuples.containsKey(contextPath)) {
            throw new RuntimeException("duplicate context root in configuration :" + contextPath);
        }
        this.tuples.put(contextPath, className);
    }

    public Map<String, String> getAtmosphereHandlers() {
        return this.tuples;
    }

    public String getBroadcasterClass(String contextRoot) {
        return this.broadcasters.get(contextRoot);
    }

    public String getBroadcasterCache(String contextRoot) {
        return this.broadcasterCache.get(contextRoot);
    }

    public ArrayList<Property> getProperty(String contextRoot) {
        return this.atmosphereHandlerProperties.get(contextRoot);
    }

    public String getCometSupportClass() {
        return this.cometSupportClass;
    }

    public String[] getBroadcastFilterClasses() {
        return this.broadcastFilterClasses;
    }

    public class Property {
        public String name = "";
        public String value = "";

        public Property(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

