/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.servlet.deployer;

import com.sun.grizzly.http.deployer.DeployException;
import com.sun.grizzly.http.deployer.FromURIDeployer;
import com.sun.grizzly.http.servlet.ServletAdapter;
import com.sun.grizzly.http.servlet.deployer.GrizzlyWebServerDeployer;
import com.sun.grizzly.http.servlet.deployer.WarDeployable;
import com.sun.grizzly.http.servlet.deployer.WarDeploymentConfiguration;
import com.sun.grizzly.http.servlet.deployer.WebAppAdapter;
import com.sun.grizzly.http.servlet.deployer.annotation.AnnotationParser;
import com.sun.grizzly.http.webxml.WebappLoader;
import com.sun.grizzly.http.webxml.schema.ContextParam;
import com.sun.grizzly.http.webxml.schema.Filter;
import com.sun.grizzly.http.webxml.schema.FilterMapping;
import com.sun.grizzly.http.webxml.schema.InitParam;
import com.sun.grizzly.http.webxml.schema.Listener;
import com.sun.grizzly.http.webxml.schema.WebApp;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.util.ClassLoaderUtil;
import com.sun.grizzly.util.ExpandJar;
import com.sun.grizzly.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarDeployer
extends FromURIDeployer<WarDeployable, WarDeploymentConfiguration> {
    private static Logger logger = Logger.getLogger("com.sun.grizzly.http.servlet.deployer.WarDeployer");
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    private static final String EMPTY_SERVLET_PATH = "";
    private static final String ROOT = "/";
    private String workFolder;
    private boolean forceCleanUp = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<GrizzlyAdapter, Set<String>> convert(WarDeployable toDeploy, WarDeploymentConfiguration configuration) throws DeployException {
        String root = toDeploy.location;
        if (root != null) {
            root = GrizzlyWebServerDeployer.fixPath(root);
        }
        WebApp webApp = configuration.webDefault != null ? toDeploy.webApp.mergeWith(configuration.webDefault) : toDeploy.webApp;
        URLClassLoader loader = new URLClassLoader(toDeploy.webAppCL != null ? toDeploy.webAppCL.getURLs() : new URL[]{}, (ClassLoader)configuration.serverLibLoader);
        ClassLoader prevCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(loader);
        try {
            Map<GrizzlyAdapter, Set<String>> map = this.createDeployments(root, webApp, configuration.ctx, loader, configuration);
            return map;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevCL);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected WarDeployable fromURI(URI uri, WarDeploymentConfiguration configuration) throws DeployException {
        URLClassLoader warCL;
        String explodedLocation;
        if (!"file".equals(uri.getScheme())) throw new DeployException("Unsupported schema: " + uri.getScheme());
        File warFile = new File(uri);
        if (!warFile.exists()) throw new DeployException("War file does not exists: " + uri);
        if (warFile.isFile()) {
            try {
                String fileLocation = warFile.getAbsolutePath().replace('\\', '/');
                explodedLocation = this.explodeWarFile(new URI("jar:file:" + fileLocation + "!/"));
                warCL = this.createWarCL(fileLocation, null);
            }
            catch (URISyntaxException e) {
                throw new DeployException("Error.", e);
            }
        } else {
            explodedLocation = warFile.getAbsolutePath();
            warCL = this.createWarCL(explodedLocation, null);
        }
        WebApp webApp = WarDeployer.parseWebXml(uri, explodedLocation);
        if (!webApp.getMetadataComplete()) {
            logger.fine("Will append Annotations to the WebApp");
            try {
                AnnotationParser parser = new AnnotationParser();
                WebApp webAppAnot = parser.parseAnnotation(warCL);
                webApp.mergeWithAnnotations(webAppAnot);
                return new WarDeployable(webApp, explodedLocation, warCL);
            }
            catch (Throwable t) {
                logger.warning("Unable to load annotations : " + t.getMessage());
            }
            return new WarDeployable(webApp, explodedLocation, warCL);
        } else {
            logger.info("Skipping Annotation for this URI : " + uri);
        }
        return new WarDeployable(webApp, explodedLocation, warCL);
    }

    private Map<GrizzlyAdapter, Set<String>> createDeployments(String root, WebApp webApp, String context, ClassLoader webAppCL, WarDeploymentConfiguration configuration) {
        boolean blankContextServletPathFound = false;
        boolean defaultContextServletPathFound = false;
        ArrayList<String> aliasesUsed = new ArrayList<String>();
        HashMap<GrizzlyAdapter, Set<String>> result = new HashMap<GrizzlyAdapter, Set<String>>();
        WebAppAdapter webAppAdapter = this.getWebAppAdapter(webAppCL);
        for (Map.Entry<ServletAdapter, List<String>> adapterAliases : webAppAdapter.getServletAdaptersToAlises(webApp, context).entrySet()) {
            ServletAdapter sa = adapterAliases.getKey();
            sa.setClassLoader(webAppCL);
            for (ContextParam contextParam : webApp.contextParam) {
                sa.addContextParameter(contextParam.paramName, contextParam.paramValue);
            }
            for (Filter filter : webApp.filter) {
                for (FilterMapping filterMapping : webApp.filterMapping) {
                    if (!filter.filterName.equalsIgnoreCase(filterMapping.filterName)) continue;
                    javax.servlet.Filter filter2 = (javax.servlet.Filter)ClassLoaderUtil.load(filter.filterClass, webAppCL);
                    HashMap<String, String> initParamsMap = new HashMap<String, String>();
                    for (InitParam param : filter.initParam) {
                        initParamsMap.put(param.paramName, param.paramValue);
                    }
                    sa.addFilter(filter2, filter.filterName, initParamsMap);
                }
            }
            for (Listener listener : webApp.listener) {
                sa.addServletListener(listener.listenerClass);
            }
            sa.getRootFolders().clear();
            sa.addRootFolder(root);
            String[] alias = WebAppAdapter.getAlias(sa, (Collection<String>)adapterAliases.getValue());
            sa.setHandleStaticResources(false);
            for (String item : alias) {
                if (!item.endsWith(ROOT) && !item.endsWith("/*")) continue;
                sa.setHandleStaticResources(true);
            }
            List<String> list = Arrays.asList(alias);
            aliasesUsed.addAll(list);
            result.put(sa, new HashSet<String>(list));
            if (ROOT.equals(sa.getServletPath())) {
                defaultContextServletPathFound = true;
            }
            if (EMPTY_SERVLET_PATH.equals(sa.getServletPath())) {
                blankContextServletPathFound = true;
            }
            this.setExtraConfig(sa, configuration);
        }
        if (!defaultContextServletPathFound) {
            logger.log(Level.FINEST, "Adding a ServletAdapter to handle / path");
            result.putAll(this.createAndInstallServletAdapter(root, context, ROOT));
        }
        if (!blankContextServletPathFound && !aliasesUsed.contains(context + ROOT)) {
            logger.log(Level.FINEST, "Adding a ServletAdapter to handle root path");
            result.putAll(this.createAndInstallServletAdapter(root, context, EMPTY_SERVLET_PATH));
        }
        return result;
    }

    private Map<GrizzlyAdapter, Set<String>> createAndInstallServletAdapter(String rootFolder, String context, String tmpPath) {
        HashMap<GrizzlyAdapter, Set<String>> result = new HashMap<GrizzlyAdapter, Set<String>>(1);
        ServletAdapter sa = new ServletAdapter();
        sa.setContextPath(context);
        sa.setServletPath(tmpPath);
        sa.setHandleStaticResources(true);
        sa.getRootFolders().clear();
        sa.addRootFolder(rootFolder);
        result.put(sa, Collections.singleton(context + ROOT));
        return result;
    }

    public static String getDefaultWorkFolder() {
        return new File("work").getAbsolutePath();
    }

    private URLClassLoader createWarCL(String explodedLocation, URLClassLoader serverLibLoader) throws DeployException {
        URLClassLoader warCL;
        String deployToFolder = null;
        deployToFolder = this.workFolder != null ? this.workFolder : WarDeployer.getDefaultWorkFolder();
        String oldTmp = System.getProperty(JAVA_IO_TMPDIR);
        System.setProperty(JAVA_IO_TMPDIR, deployToFolder);
        try {
            warCL = ClassLoaderUtil.createURLClassLoader(explodedLocation, serverLibLoader);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "War class path contains:");
                for (URL url : warCL.getURLs()) {
                    logger.log(Level.FINEST, url.toString());
                }
            }
        }
        catch (IOException e) {
            throw new DeployException(String.format("Error while loading libs from '%s'.", explodedLocation), e);
        }
        finally {
            System.setProperty(JAVA_IO_TMPDIR, oldTmp);
        }
        return warCL;
    }

    private static WebApp parseWebXml(URI uri, String explodedLocation) throws DeployException {
        WebApp webApp;
        try {
            webApp = WebappLoader.load(explodedLocation + GrizzlyWebServerDeployer.WEB_XML_PATH);
        }
        catch (Exception e) {
            throw new DeployException(String.format("Error parsing web.xml for '%s'.", uri), e);
        }
        return webApp;
    }

    private String explodeWarFile(URI uri) throws DeployException {
        String explodedLocation = null;
        String deployToFolder = null;
        deployToFolder = this.workFolder != null ? this.workFolder : WarDeployer.getDefaultWorkFolder();
        try {
            if (this.forceCleanUp) {
                WarDeployer.cleanup(deployToFolder);
            }
            explodedLocation = ExpandJar.expand(uri.toURL(), deployToFolder);
        }
        catch (IOException e) {
            if (this.forceCleanUp) {
                WarDeployer.cleanup(deployToFolder);
            }
            throw new DeployException(String.format("Error extracting contents of war file '%s'.", uri), e);
        }
        return explodedLocation;
    }

    public static void cleanup(String folder) {
        if (folder == null) {
            return;
        }
        File file = new File(folder);
        if (file.exists() && file.isDirectory()) {
            logger.info("cleaning folder : " + folder);
            if (!FileUtil.deleteDir(file)) {
                logger.info("cleanup failed");
            }
        }
    }

    protected WebAppAdapter getWebAppAdapter(ClassLoader webAppCL) {
        return new WebAppAdapter();
    }

    protected void setExtraConfig(ServletAdapter sa, WarDeploymentConfiguration configuration) {
    }

    public boolean isForceCleanUp() {
        return this.forceCleanUp;
    }

    public void setForceCleanUp(boolean forceCleanUp) {
        this.forceCleanUp = forceCleanUp;
    }

    public String getWorkFolder() {
        return this.workFolder;
    }

    public void setWorkFolder(String workFolder) {
        this.workFolder = workFolder;
    }
}

