/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.websockets.ClosingFrame;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.FrameType;
import com.sun.grizzly.websockets.NetworkHandler;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketListener;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseWebSocket
implements WebSocket {
    NetworkHandler networkHandler;
    protected static final Logger logger = Logger.getLogger("websocket");
    private final List<WebSocketListener> listeners = new ArrayList<WebSocketListener>();
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private OutputStream outputStream;
    private boolean midstream = false;

    public BaseWebSocket(WebSocketListener ... listeners) {
        for (WebSocketListener listener : listeners) {
            this.add(listener);
        }
    }

    public NetworkHandler getNetworkHandler() {
        return this.networkHandler;
    }

    public void setNetworkHandler(NetworkHandler handler) {
        this.networkHandler = handler;
        handler.setWebSocket(this);
    }

    public List<WebSocketListener> getListeners() {
        return this.listeners;
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public final boolean add(WebSocketListener listener) {
        return this.listeners.add(listener);
    }

    @Override
    public void close() {
        this.close(-1, null);
    }

    @Override
    public void close(int code) {
        this.close(code, null);
    }

    @Override
    public void close(int code, String reason) {
        if (this.connected.compareAndSet(true, false)) {
            this.networkHandler.send(new ClosingFrame(code, reason));
        }
    }

    @Override
    public void onClose(DataFrame frame) {
        this.close(1000);
        this.onClose();
    }

    private void onClose() {
        Iterator<WebSocketListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            WebSocketListener listener = it.next();
            it.remove();
            listener.onClose(this);
        }
    }

    @Override
    public void onPing(DataFrame frame) {
        if (!this.connected.get()) {
            throw new RuntimeException("Socket is already closed.");
        }
        this.networkHandler.send(new DataFrame(FrameType.PONG, frame.getBinaryPayload()));
    }

    @Override
    public void onPong(DataFrame frame) {
    }

    @Override
    public void onFragment(boolean last, byte[] binaryPayload) {
        for (WebSocketListener listener : this.listeners) {
            listener.onFragment(this, last, binaryPayload);
        }
    }

    @Override
    public final boolean remove(WebSocketListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void send(String data) {
        if (!this.connected.get()) {
            throw new RuntimeException("Socket is already closed.");
        }
        this.networkHandler.send(new DataFrame(data));
    }

    @Override
    public void send(byte[] data) {
        if (!this.connected.get()) {
            throw new RuntimeException("Socket is already closed.");
        }
        this.networkHandler.send(new DataFrame(data));
    }

    @Override
    public void onConnect() {
        for (WebSocketListener listener : this.listeners) {
            listener.onConnect(this);
        }
        this.connected.compareAndSet(false, true);
    }

    @Override
    public void onMessage(String text) {
        for (WebSocketListener listener : this.listeners) {
            listener.onMessage((WebSocket)this, text);
        }
    }

    @Override
    public void onMessage(byte[] data) {
        for (WebSocketListener listener : this.listeners) {
            listener.onMessage((WebSocket)this, data);
        }
    }

    @Override
    public void stream(boolean last, byte[] bytes, int off, int len) {
        if (!this.connected.get()) {
            throw new RuntimeException("Socket is already closed.");
        }
        DataFrame frame = new DataFrame(this.midstream ? FrameType.CONTINUATION : FrameType.BINARY);
        this.midstream = !last;
        frame.setLast(last);
        byte[] data = new byte[len];
        System.arraycopy(bytes, off, data, 0, len);
        frame.setPayload(data);
        this.networkHandler.send(frame);
    }
}

