/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.net.URL;
import com.sun.grizzly.websockets.BaseNetworkHandler;
import com.sun.grizzly.websockets.ClientHandShake;
import com.sun.grizzly.websockets.ClientWebSocket;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.FramingException;
import com.sun.grizzly.websockets.HandshakeException;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketAdapter;
import com.sun.grizzly.websockets.WebSocketException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientNetworkHandler
extends BaseNetworkHandler {
    private Socket socket;
    private URL url;
    private ClientWebSocket webSocket;
    private final ByteChunk chunk = new ByteChunk();
    private final SecureRandom random = new SecureRandom();
    private boolean isHeaderParsed = false;
    private OutputStream outputStream;
    private InputStream inputStream;

    public ClientNetworkHandler(ClientWebSocket webSocket) {
        this.url = webSocket.getAddress();
        this.webSocket = webSocket;
        try {
            this.connect();
            this.handshake();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        webSocket.add(new WebSocketAdapter(){

            public void onClose(WebSocket socket) {
                socket.close();
            }
        });
        this.queueRead();
    }

    private void queueRead() {
        this.webSocket.execute(new Runnable(){

            public void run() {
                try {
                    int lastRead = ClientNetworkHandler.this.read();
                    if (lastRead > 0) {
                        ClientNetworkHandler.this.readFrame();
                    } else if (lastRead == -1) {
                        throw new EOFException();
                    }
                    if (ClientNetworkHandler.this.webSocket.isConnected()) {
                        ClientNetworkHandler.this.queueRead();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        });
    }

    protected void connect() throws IOException {
        if ("ws".equals(this.url.getProtocol())) {
            this.socket = new Socket(this.url.getHost(), this.url.getPort());
        } else if ("wss".equals(this.url.getProtocol())) {
            this.socket = this.getSSLSocketFactory().createSocket(this.url.getHost(), this.url.getPort());
        } else {
            throw new IOException("Unknown schema: " + this.url.getProtocol());
        }
        this.inputStream = this.socket.getInputStream();
        this.outputStream = this.socket.getOutputStream();
    }

    @Override
    public void send(DataFrame frame) {
        byte[] bytes = frame.frame();
        byte[] masked = new byte[bytes.length + 4];
        byte[] mask = this.generateMask();
        System.arraycopy(mask, 0, masked, 0, 4);
        for (int i = 0; i < bytes.length; ++i) {
            masked[i + 4] = (byte)(bytes[i] ^ mask[i % 4]);
        }
        this.write(masked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateMask() {
        byte[] bytes = new byte[4];
        SecureRandom secureRandom = this.random;
        synchronized (secureRandom) {
            this.random.nextBytes(bytes);
        }
        return bytes;
    }

    protected void handshake() throws IOException {
        String path;
        boolean isSecure = "wss".equals(this.url.getProtocol());
        StringBuilder origin = new StringBuilder();
        origin.append(isSecure ? "https://" : "http://");
        origin.append(this.url.getHost());
        if (!isSecure && this.url.getPort() != 80 || isSecure && this.url.getPort() != 443) {
            origin.append(":").append(this.url.getPort());
        }
        if ("".equals(path = this.url.getPath())) {
            path = "/";
        }
        ClientHandShake clientHS = new ClientHandShake(isSecure, origin.toString(), this.url.getHost(), String.valueOf(this.url.getPort()), path);
        this.write(clientHS.getBytes());
        Map<String, String> headers = this.readResponse();
        if (headers.isEmpty()) {
            throw new HandshakeException("No response headers received");
        }
        try {
            clientHS.validateServerResponse(headers);
        }
        catch (HandshakeException e) {
            throw new IOException(e.getMessage());
        }
        this.webSocket.onConnect();
    }

    protected void write(byte[] bytes) {
        try {
            this.outputStream.write(bytes);
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new WebSocketException(e.getMessage(), e);
        }
    }

    private Map<String, String> readResponse() throws IOException {
        TreeMap<String, String> headers = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o, String o1) {
                return o.compareToIgnoreCase(o1);
            }
        });
        if (!this.isHeaderParsed) {
            String line = new String(this.readLine(), "ASCII").trim();
            headers.put("Response Code", line.split(" ")[1]);
            while (!this.isHeaderParsed) {
                line = new String(this.readLine(), "ASCII").trim();
                if (line.length() == 0) {
                    this.isHeaderParsed = true;
                    continue;
                }
                String[] parts = line.split(":");
                headers.put(parts[0].trim(), parts[1].trim());
            }
        }
        return headers;
    }

    private byte[] readLine() throws IOException {
        int idx;
        if (this.chunk.getLength() <= 0) {
            this.read();
        }
        if ((idx = this.chunk.indexOf('\n', 0)) != -1) {
            int eolBytes = 1;
            int offset = this.chunk.getOffset();
            if ((idx += offset) > offset && this.chunk.getBuffer()[idx - 1] == 13) {
                --idx;
                eolBytes = 2;
            }
            int size = idx - offset;
            byte[] result = new byte[size];
            this.chunk.substract(result, 0, size);
            this.chunk.setOffset(this.chunk.getOffset() + eolBytes);
            return result;
        }
        return null;
    }

    public void shutdown() throws IOException {
        this.socket.close();
    }

    public ClientWebSocket getWebSocket() {
        return this.webSocket;
    }

    @Override
    public void setWebSocket(WebSocket webSocket) {
        this.webSocket = (ClientWebSocket)webSocket;
    }

    protected void readFrame() throws IOException {
        try {
            while (this.read() > 0) {
                this.unframe().respond(this.webSocket);
            }
        }
        catch (FramingException e) {
            this.webSocket.close();
        }
    }

    private int read() {
        try {
            int length;
            int count = this.chunk.getLength();
            if (count < 1) {
                byte[] bytes = new byte[8192];
                while ((count = this.inputStream.read(bytes)) == 8192) {
                    this.chunk.append(bytes, 0, count);
                }
                if (count > 0) {
                    this.chunk.append(bytes, 0, count);
                }
            }
            if ((length = this.chunk.getLength()) <= 0) {
                return count;
            }
            return length;
        }
        catch (IOException e) {
            throw new WebSocketException(e.getMessage(), e);
        }
    }

    @Override
    public byte get() {
        ByteChunk byteChunk = this.chunk;
        synchronized (byteChunk) {
            this.fill();
            try {
                return (byte)this.chunk.substract();
            }
            catch (IOException e) {
                throw new WebSocketException(e.getMessage(), e);
            }
        }
    }

    @Override
    public byte[] get(int count) {
        ByteChunk byteChunk = this.chunk;
        synchronized (byteChunk) {
            try {
                byte[] bytes = new byte[count];
                for (int total = 0; total < count; total += this.chunk.substract(bytes, total, count - total)) {
                    if (this.chunk.getLength() >= count) continue;
                    this.read();
                }
                return bytes;
            }
            catch (IOException e) {
                throw new WebSocketException(e.getMessage(), e);
            }
        }
    }

    private void fill() {
        if (this.chunk.getLength() == 0) {
            this.read();
        }
    }

    public SSLSocketFactory getSSLSocketFactory() throws IOException {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            return sc.getSocketFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }
}

