/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.websockets.FrameType;
import com.sun.grizzly.websockets.WebSocket;
import java.util.Arrays;

public class DataFrame {
    private String payload;
    private byte[] bytes;
    private FrameType type;
    private boolean last = true;

    public DataFrame() {
    }

    public DataFrame(FrameType type) {
        this.type = type;
    }

    public DataFrame(String data) {
        this.setPayload(data);
    }

    public DataFrame(byte[] data) {
        this.setPayload(data);
    }

    public DataFrame(FrameType type, byte[] bytes) {
        this.bytes = bytes;
        this.type = type;
    }

    public FrameType getType() {
        return this.type;
    }

    public void setType(FrameType type) {
        this.type = type;
    }

    public String getTextPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.type = FrameType.TEXT;
        this.payload = payload;
    }

    public void setPayload(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBinaryPayload() {
        return this.bytes;
    }

    public byte[] frame() {
        byte[] payloadBytes = this.type.frame(this);
        byte[] lengthBytes = this.convert(payloadBytes.length);
        int packetLength = 1 + lengthBytes.length;
        byte[] packet = new byte[packetLength + payloadBytes.length];
        packet[0] = this.type.setOpcode(this.last ? (byte)-128 : 0);
        System.arraycopy(lengthBytes, 0, packet, 1, lengthBytes.length);
        System.arraycopy(payloadBytes, 0, packet, packetLength, payloadBytes.length);
        return packet;
    }

    public byte[] convert(long length) {
        byte[] lengthBytes;
        if (length <= 125L) {
            lengthBytes = new byte[]{(byte)length};
        } else {
            byte[] b = DataFrame.toArray(length);
            if (length <= 65535L) {
                lengthBytes = new byte[3];
                lengthBytes[0] = 126;
                System.arraycopy(b, 6, lengthBytes, 1, 2);
            } else {
                lengthBytes = new byte[9];
                lengthBytes[0] = 127;
                System.arraycopy(b, 0, lengthBytes, 1, 8);
            }
        }
        return lengthBytes;
    }

    public static byte[] toArray(long length) {
        byte[] b = new byte[8];
        for (int i = 0; i < 8; ++i) {
            b[7 - i] = (byte)(length >>> i * 8);
        }
        return b;
    }

    public static long convert(byte[] bytes, int start, int end) {
        long value = 0L;
        for (int i = start; i < end; ++i) {
            value <<= 8;
            value ^= (long)bytes[i] & 0xFFL;
        }
        return value;
    }

    public static long convert(byte[] bytes) {
        return DataFrame.convert(bytes, 0, bytes.length);
    }

    public void respond(WebSocket socket) {
        this.getType().respond(socket, this);
    }

    public String toString() {
        return "DataFrame" + "{" + "type=" + (Object)((Object)this.type) + ", payload='" + this.getTextPayload() + '\'' + ", bytes=" + Arrays.toString(this.bytes) + '}';
    }

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean last) {
        this.last = last;
    }
}

