/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.websockets.ClosingFrame;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.FramingException;
import com.sun.grizzly.websockets.WebSocket;
import java.io.UnsupportedEncodingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FrameType {
    CONTINUATION{

        public void respond(WebSocket socket, DataFrame frame) {
            socket.onFragment(frame.isLast(), frame.getBinaryPayload());
        }
    }
    ,
    CLOSING{

        public DataFrame create() {
            return new ClosingFrame();
        }

        public void respond(WebSocket socket, DataFrame frame) {
            socket.onClose(frame);
        }
    }
    ,
    PING{

        public void respond(WebSocket socket, DataFrame frame) {
            socket.onPing(frame);
        }
    }
    ,
    PONG{

        public void respond(WebSocket socket, DataFrame frame) {
            socket.onPong(frame);
        }
    }
    ,
    TEXT{

        public void unframe(DataFrame frame, byte[] data) {
            try {
                frame.setPayload(new String(data, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new FramingException(e.getMessage(), e);
            }
        }

        public byte[] frame(DataFrame dataFrame) {
            try {
                return dataFrame.getTextPayload().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new FramingException(e.getMessage(), e);
            }
        }

        public void respond(WebSocket socket, DataFrame frame) {
            socket.onMessage(frame.getTextPayload());
        }
    }
    ,
    BINARY{

        public void respond(WebSocket socket, DataFrame frame) {
            if (!frame.isLast()) {
                socket.onFragment(frame.isLast(), frame.getBinaryPayload());
            } else {
                socket.onMessage(frame.getBinaryPayload());
            }
        }
    };


    public void unframe(DataFrame frame, byte[] data) {
        frame.setPayload(data);
        frame.setType(this);
    }

    public byte[] frame(DataFrame dataFrame) {
        return dataFrame.getBinaryPayload();
    }

    public abstract void respond(WebSocket var1, DataFrame var2);

    public final byte setOpcode(byte b) {
        return (byte)(b | this.ordinal());
    }

    public static FrameType valueOf(byte opcodes) {
        return FrameType.values()[opcodes & 0xF];
    }

    public DataFrame create() {
        DataFrame frame = new DataFrame();
        frame.setType(this);
        return frame;
    }
}

