/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.BaseSelectionKeyHandler;
import com.sun.grizzly.arp.AsyncExecutor;
import com.sun.grizzly.arp.AsyncProcessorTask;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.util.LogMessages;
import com.sun.grizzly.util.Utils;
import com.sun.grizzly.websockets.BaseServerWebSocket;
import com.sun.grizzly.websockets.BaseWebSocket;
import com.sun.grizzly.websockets.HandshakeException;
import com.sun.grizzly.websockets.ServerNetworkHandler;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketAdapter;
import com.sun.grizzly.websockets.WebSocketApplication;
import com.sun.grizzly.websockets.WebSocketCloseHandler;
import com.sun.grizzly.websockets.WebSocketException;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebSocketEngine {
    public static final String SEC_WS_ACCEPT = "Sec-WebSocket-Accept";
    public static final String SEC_WS_KEY_HEADER = "Sec-WebSocket-Key";
    public static final String SEC_WS_ORIGIN_HEADER = "Sec-WebSocket-Origin";
    public static final String SEC_WS_PROTOCOL_HEADER = "Sec-WebSocket-Protocol";
    public static final String SEC_WS_EXTENSIONS_HEADER = "Sec-WebSocket-Extensions";
    public static final String SEC_WS_VERSION = "Sec-WebSocket-Version";
    public static final String WEBSOCKET = "websocket";
    public static final String RESPONSE_CODE_HEADER = "Response Code";
    public static final String RESPONSE_CODE_MESSAGE = "Switching Protocols";
    public static final String RESPONSE_CODE_VALUE = "101";
    public static final String UPGRADE = "upgrade";
    public static final String CONNECTION = "connection";
    public static final int WS_VERSION = 6;
    public static final int INITIAL_BUFFER_SIZE = 8192;
    public static final int DEFAULT_TIMEOUT;
    private static final WebSocketEngine engine;
    private static volatile boolean isWebSocketEnabled;
    static final Logger logger;
    public static final String SERVER_KEY_HASH = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    public static final int MASK_SIZE = 4;
    private final List<WebSocketApplication> applications = new ArrayList<WebSocketApplication>();
    private final WebSocketCloseHandler closeHandler = new WebSocketCloseHandler();

    private WebSocketEngine() {
    }

    public static boolean isWebSocketEnabled() {
        return isWebSocketEnabled;
    }

    public static void setWebSocketEnabled(boolean webSocketEnabled) {
        isWebSocketEnabled = webSocketEnabled;
    }

    public static WebSocketEngine getEngine() {
        return engine;
    }

    public WebSocketApplication getApplication(Request request) {
        for (WebSocketApplication application : this.applications) {
            if (!application.upgrade(request)) continue;
            return application;
        }
        return null;
    }

    public boolean upgrade(AsyncExecutor asyncExecutor) {
        try {
            Request request = asyncExecutor.getProcessorTask().getRequest();
            WebSocketApplication app = WebSocketEngine.getEngine().getApplication(request);
            BaseWebSocket socket = null;
            try {
                if (app != null) {
                    Response response = request.getResponse();
                    ProcessorTask task = asyncExecutor.getProcessorTask();
                    AsyncProcessorTask asyncTask = (AsyncProcessorTask)asyncExecutor.getAsyncTask();
                    SelectionKey key = task.getSelectionKey();
                    ServerNetworkHandler handler = new ServerNetworkHandler(task, asyncTask, request, response);
                    ((BaseSelectionKeyHandler)task.getSelectorHandler().getSelectionKeyHandler()).setConnectionCloseHandler(this.closeHandler);
                    socket = (BaseServerWebSocket)app.createSocket(app, new KeyWebSocketListener(key));
                    socket.setNetworkHandler(handler);
                    handler.handshake(task.getSSLSupport() != null);
                    key.attach(handler.getAttachment());
                    this.enableRead(task, key);
                    return true;
                }
            }
            catch (HandshakeException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                socket.close();
            }
        }
        catch (WebSocketException e) {
            return false;
        }
        return false;
    }

    final void enableRead(ProcessorTask task, SelectionKey key) {
        task.getSelectorHandler().register(key, 1);
    }

    @Deprecated
    public void register(String name, WebSocketApplication app) {
        this.register(app);
    }

    public void register(WebSocketApplication app) {
        if (!WebSocketEngine.isWebSocketEnabled()) {
            throw new IllegalStateException(LogMessages.SEVERE_GRIZZLY_WS_NOT_ENABLED());
        }
        this.applications.add(app);
    }

    public void unregister(WebSocketApplication app) {
        this.applications.remove(app);
    }

    static {
        engine = new WebSocketEngine();
        isWebSocketEnabled = true;
        logger = Logger.getLogger(WEBSOCKET);
        DEFAULT_TIMEOUT = Utils.isDebugVM() ? 900 : 30;
    }

    private static class KeyWebSocketListener
    extends WebSocketAdapter {
        private final SelectionKey key;

        public KeyWebSocketListener(SelectionKey key) {
            this.key = key;
        }

        public void onClose(WebSocket socket) {
            this.key.cancel();
            try {
                this.key.channel().close();
            }
            catch (IOException e) {
                throw new WebSocketException(e.getMessage(), e);
            }
        }
    }
}

