/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.CometEvent;
import org.apache.catalina.CometProcessor;
import org.atmosphere.container.BlockingIOCometSupport;
import org.atmosphere.container.GoogleAppEngineCometSupport;
import org.atmosphere.container.JBossWebCometSupport;
import org.atmosphere.container.TomcatCometSupport;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereServletProcessor;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.CometSupport;
import org.atmosphere.cpr.CometSupportResolver;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.cpr.DefaultBroadcasterFactory;
import org.atmosphere.cpr.DefaultCometSupportResolver;
import org.atmosphere.cpr.WebSocketProcessor;
import org.atmosphere.di.InjectorProvider;
import org.atmosphere.di.ServletContextHolder;
import org.atmosphere.di.ServletContextProvider;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.util.AtmosphereConfigReader;
import org.atmosphere.util.IntrospectionUtils;
import org.atmosphere.util.Version;
import org.atmosphere.util.gae.GAEDefaultBroadcaster;
import org.atmosphere.websocket.JettyWebSocketSupport;
import org.atmosphere.websocket.WebSocketAtmosphereHandler;
import org.eclipse.jetty.websocket.WebSocket;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.servlet.http.HttpEventServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weblogic.servlet.http.AbstractAsyncServlet;
import weblogic.servlet.http.RequestResponseKey;

public class AtmosphereServlet
extends AbstractAsyncServlet
implements CometProcessor,
HttpEventServlet,
ServletContextProvider {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereServlet.class);
    public static final String JERSEY_BROADCASTER = "org.atmosphere.jersey.JerseyBroadcaster";
    public static final String REDIS_BROADCASTER = "org.atmosphere.plugin.redis.RedisBroadcaster";
    public static final String JMS_BROADCASTER = "org.atmosphere.plugin.jms.JMSBroadcaster";
    public static final String JGROUPS_BROADCASTER = "org.atmosphere.plugin.jgroups.JGroupsBroadcaster";
    public static final String XMPP_BROADCASTER = "org.atmosphere.plugin.xmpp.XMPPBroadcaster";
    public static final String JERSEY_CONTAINER = "com.sun.jersey.spi.container.servlet.ServletContainer";
    public static final String GAE_BROADCASTER = GAEDefaultBroadcaster.class.getName();
    public static final String PROPERTY_SERVLET_MAPPING = "org.atmosphere.jersey.servlet-mapping";
    public static final String PROPERTY_BLOCKING_COMETSUPPORT = "org.atmosphere.useBlocking";
    public static final String PROPERTY_NATIVE_COMETSUPPORT = "org.atmosphere.useNative";
    public static final String WEBSOCKET_SUPPORT = "org.atmosphere.useWebSocket";
    public static final String PROPERTY_USE_STREAM = "org.atmosphere.useStream";
    public static final String BROADCASTER_FACTORY = "org.atmosphere.cpr.broadcasterFactory";
    public static final String BROADCASTER_CLASS = "org.atmosphere.cpr.broadcasterClass";
    public static final String BROADCASTER_CACHE = "org.atmosphere.cpr.broadcasterCacheClass";
    public static final String PROPERTY_COMET_SUPPORT = "org.atmosphere.cpr.cometSupport";
    public static final String PROPERTY_SESSION_SUPPORT = "org.atmosphere.cpr.sessionSupport";
    public static final String PRIMEFACES_SERVLET = "org.primefaces.comet.PrimeFacesCometServlet";
    public static final String DISABLE_ONSTATE_EVENT = "org.atmosphere.disableOnStateEvent";
    public static final String WEB_INF_CLASSES = "/WEB-INF/classes/";
    public static final String RESUME_ON_BROADCAST = "org.atmosphere.resumeOnBroadcast";
    public static final String ATMOSPHERE_SERVLET = AtmosphereServlet.class.getName();
    public static final String ATMOSPHERE_RESOURCE = AtmosphereResource.class.getName();
    public static final String SUPPORT_SESSION = "org.atmosphere.cpr.AsynchronousProcessor.supportSession";
    public static final String ATMOSPHERE_HANDLER = AtmosphereHandler.class.getName();
    public static final String WEBSOCKET_ATMOSPHEREHANDLER = WebSocketAtmosphereHandler.class.getName();
    public static final String RESUME_AND_KEEPALIVE = AtmosphereServlet.class.getName() + ".resumeAndKeepAlive";
    public static final String RESUMED_ON_TIMEOUT = AtmosphereServlet.class.getName() + ".resumedOnTimeout";
    public static final String DEFAULT_NAMED_DISPATCHER = "default";
    public static final String BROADCAST_FILTER_CLASSES = "org.atmosphere.cpr.broadcastFilterClasses";
    public static final String NO_CACHE_HEADERS = "org.atmosphere.cpr.noCacheHeaders";
    public static final String DROP_ACCESS_CONTROL_ALLOW_ORIGIN_HEADER = "org.atmosphere.cpr.dropAccessControlAllowOriginHeader";
    public static final String CONTAINER_RESPONSE = "org.atmosphere.jersey.containerResponse";
    public static final String BROADCASTER_LIFECYCLE_POLICY = "org.atmosphere.cpr.broadcasterLifeCyclePolicy";
    private static final AtmospherePingSupport ATMOSPHERE_PING_SUPPORT = new AtmospherePingSupport();
    private final ArrayList<String> possibleAtmosphereHandlersCandidate = new ArrayList();
    private final HashMap<String, String> initParams = new HashMap();
    protected final AtmosphereConfig config = new AtmosphereConfig();
    protected final AtomicBoolean isCometSupportConfigured = new AtomicBoolean(false);
    protected final boolean isFilter;
    public static String[] broadcasterFilters = new String[0];
    private final Map<String, AtmosphereHandlerWrapper> atmosphereHandlers = new ConcurrentHashMap<String, AtmosphereHandlerWrapper>();
    private final ConcurrentLinkedQueue<String> broadcasterTypes = new ConcurrentLinkedQueue();
    protected boolean useNativeImplementation = false;
    protected boolean useBlockingImplementation = false;
    protected boolean useStreamForFlushingComments = false;
    protected CometSupport cometSupport;
    protected static String broadcasterClassName = DefaultBroadcaster.class.getName();
    protected boolean isCometSupportSpecified = false;
    protected boolean isBroadcasterSpecified = false;
    protected boolean isSessionSupportSpecified = false;
    private BroadcasterFactory broadcasterFactory;
    protected static String broadcasterCacheClassName;
    private boolean webSocketEnabled = false;
    private String broadcasterLifeCyclePolicy = "NEVER";

    public AtmosphereConfig getAtmosphereConfig() {
        return this.config;
    }

    public AtmosphereServlet() {
        this(false);
    }

    public AtmosphereServlet(boolean isFilter) {
        this.isFilter = isFilter;
        this.readSystemProperties();
        this.populateBroadcasterType();
    }

    protected void configureDefaultBroadcasterFactory() {
        Class<?> b = null;
        String defaultBroadcasterClassName = AtmosphereServlet.getDefaultBroadcasterClassName();
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            b = cl.loadClass(defaultBroadcasterClassName);
        }
        catch (ClassNotFoundException e) {
            logger.error("failed to load default broadcaster class name: " + defaultBroadcasterClassName, e);
        }
        Class bc = b == null ? DefaultBroadcaster.class : b;
        logger.info("using default broadcaster class: {}", bc);
        BroadcasterFactory.setBroadcasterFactory(new DefaultBroadcasterFactory(bc, this.broadcasterLifeCyclePolicy), this.config);
    }

    private void populateBroadcasterType() {
        this.broadcasterTypes.add(XMPP_BROADCASTER);
        this.broadcasterTypes.add(REDIS_BROADCASTER);
        this.broadcasterTypes.add(JGROUPS_BROADCASTER);
        this.broadcasterTypes.add(JMS_BROADCASTER);
    }

    public void addAtmosphereHandler(String mapping, AtmosphereHandler h) {
        if (!mapping.startsWith("/")) {
            mapping = "/" + mapping;
        }
        AtmosphereHandlerWrapper w = new AtmosphereHandlerWrapper(h);
        this.atmosphereHandlers.put(mapping, w);
    }

    public void addAtmosphereHandler(String mapping, AtmosphereHandler h, String broadcasterId) {
        if (!mapping.startsWith("/")) {
            mapping = "/" + mapping;
        }
        AtmosphereHandlerWrapper w = new AtmosphereHandlerWrapper(h);
        w.broadcaster.setID(broadcasterId);
        this.atmosphereHandlers.put(mapping, w);
    }

    public void addAtmosphereHandler(String mapping, AtmosphereHandler<HttpServletRequest, HttpServletResponse> h, Broadcaster broadcaster) {
        if (!mapping.startsWith("/")) {
            mapping = "/" + mapping;
        }
        AtmosphereHandlerWrapper w = new AtmosphereHandlerWrapper(h, broadcaster);
        this.atmosphereHandlers.put(mapping, w);
    }

    public boolean removeAtmosphereHandler(String mapping) {
        return this.atmosphereHandlers.remove(mapping) != null;
    }

    public void removeAllAtmosphereHandler() {
        this.atmosphereHandlers.clear();
    }

    public void removeAllInitParams() {
        this.initParams.clear();
    }

    public void addInitParameter(String name, String value) {
        this.initParams.put(name, value);
    }

    protected void readSystemProperties() {
        if (System.getProperty(PROPERTY_NATIVE_COMETSUPPORT) != null) {
            this.useNativeImplementation = Boolean.parseBoolean(System.getProperty(PROPERTY_NATIVE_COMETSUPPORT));
            this.isCometSupportSpecified = true;
        }
        if (System.getProperty(PROPERTY_BLOCKING_COMETSUPPORT) != null) {
            this.useBlockingImplementation = Boolean.parseBoolean(System.getProperty(PROPERTY_BLOCKING_COMETSUPPORT));
            this.isCometSupportSpecified = true;
        }
        if (System.getProperty(DISABLE_ONSTATE_EVENT) != null) {
            this.initParams.put(DISABLE_ONSTATE_EVENT, System.getProperty(DISABLE_ONSTATE_EVENT));
        }
    }

    @Override
    public void init(final ServletConfig sc) throws ServletException {
        logger.info("initializing atmosphere framework: {}", (Object)Version.getRawVersion());
        try {
            super.init(sc);
            ServletContextHolder.register(this);
            ServletConfig scFacade = new ServletConfig(){

                @Override
                public String getServletName() {
                    return sc.getServletName();
                }

                @Override
                public ServletContext getServletContext() {
                    return sc.getServletContext();
                }

                @Override
                public String getInitParameter(String name) {
                    String param = sc.getInitParameter(name);
                    if (param == null) {
                        return (String)AtmosphereServlet.this.initParams.get(name);
                    }
                    return param;
                }

                @Override
                public Enumeration<String> getInitParameterNames() {
                    return sc.getInitParameterNames();
                }
            };
            this.pingForStats();
            this.doInitParams(scFacade);
            this.configureDefaultBroadcasterFactory();
            this.doInitParamsForWebSocket(scFacade);
            this.detectGoogleAppEngine(scFacade);
            this.loadConfiguration(scFacade);
            this.autoDetectContainer();
            this.configureBroadcaster();
            this.cometSupport.init(scFacade);
            this.initAtmosphereServletProcessor(scFacade);
            logger.info("started atmosphere framework: {}", (Object)Version.getRawVersion());
        }
        catch (Throwable t) {
            logger.error("failed to initialize atmosphere framework", t);
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new ServletException(t.getCause());
        }
    }

    protected void configureBroadcaster() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.broadcasterFactory == null) {
            Class<?> bc = Thread.currentThread().getContextClassLoader().loadClass(broadcasterClassName);
            logger.info("using broadcaster class: {}", (Object)bc.getName());
            this.broadcasterFactory = new DefaultBroadcasterFactory(bc, this.broadcasterLifeCyclePolicy);
            this.config.broadcasterFactory = this.broadcasterFactory;
            BroadcasterFactory.setBroadcasterFactory(this.broadcasterFactory, this.config);
        }
        for (Map.Entry<String, AtmosphereHandlerWrapper> e : this.atmosphereHandlers.entrySet()) {
            AtmosphereHandlerWrapper w = e.getValue();
            BroadcasterConfig broadcasterConfig = new BroadcasterConfig(broadcasterFilters, this.config);
            if (w.broadcaster == null) {
                w.broadcaster = this.broadcasterFactory.get();
            } else {
                w.broadcaster.setBroadcasterConfig(broadcasterConfig);
                if (broadcasterCacheClassName != null) {
                    BroadcasterCache cache = (BroadcasterCache)Thread.currentThread().getContextClassLoader().loadClass(broadcasterCacheClassName).newInstance();
                    InjectorProvider.getInjector().inject(cache);
                    broadcasterConfig.setBroadcasterCache(cache);
                }
            }
            w.broadcaster.setID(e.getKey());
        }
    }

    protected void doInitParamsForWebSocket(ServletConfig sc) {
        String s = sc.getInitParameter(WEBSOCKET_ATMOSPHEREHANDLER);
        if (s != null) {
            this.addAtmosphereHandler("/*", new WebSocketAtmosphereHandler());
            this.webSocketEnabled = true;
            this.sessionSupport(false);
        }
        if ((s = sc.getInitParameter(WEBSOCKET_SUPPORT)) != null) {
            this.webSocketEnabled = true;
            this.sessionSupport(false);
        }
    }

    protected void doInitParams(ServletConfig sc) {
        String s = sc.getInitParameter(PROPERTY_NATIVE_COMETSUPPORT);
        if (s != null) {
            this.useNativeImplementation = Boolean.parseBoolean(s);
            if (this.useNativeImplementation) {
                this.isCometSupportSpecified = true;
            }
        }
        if ((s = sc.getInitParameter(PROPERTY_BLOCKING_COMETSUPPORT)) != null) {
            this.useBlockingImplementation = Boolean.parseBoolean(s);
            if (this.useBlockingImplementation) {
                this.isCometSupportSpecified = true;
            }
        }
        if ((s = sc.getInitParameter(PROPERTY_USE_STREAM)) != null) {
            this.useStreamForFlushingComments = Boolean.parseBoolean(s);
        }
        if ((s = sc.getInitParameter(PROPERTY_COMET_SUPPORT)) != null) {
            this.cometSupport = new DefaultCometSupportResolver(this.config).newCometSupport(s);
            this.isCometSupportSpecified = true;
        }
        if ((s = sc.getInitParameter(BROADCASTER_CLASS)) != null) {
            broadcasterClassName = s;
            this.isBroadcasterSpecified = true;
        }
        if ((s = sc.getInitParameter(BROADCASTER_CACHE)) != null) {
            broadcasterCacheClassName = s;
        }
        if ((s = sc.getInitParameter(PROPERTY_SESSION_SUPPORT)) != null) {
            this.config.supportSession = Boolean.valueOf(s);
            this.isSessionSupportSpecified = true;
        }
        if ((s = sc.getInitParameter(DISABLE_ONSTATE_EVENT)) != null) {
            this.initParams.put(DISABLE_ONSTATE_EVENT, s);
        } else {
            this.initParams.put(DISABLE_ONSTATE_EVENT, "false");
        }
        s = sc.getInitParameter(RESUME_AND_KEEPALIVE);
        if (s != null) {
            this.initParams.put(RESUME_AND_KEEPALIVE, s);
        }
        if ((s = sc.getInitParameter(BROADCAST_FILTER_CLASSES)) != null) {
            broadcasterFilters = s.split(",");
        }
        if ((s = sc.getInitParameter(BROADCASTER_LIFECYCLE_POLICY)) != null) {
            this.broadcasterLifeCyclePolicy = s;
        }
    }

    protected void loadConfiguration(ServletConfig sc) throws ServletException {
        try {
            URL url = sc.getServletContext().getResource(WEB_INF_CLASSES);
            URLClassLoader urlC = new URLClassLoader(new URL[]{url}, Thread.currentThread().getContextClassLoader());
            this.loadAtmosphereDotXml(sc.getServletContext().getResourceAsStream("/META-INF/atmosphere.xml"), urlC);
            if (this.atmosphereHandlers.size() == 0) {
                this.autoDetectAtmosphereHandlers(sc.getServletContext(), urlC);
                if (this.atmosphereHandlers.size() == 0) {
                    this.detectSupportedFramework(sc);
                }
            }
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    protected boolean detectSupportedFramework(ServletConfig sc) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            cl.loadClass(PRIMEFACES_SERVLET);
            return false;
        }
        catch (Throwable ignored) {
            try {
                cl.loadClass(JERSEY_CONTAINER);
                this.useStreamForFlushingComments = true;
            }
            catch (Throwable t) {
                return false;
            }
            logger.warn("Missing META-INF/atmosphere.xml but found the Jersey runtime. Starting Jersey");
            ReflectorServletProcessor rsp = new ReflectorServletProcessor();
            if (!this.isBroadcasterSpecified) {
                broadcasterClassName = this.lookupDefaultBroadcasterType();
            }
            rsp.setServletClassName(JERSEY_CONTAINER);
            this.sessionSupport(false);
            this.initParams.put(DISABLE_ONSTATE_EVENT, "true");
            String mapping = sc.getInitParameter(PROPERTY_SERVLET_MAPPING);
            if (mapping == null) {
                mapping = "/*";
            }
            Class<?> bc = cl.loadClass(broadcasterClassName);
            Broadcaster b = BroadcasterFactory.getDefault().get(bc, mapping);
            this.addAtmosphereHandler(mapping, (AtmosphereHandler<HttpServletRequest, HttpServletResponse>)rsp, b);
            return true;
        }
    }

    protected String lookupDefaultBroadcasterType() {
        for (String b : this.broadcasterTypes) {
            try {
                Class.forName(b);
                return b;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return JERSEY_BROADCASTER;
    }

    protected void sessionSupport(boolean sessionSupport) {
        if (!this.isSessionSupportSpecified) {
            this.config.supportSession = sessionSupport;
        }
    }

    boolean detectGoogleAppEngine(ServletConfig sc) {
        if (sc.getServletContext().getServerInfo().startsWith("Google")) {
            broadcasterClassName = GAE_BROADCASTER;
            this.isBroadcasterSpecified = true;
            this.cometSupport = new GoogleAppEngineCometSupport(this.config);
            return true;
        }
        return false;
    }

    void initAtmosphereServletProcessor(ServletConfig sc) throws ServletException {
        for (Map.Entry<String, AtmosphereHandlerWrapper> h : this.atmosphereHandlers.entrySet()) {
            AtmosphereHandler a = h.getValue().atmosphereHandler;
            if (!(a instanceof AtmosphereServletProcessor)) continue;
            ((AtmosphereServletProcessor)a).init(sc);
        }
    }

    @Override
    public void destroy() {
        if (this.cometSupport != null && AsynchronousProcessor.class.isAssignableFrom(this.cometSupport.getClass())) {
            ((AsynchronousProcessor)this.cometSupport).shutdown();
        }
        for (Map.Entry<String, AtmosphereHandlerWrapper> entry : this.atmosphereHandlers.entrySet()) {
            AtmosphereHandlerWrapper handlerWrapper = entry.getValue();
            handlerWrapper.atmosphereHandler.destroy();
            Broadcaster broadcaster = handlerWrapper.broadcaster;
            if (broadcaster == null) continue;
            broadcaster.destroy();
        }
        BroadcasterFactory factory = BroadcasterFactory.getDefault();
        if (factory != null) {
            factory.destroy();
            BroadcasterFactory.factory = null;
        }
    }

    protected void loadAtmosphereDotXml(InputStream stream, URLClassLoader c) throws IOException, ServletException {
        if (stream == null) {
            return;
        }
        AtmosphereConfigReader reader = new AtmosphereConfigReader(stream);
        Map<String, String> atmosphereHandlerNames = reader.getAtmosphereHandlers();
        Set<Map.Entry<String, String>> entries = atmosphereHandlerNames.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String handlerClassName = entry.getValue();
            String handlerPath = entry.getKey();
            try {
                String bc;
                AtmosphereHandler<HttpServletRequest, HttpServletResponse> handler;
                if (!handlerClassName.equals(ReflectorServletProcessor.class.getName())) {
                    handler = (AtmosphereHandler)c.loadClass(handlerClassName).newInstance();
                    InjectorProvider.getInjector().inject(handler);
                } else {
                    handler = new ReflectorServletProcessor();
                }
                logger.info("successfully loaded handler: {} mapped to context-path: {}", handler, (Object)handlerPath);
                AtmosphereHandlerWrapper wrapper = new AtmosphereHandlerWrapper(handler);
                this.atmosphereHandlers.put(handlerPath, wrapper);
                boolean isJersey = false;
                for (AtmosphereConfigReader.Property p : reader.getProperty(handlerPath)) {
                    if (p.value != null && p.value.indexOf("jersey") != -1) {
                        isJersey = true;
                        this.initParams.put(DISABLE_ONSTATE_EVENT, "true");
                        this.useStreamForFlushingComments = true;
                    }
                    IntrospectionUtils.setProperty(handler, p.name, p.value);
                }
                this.config.supportSession = !isJersey;
                if (!reader.supportSession().equals("")) {
                    this.sessionSupport(Boolean.valueOf(reader.supportSession()));
                }
                for (AtmosphereConfigReader.Property p : reader.getProperty(handlerPath)) {
                    IntrospectionUtils.addProperty(handler, p.name, p.value);
                }
                String broadcasterClass = reader.getBroadcasterClass(handlerPath);
                if (broadcasterClass != null) {
                    broadcasterClassName = broadcasterClass;
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    Class<?> bc2 = cl.loadClass(broadcasterClassName);
                    wrapper.broadcaster = BroadcasterFactory.getDefault().get(bc2, handlerPath);
                }
                if ((bc = reader.getBroadcasterCache(handlerPath)) != null) {
                    broadcasterCacheClassName = bc;
                }
                if (reader.getCometSupportClass() != null) {
                    this.cometSupport = (CometSupport)c.loadClass(reader.getCometSupportClass()).getDeclaredConstructor(AtmosphereConfig.class).newInstance(this.config);
                }
                if (reader.getBroadcastFilterClasses() == null) continue;
                broadcasterFilters = reader.getBroadcastFilterClasses();
            }
            catch (Throwable t) {
                logger.warn("unable to load AtmosphereHandler class: " + handlerClassName, t);
                throw new ServletException(t);
            }
        }
    }

    public void setCometSupport(CometSupport cometSupport) {
        this.cometSupport = cometSupport;
    }

    public CometSupport getCometSupport() {
        return this.cometSupport;
    }

    protected CometSupportResolver createCometSupportResolver() {
        return new DefaultCometSupportResolver(this.config);
    }

    protected void autoDetectContainer() {
        if (this.getCometSupport() == null) {
            this.setCometSupport(this.createCometSupportResolver().resolve(this.useNativeImplementation, this.useBlockingImplementation, this.webSocketEnabled));
        }
        logger.info("Atmosphere is using comet support: {} running under container: {}", (Object)this.getCometSupport().getClass().getName(), (Object)this.cometSupport.getContainerName());
    }

    protected void autoDetectAtmosphereHandlers(ServletContext servletContext, URLClassLoader classloader) throws MalformedURLException, URISyntaxException {
        logger.info("auto detecting atmosphere handlers in WEB-INF/classes");
        String realPath = servletContext.getRealPath(WEB_INF_CLASSES);
        if (realPath == null) {
            URL u = servletContext.getResource(WEB_INF_CLASSES);
            if (u == null) {
                return;
            }
            realPath = u.getPath();
        }
        this.loadAtmosphereHandlersFromPath(classloader, realPath);
        logger.info("Atmosphere using Broadcaster: {} ", (Object)broadcasterClassName);
    }

    protected void loadAtmosphereHandlersFromPath(URLClassLoader classloader, String realPath) {
        File file = new File(realPath);
        if (file.isDirectory()) {
            this.getFiles(file);
            for (String className : this.possibleAtmosphereHandlersCandidate) {
                try {
                    className = className.replace('\\', '/');
                    Class<?> clazz = classloader.loadClass(className = className.replaceFirst("^.*/(WEB-INF|target)/(test-)?classes/(.*)\\.class", "$3").replace("/", "."));
                    if (!AtmosphereHandler.class.isAssignableFrom(clazz)) continue;
                    AtmosphereHandler handler = (AtmosphereHandler)clazz.newInstance();
                    InjectorProvider.getInjector().inject(handler);
                    this.atmosphereHandlers.put("/" + handler.getClass().getSimpleName(), new AtmosphereHandlerWrapper(handler, null));
                    logger.info("Successfully loaded handler: {}  mapped to context-path: {}", handler, (Object)handler.getClass().getSimpleName());
                }
                catch (Throwable t) {
                    logger.trace("failed to load class as an AtmosphereHandler: " + className, t);
                }
            }
        }
    }

    private void getFiles(File f) {
        File[] files;
        for (File test : files = f.listFiles()) {
            if (test.isDirectory()) {
                this.getFiles(test);
                continue;
            }
            String clazz = test.getAbsolutePath();
            if (!clazz.endsWith(".class")) continue;
            this.possibleAtmosphereHandlersCandidate.add(clazz);
        }
    }

    @Override
    public void doHead(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    @Override
    public void doOptions(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    @Override
    public void doTrace(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    @Override
    public void doDelete(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    @Override
    public void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doCometSupport(req, res);
    }

    protected Action doCometSupport(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        req.setAttribute(BROADCASTER_FACTORY, this.broadcasterFactory);
        req.setAttribute(PROPERTY_USE_STREAM, this.useStreamForFlushingComments);
        try {
            return this.cometSupport.service(req, res);
        }
        catch (IllegalStateException ex) {
            if (ex.getMessage() != null && ex.getMessage().startsWith("Tomcat failed")) {
                if (!this.isFilter) {
                    logger.warn("failed using comet support: {}, error: {}", (Object)this.cometSupport.getClass().getName(), (Object)ex.getMessage());
                    logger.warn("Using BlockingIOCometSupport.");
                }
            } else {
                logger.error("AtmosphereServlet exception", ex);
                throw ex;
            }
            this.cometSupport = new BlockingIOCometSupport(this.config);
            this.service(req, res);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void event(CometEvent cometEvent) throws IOException, ServletException {
        HttpServletRequest req = cometEvent.getHttpServletRequest();
        HttpServletResponse res = cometEvent.getHttpServletResponse();
        req.setAttribute("CometEvent", cometEvent);
        if (!this.isCometSupportSpecified && !this.isCometSupportConfigured.getAndSet(true)) {
            CometSupport cometSupport = this.cometSupport;
            synchronized (cometSupport) {
                if (!this.cometSupport.getClass().equals(TomcatCometSupport.class)) {
                    logger.warn("TomcatCometSupport is enabled, switching to it");
                    this.cometSupport = new TomcatCometSupport(this.config);
                }
            }
        }
        this.doCometSupport(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(HttpEvent httpEvent) throws IOException, ServletException {
        HttpServletRequest req = httpEvent.getHttpServletRequest();
        HttpServletResponse res = httpEvent.getHttpServletResponse();
        req.setAttribute("HttpEvent", httpEvent);
        if (!this.isCometSupportSpecified && !this.isCometSupportConfigured.getAndSet(true)) {
            CometSupport cometSupport = this.cometSupport;
            synchronized (cometSupport) {
                if (!this.cometSupport.getClass().equals(JBossWebCometSupport.class)) {
                    logger.warn("JBossWebCometSupport is enabled, switching to it");
                    this.cometSupport = new JBossWebCometSupport(this.config);
                }
            }
        }
        this.doCometSupport(req, res);
    }

    @Override
    protected boolean doRequest(RequestResponseKey rrk) throws IOException, ServletException {
        try {
            rrk.getRequest().getSession().setAttribute("RequestResponseKey", rrk);
            Action action = this.doCometSupport(rrk.getRequest(), rrk.getResponse());
            if (action.type == Action.TYPE.SUSPEND) {
                if (action.timeout == -1L) {
                    rrk.setTimeout(Integer.MAX_VALUE);
                } else {
                    rrk.setTimeout((int)action.timeout);
                }
            }
            return action.type == Action.TYPE.SUSPEND;
        }
        catch (IllegalStateException ex) {
            logger.error("AtmosphereServlet.doRequest exception", ex);
            throw ex;
        }
    }

    @Override
    protected void doResponse(RequestResponseKey rrk, Object context) throws IOException, ServletException {
        rrk.getResponse().flushBuffer();
    }

    @Override
    protected void doTimeout(RequestResponseKey rrk) throws IOException, ServletException {
        ((AsynchronousProcessor)this.cometSupport).timedout(rrk.getRequest(), rrk.getResponse());
    }

    public static String getDefaultBroadcasterClassName() {
        return broadcasterClassName;
    }

    public static void setDefaultBroadcasterClassName(String bccn) {
        broadcasterClassName = bccn;
    }

    public boolean isUseStreamForFlushingComments() {
        return this.useStreamForFlushingComments;
    }

    public void setUseStreamForFlushingComments(boolean useStreamForFlushingComments) {
        this.useStreamForFlushingComments = useStreamForFlushingComments;
    }

    public BroadcasterFactory getBroadcasterFactory() {
        return this.broadcasterFactory;
    }

    public AtmosphereServlet setBroadcasterFactory(BroadcasterFactory broadcasterFactory) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        this.broadcasterFactory = broadcasterFactory;
        this.configureBroadcaster();
        return this;
    }

    public String getBroadcasterCacheClassName() {
        return broadcasterCacheClassName;
    }

    public void setBroadcasterCacheClassName(String broadcasterCacheClassName) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        AtmosphereServlet.broadcasterCacheClassName = broadcasterCacheClassName;
        this.configureBroadcaster();
    }

    public void addBroadcasterType(String broadcasterTypeString) {
        this.broadcasterTypes.add(broadcasterTypeString);
    }

    protected void pingForStats() {
        AtmosphereServlet.ATMOSPHERE_PING_SUPPORT.invoke();
    }

    @Override
    protected WebSocket doWebSocketConnect(final HttpServletRequest request, String protocol) {
        logger.info("WebSocket upgrade requested");
        return new WebSocket(){
            private WebSocketProcessor webSocketProcessor;

            @Override
            public void onConnect(WebSocket.Outbound outbound) {
                this.webSocketProcessor = new WebSocketProcessor(AtmosphereServlet.this, new JettyWebSocketSupport(outbound));
                try {
                    this.webSocketProcessor.connect(new JettyRequestFix(request));
                }
                catch (IOException e) {
                    logger.warn("failed to connect to web socket", e);
                }
            }

            @Override
            public void onMessage(byte frame, String data) {
                this.webSocketProcessor.broadcast(frame, data);
            }

            @Override
            public void onMessage(byte frame, byte[] data, int offset, int length) {
                this.webSocketProcessor.broadcast(frame, new String(data, offset, length));
            }

            @Override
            public void onFragment(boolean more, byte opcode, byte[] data, int offset, int length) {
                this.webSocketProcessor.broadcast(opcode, new String(data, offset, length));
            }

            @Override
            public void onDisconnect() {
                this.webSocketProcessor.close();
            }
        };
    }

    private static class AtmospherePingSupport {
        private final Method method;
        private final String[] version;

        private AtmospherePingSupport() {
            String[] stringArray;
            Method method = null;
            String[] version = null;
            try {
                Class<?> ping = Class.forName("org.atmosphere.ping.AtmospherePing");
                method = ping.getMethod("ping", String.class);
                version = new String[]{Version.getRawVersion()};
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.method = method;
            if (version == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "no version found";
            } else {
                stringArray = version;
            }
            this.version = stringArray;
            this.invoke();
        }

        private void invoke() {
            if (this.method == null) {
                return;
            }
            try {
                this.method.invoke(null, (Object[])this.version);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class JettyRequestFix
    extends HttpServletRequestWrapper {
        public JettyRequestFix(HttpServletRequest request) {
            super(request);
        }

        @Override
        public String getContextPath() {
            String uri = this.getRequestURI();
            String path = super.getContextPath();
            if (path == null) {
                path = uri.substring(0, uri.indexOf("/", 1));
            }
            return path;
        }
    }

    public static class Action {
        public long timeout = -1L;
        public TYPE type;

        public Action() {
            this.type = TYPE.CANCELLED;
        }

        public Action(TYPE type) {
            this.type = type;
        }

        public Action(TYPE type, long timeout) {
            this.timeout = timeout;
            this.type = type;
        }

        public static enum TYPE {
            SUSPEND,
            RESUME,
            TIMEOUT,
            CANCELLED,
            KEEP_ALIVED;

        }
    }

    public class AtmosphereConfig {
        private boolean supportSession = true;
        private BroadcasterFactory broadcasterFactory;
        private String dispatcherName = "default";

        protected Map<String, AtmosphereHandlerWrapper> handlers() {
            return AtmosphereServlet.this.atmosphereHandlers;
        }

        public ServletContext getServletContext() {
            return AtmosphereServlet.this.getServletContext();
        }

        public String getDispatcherName() {
            return this.dispatcherName;
        }

        public void setDispatcherName(String dispatcherName) {
            this.dispatcherName = dispatcherName;
        }

        public String getInitParameter(String name) {
            String s = (String)AtmosphereServlet.this.initParams.get(name);
            if (s != null) {
                return s;
            }
            return AtmosphereServlet.this.getInitParameter(name);
        }

        public Enumeration getInitParameterNames() {
            return AtmosphereServlet.this.getInitParameterNames();
        }

        public ServletConfig getServletConfig() {
            return AtmosphereServlet.this.getServletConfig();
        }

        public String getWebServerName() {
            return AtmosphereServlet.this.cometSupport.getContainerName();
        }

        public BroadcasterFactory getBroadcasterFactory() {
            return this.broadcasterFactory;
        }

        public boolean isSupportSession() {
            return this.supportSession;
        }

        public void setSupportSession(boolean supportSession) {
            this.supportSession = supportSession;
        }

        public AtmosphereServlet getServlet() {
            return AtmosphereServlet.this;
        }
    }

    public static final class AtmosphereHandlerWrapper {
        public final AtmosphereHandler atmosphereHandler;
        public Broadcaster broadcaster;

        public AtmosphereHandlerWrapper(AtmosphereHandler atmosphereHandler) {
            this.atmosphereHandler = atmosphereHandler;
            try {
                this.broadcaster = BroadcasterFactory.getDefault().get();
            }
            catch (Exception t) {
                throw new RuntimeException(t);
            }
        }

        public AtmosphereHandlerWrapper(AtmosphereHandler atmosphereHandler, Broadcaster broadcaster) {
            this.atmosphereHandler = atmosphereHandler;
            this.broadcaster = broadcaster;
        }

        public String toString() {
            return "AtmosphereHandlerWrapper{ atmosphereHandler=" + this.atmosphereHandler + ", broadcaster=" + this.broadcaster + " }";
        }
    }
}

