/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.handler;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.AtmosphereServletProcessor;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.util.AtmosphereFilterChain;
import org.atmosphere.util.FilterConfigImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectorServletProcessor
extends AbstractReflectorAtmosphereHandler
implements AtmosphereServletProcessor {
    private static final String APPLICATION_NAME = "applicationClassName";
    private static final Logger logger = LoggerFactory.getLogger(ReflectorServletProcessor.class);
    private String servletClassName;
    private final ArrayList<String> filtersClass = new ArrayList();
    private final FilterChainServletWrapper wrapper = new FilterChainServletWrapper();
    private final AtmosphereFilterChain filterChain = new AtmosphereFilterChain();
    private Servlet servlet;
    private String filterName;

    void loadWebApplication(ServletConfig sc) throws MalformedURLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        URL url = sc.getServletContext().getResource("/WEB-INF/lib/");
        URLClassLoader urlC = new URLClassLoader(new URL[]{url}, Thread.currentThread().getContextClassLoader());
        if (this.getServletClassName() != null && this.servlet == null) {
            try {
                this.servlet = (Servlet)urlC.loadClass(this.getServletClassName()).newInstance();
            }
            catch (NullPointerException ex) {
                this.servlet = (Servlet)Thread.currentThread().getContextClassLoader().loadClass(this.servletClassName).newInstance();
            }
        }
        logger.info("Installing Servlet {}", (Object)this.servletClassName);
        this.filterChain.setServlet(sc, this.servlet);
        for (String fClass : this.filtersClass) {
            Filter f;
            try {
                f = (Filter)urlC.loadClass(fClass).newInstance();
            }
            catch (NullPointerException ex) {
                f = (Filter)Thread.currentThread().getContextClassLoader().loadClass(fClass).newInstance();
            }
            FilterConfigImpl fc = new FilterConfigImpl(sc);
            fc.setFilter(f);
            if (this.filterName == null) {
                this.filterName = sc.getInitParameter(APPLICATION_NAME) != null ? sc.getInitParameter(APPLICATION_NAME) : f.getClass().getSimpleName();
            }
            fc.setFilterName(this.filterName);
            this.filterChain.addFilter(fc);
            logger.info("Installing Filter {}", (Object)this.filterName);
        }
    }

    @Override
    public void onRequest(AtmosphereResource<HttpServletRequest, HttpServletResponse> r) throws IOException {
        r.getRequest().setAttribute(AtmosphereServlet.ATMOSPHERE_RESOURCE, r);
        r.getRequest().setAttribute(AtmosphereServlet.ATMOSPHERE_HANDLER, this);
        try {
            this.wrapper.service((ServletRequest)r.getRequest(), (ServletResponse)r.getResponse());
        }
        catch (Throwable ex) {
            logger.error("onRequest()", ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
        try {
            this.loadWebApplication(sc);
        }
        catch (Exception ex) {
            throw new ServletException(ex);
        }
        this.wrapper.init(sc);
    }

    @Override
    public void destroy() {
        if (this.filterChain != null) {
            this.filterChain.destroy();
        }
    }

    public String getServletClass() {
        return this.servletClassName;
    }

    public void setServletClass(String servletClass) {
        this.servletClassName = servletClass;
    }

    public String getServletClassName() {
        return this.servletClassName;
    }

    public void setServletClassName(String servletClass) {
        this.servletClassName = servletClass;
    }

    public void setFilterClassName(String filterClass) {
        if (filterClass == null) {
            return;
        }
        this.filtersClass.add(filterClass);
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    private class FilterChainServletWrapper
    extends HttpServlet {
        private FilterChainServletWrapper() {
        }

        @Override
        public void destroy() {
            ReflectorServletProcessor.this.filterChain.destroy();
        }

        @Override
        public String getInitParameter(String name) {
            return this.getServletConfig().getInitParameter(name);
        }

        @Override
        public Enumeration getInitParameterNames() {
            return this.getServletConfig().getInitParameterNames();
        }

        @Override
        public ServletConfig getServletConfig() {
            return ReflectorServletProcessor.this.filterChain.getServletConfig();
        }

        @Override
        public ServletContext getServletContext() {
            return this.getServletConfig().getServletContext();
        }

        @Override
        public String getServletInfo() {
            return ReflectorServletProcessor.this.filterChain.getServlet().getServletInfo();
        }

        @Override
        public void init(ServletConfig sc) throws ServletException {
            ReflectorServletProcessor.this.filterChain.init();
        }

        @Override
        public void init() throws ServletException {
        }

        @Override
        public void log(String msg) {
            this.getServletContext().log(this.getServletName() + ": " + msg);
        }

        @Override
        public void log(String message, Throwable t) {
            this.getServletContext().log(this.getServletName() + ": " + message, t);
        }

        @Override
        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            ReflectorServletProcessor.this.filterChain.invokeFilterChain(req, res);
        }

        @Override
        public String getServletName() {
            return ReflectorServletProcessor.this.filterChain.getServletConfig().getServletName();
        }
    }
}

