/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.jersey;

import com.sun.jersey.api.JResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.atmosphere.annotation.Suspend;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.Broadcaster;

public class SuspendResponse<E>
extends JResponse {
    private final TimeSpan suspendTimeout;
    private final Suspend.SCOPE scope;
    private final boolean outputComments;
    private final boolean resumeOnBroadcast;
    private final Collection<AtmosphereResourceEventListener> listeners;
    private final Broadcaster broadcaster;

    protected SuspendResponse(SuspendResponseBuilder<E> b) {
        super(b);
        this.suspendTimeout = b.suspendTimeout;
        this.scope = b.scope;
        this.outputComments = b.outputComments;
        this.resumeOnBroadcast = b.resumeOnBroadcast;
        this.listeners = b.listeners;
        this.broadcaster = ((SuspendResponseBuilder)b).broadcaster;
    }

    public Suspend.SCOPE scope() {
        return this.scope;
    }

    public TimeSpan period() {
        return this.suspendTimeout;
    }

    public boolean outputComments() {
        return this.outputComments;
    }

    public boolean resumeOnBroadcast() {
        return this.resumeOnBroadcast;
    }

    public Broadcaster broadcaster() {
        return this.broadcaster;
    }

    public Collection<AtmosphereResourceEventListener> listeners() {
        return Collections.unmodifiableCollection(this.listeners);
    }

    public static class TimeSpan {
        private final TimeUnit timeUnit;
        private final int period;

        public TimeSpan(int period, TimeUnit timeUnit) {
            this.period = period;
            this.timeUnit = timeUnit;
        }

        public int value() {
            return this.period;
        }

        public TimeUnit timeUnit() {
            return this.timeUnit;
        }
    }

    public static class SuspendResponseBuilder<E>
    extends JResponse.AJResponseBuilder<E, SuspendResponseBuilder<E>> {
        protected TimeSpan suspendTimeout = new TimeSpan(-1, TimeUnit.MILLISECONDS);
        protected Suspend.SCOPE scope = Suspend.SCOPE.APPLICATION;
        protected boolean outputComments = true;
        protected boolean resumeOnBroadcast = false;
        protected final Collection<AtmosphereResourceEventListener> listeners = new ArrayList<AtmosphereResourceEventListener>();
        private Broadcaster broadcaster;

        public SuspendResponseBuilder() {
        }

        public SuspendResponseBuilder(SuspendResponseBuilder<E> that) {
            super(that);
        }

        public SuspendResponseBuilder<E> scope(Suspend.SCOPE scope) {
            this.scope = scope;
            return this;
        }

        public SuspendResponseBuilder<E> period(int suspendTimeout, TimeUnit timeUnit) {
            this.suspendTimeout = new TimeSpan(suspendTimeout, timeUnit);
            return this;
        }

        public SuspendResponseBuilder<E> outputComments(boolean outputComments) {
            this.outputComments = outputComments;
            return this;
        }

        public SuspendResponseBuilder<E> resumeOnBroadcast(boolean resumeOnBroadcast) {
            this.resumeOnBroadcast = resumeOnBroadcast;
            return this;
        }

        public SuspendResponseBuilder<E> broadcaster(Broadcaster broadcaster) {
            this.broadcaster = broadcaster;
            return this;
        }

        public SuspendResponseBuilder<E> addListener(AtmosphereResourceEventListener e) {
            this.listeners.add(e);
            return this;
        }

        public SuspendResponse<E> build() {
            SuspendResponse r = new SuspendResponse(this);
            this.reset();
            return r;
        }
    }
}

