/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.client;

import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.PerRequestBroadcastFilter;

public class JavascriptClientFilter
implements PerRequestBroadcastFilter {
    private final AtomicInteger uniqueScriptToken = new AtomicInteger();

    @Override
    public BroadcastFilter.BroadcastAction filter(Object originalMessage, Object message) {
        if (message instanceof String) {
            StringBuilder sb = new StringBuilder("<script id=\"atmosphere_").append(this.uniqueScriptToken.getAndIncrement()).append("\">").append("parent.callback").append("('").append(message.toString()).append("');</script>");
            message = sb.toString();
        }
        return new BroadcastFilter.BroadcastAction(BroadcastFilter.BroadcastAction.ACTION.CONTINUE, message);
    }

    @Override
    public BroadcastFilter.BroadcastAction filter(HttpServletRequest request, HttpServletResponse response, Object message) {
        String userAgent;
        if (request.getHeader("User-Agent") != null && (userAgent = request.getHeader("User-Agent").toLowerCase()) != null && userAgent.startsWith("opera") && message instanceof String) {
            StringBuilder sb = new StringBuilder("<script id=\"atmosphere_").append(this.uniqueScriptToken.getAndIncrement()).append("\">").append("window.parent.$.atmosphere.streamingCallback").append("('").append(message.toString()).append("');</script>");
            message = sb.toString();
            return new BroadcastFilter.BroadcastAction(BroadcastFilter.BroadcastAction.ACTION.CONTINUE, message);
        }
        return new BroadcastFilter.BroadcastAction(BroadcastFilter.BroadcastAction.ACTION.CONTINUE, null);
    }
}

