/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.ContinuationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyCometSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(JettyCometSupport.class);
    private final ConcurrentLinkedQueue<Continuation> resumed = new ConcurrentLinkedQueue();

    public JettyCometSupport(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse response) throws IOException, ServletException {
        Continuation c = ContinuationSupport.getContinuation((HttpServletRequest)req, null);
        AtmosphereServlet.Action action = null;
        if (!c.isResumed() && !c.isPending()) {
            action = this.suspended(req, response);
            if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
                logger.debug("Suspending response: {}", response);
                if (action.timeout != -1L) {
                    c.suspend(action.timeout);
                } else {
                    c.suspend(0L);
                }
            }
        } else {
            logger.debug("Resuming response: {}", response);
            if (!this.resumed.remove(c)) {
                c.reset();
                if (req.getAttribute(AtmosphereServlet.RESUMED_ON_TIMEOUT) == null) {
                    this.timedout(req, response);
                } else {
                    this.resumed(req, response);
                }
            }
        }
        return action;
    }

    @Override
    public void action(AtmosphereResourceImpl r) {
        super.action(r);
        if (r.action().type == AtmosphereServlet.Action.TYPE.RESUME && r.isInScope()) {
            Continuation c = ContinuationSupport.getContinuation((HttpServletRequest)r.getRequest(), null);
            this.resumed.offer(c);
            if (this.config.getInitParameter(AtmosphereServlet.RESUME_AND_KEEPALIVE) == null || this.config.getInitParameter(AtmosphereServlet.RESUME_AND_KEEPALIVE).equalsIgnoreCase("false")) {
                c.resume();
            } else {
                try {
                    r.getResponse().flushBuffer();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public AtmosphereServlet.Action cancelled(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Continuation c;
        AtmosphereServlet.Action action = super.cancelled(req, res);
        if (req.getAttribute(MAX_INACTIVE) != null && (Long)Long.class.cast(req.getAttribute(MAX_INACTIVE)) == -1L && (c = ContinuationSupport.getContinuation((HttpServletRequest)req, null)) != null) {
            c.resume();
        }
        return action;
    }
}

