/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.CometSupport;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsynchronousProcessor
implements CometSupport<AtmosphereResourceImpl> {
    private static final Logger logger = LoggerFactory.getLogger(AsynchronousProcessor.class);
    protected static final AtmosphereServlet.Action timedoutAction = new AtmosphereServlet.Action(AtmosphereServlet.Action.TYPE.TIMEOUT);
    protected static final AtmosphereServlet.Action cancelledAction = new AtmosphereServlet.Action(AtmosphereServlet.Action.TYPE.CANCELLED);
    private static final int DEFAULT_SESSION_TIMEOUT = 1800;
    protected final AtmosphereServlet.AtmosphereConfig config;
    protected final ConcurrentHashMap<HttpServletRequest, AtmosphereResource<HttpServletRequest, HttpServletResponse>> aliveRequests = new ConcurrentHashMap();
    private final ScheduledExecutorService closedDetector = Executors.newScheduledThreadPool(1);

    public AsynchronousProcessor(AtmosphereServlet.AtmosphereConfig config) {
        this.config = config;
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
        String maxInactive;
        String string = maxInactive = sc.getInitParameter(MAX_INACTIVE) != null ? sc.getInitParameter(MAX_INACTIVE) : this.config.getInitParameter(MAX_INACTIVE);
        if (maxInactive != null) {
            final long maxInactiveTime = Long.parseLong(maxInactive);
            if (maxInactiveTime <= 0L) {
                return;
            }
            this.closedDetector.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    for (HttpServletRequest req : AsynchronousProcessor.this.aliveRequests.keySet()) {
                        long l = (Long)req.getAttribute(CometSupport.MAX_INACTIVE);
                        if (l <= 0L || System.currentTimeMillis() - l <= maxInactiveTime) continue;
                        try {
                            AsynchronousProcessor.this.cancelled(req, AsynchronousProcessor.this.aliveRequests.get(req).getResponse());
                            req.setAttribute(CometSupport.MAX_INACTIVE, -1L);
                        }
                        catch (IOException e) {
                        }
                        catch (ServletException e) {}
                    }
                }
            }, 0L, 1L, TimeUnit.SECONDS);
        }
    }

    protected boolean supportSession() {
        return this.config.isSupportSession();
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo();
    }

    public AtmosphereServlet.Action suspended(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug("(suspend) invoked:\n HttpServletRequest: {}\n HttpServletResponse: {}", request, (Object)response);
        return this.action(request, response);
    }

    AtmosphereServlet.Action action(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        HttpSession session;
        String upgrade = req.getHeader("Connection");
        if (upgrade != null && upgrade.equalsIgnoreCase("Upgrade") && !this.supportWebSocket()) {
            res.setStatus(501);
            res.addHeader("X-Atmosphere-error", "Websocket protocol not supported");
            res.flushBuffer();
            return new AtmosphereServlet.Action();
        }
        if (this.config.handlers().isEmpty()) {
            logger.error("No AtmosphereHandler found. Make sure you define it inside META-INF/atmosphere.xml");
            throw new ServletException("No AtmosphereHandler found. Make sure you define it inside META-INF/atmosphere.xml");
        }
        if (this.supportSession() && (session = req.getSession(true)).getMaxInactiveInterval() == 1800) {
            session.setMaxInactiveInterval(-1);
        }
        req.setAttribute("org.atmosphere.cpr.AsynchronousProcessor.supportSession", this.supportSession());
        AtmosphereServlet.AtmosphereHandlerWrapper handlerWrapper = this.map(req);
        AtmosphereResourceImpl resource = new AtmosphereResourceImpl(this.config, handlerWrapper.broadcaster, req, res, this);
        handlerWrapper.broadcaster.getBroadcasterConfig().setAtmosphereConfig(this.config);
        req.setAttribute(AtmosphereServlet.ATMOSPHERE_RESOURCE, resource);
        req.setAttribute(AtmosphereServlet.ATMOSPHERE_HANDLER, handlerWrapper.atmosphereHandler);
        try {
            handlerWrapper.atmosphereHandler.onRequest(resource);
        }
        catch (IOException t) {
            resource.onThrowable(t);
            throw t;
        }
        this.config.mapBroadcasterToAtmosphereHandler(resource.getBroadcaster(), handlerWrapper);
        if (resource.getAtmosphereResourceEvent().isSuspended()) {
            req.setAttribute(MAX_INACTIVE, System.currentTimeMillis());
            this.aliveRequests.put(req, resource);
        }
        return resource.action();
    }

    @Override
    public void action(AtmosphereResourceImpl r) {
        this.aliveRequests.remove(r.getRequest());
    }

    protected AtmosphereServlet.AtmosphereHandlerWrapper map(HttpServletRequest req) throws ServletException {
        AtmosphereServlet.AtmosphereHandlerWrapper atmosphereHandlerWrapper;
        String path = req.getServletPath();
        if (path == null || path.length() == 0) {
            path = "/";
        }
        if ((atmosphereHandlerWrapper = this.config.handlers().get(path)) == null) {
            path = !path.endsWith("/") ? path + "/*" : path + "*";
            atmosphereHandlerWrapper = this.config.handlers().get(path);
            if (atmosphereHandlerWrapper == null && (atmosphereHandlerWrapper = this.config.handlers().get("/*")) == null) {
                if (req.getPathInfo() != null) {
                    path = req.getServletPath() + req.getPathInfo();
                }
                if ((atmosphereHandlerWrapper = this.config.handlers().get(path)) == null) {
                    path = !path.endsWith("/") ? path + "/*" : path + "*";
                    atmosphereHandlerWrapper = this.config.handlers().get(path);
                    if (atmosphereHandlerWrapper == null) {
                        logger.warn("No AtmosphereHandler maps request for {}", (Object)path);
                        for (String m : this.config.handlers().keySet()) {
                            logger.warn("\tAtmosphereHandler registered: {}", (Object)m);
                        }
                        throw new ServletException("No AtmosphereHandler maps request for " + path);
                    }
                }
            }
        }
        this.config.getBroadcasterFactory().add(atmosphereHandlerWrapper.broadcaster, atmosphereHandlerWrapper.broadcaster.getID());
        return atmosphereHandlerWrapper;
    }

    public AtmosphereServlet.Action resumed(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug("(resumed) invoked:\n HttpServletRequest: {}\n HttpServletResponse: {}", request, (Object)response);
        return this.action(request, response);
    }

    public AtmosphereServlet.Action timedout(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        long l = (Long)request.getAttribute(MAX_INACTIVE);
        if (l == -1L) {
            return timedoutAction;
        }
        request.setAttribute(MAX_INACTIVE, -1L);
        if (request == null || response == null) {
            logger.warn("Invalid Request/Response: {}/{}", request, (Object)response);
            return timedoutAction;
        }
        AtmosphereResourceImpl re = (AtmosphereResourceImpl)request.getAttribute(AtmosphereServlet.ATMOSPHERE_RESOURCE);
        if (re != null) {
            re.getAtmosphereResourceEvent().setIsResumedOnTimeout(true);
            Broadcaster b = re.getBroadcaster();
            if (b instanceof DefaultBroadcaster) {
                ((DefaultBroadcaster)b).broadcastOnResume(re);
            }
            if (re.getRequest().getAttribute(AtmosphereServlet.RESUMED_ON_TIMEOUT) != null) {
                re.getAtmosphereResourceEvent().setIsResumedOnTimeout((Boolean)re.getRequest().getAttribute(AtmosphereServlet.RESUMED_ON_TIMEOUT));
            }
            this.invokeAtmosphereHandler(re);
        }
        return timedoutAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeAtmosphereHandler(AtmosphereResourceImpl r) throws IOException {
        HttpServletRequest req = r.getRequest();
        HttpServletResponse response = r.getResponse();
        String disableOnEvent = r.getAtmosphereConfig().getInitParameter("org.atmosphere.disableOnStateEvent");
        try {
            if (!r.getResponse().equals(response)) {
                logger.warn("Invalid response: {}", response);
            } else if (disableOnEvent == null || !disableOnEvent.equals(String.valueOf(true))) {
                AtmosphereHandler atmosphereHandler = (AtmosphereHandler)req.getAttribute(AtmosphereServlet.ATMOSPHERE_HANDLER);
                atmosphereHandler.onStateChange(r.getAtmosphereResourceEvent());
            } else {
                r.getResponse().flushBuffer();
            }
        }
        catch (IOException ex) {
            try {
                r.onThrowable(ex);
            }
            catch (Throwable t) {
                logger.warn("failed calling onThrowable()", ex);
            }
        }
        finally {
            try {
                this.aliveRequests.remove(req);
                r.notifyListeners();
            }
            finally {
                r.removeEventListeners();
                r.getBroadcaster().removeAtmosphereResource(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtmosphereServlet.Action cancelled(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereResourceImpl re = null;
        long l = (Long)req.getAttribute(MAX_INACTIVE);
        if (l == -1L) {
            return timedoutAction;
        }
        req.setAttribute(MAX_INACTIVE, -1L);
        try {
            re = (AtmosphereResourceImpl)req.getAttribute(AtmosphereServlet.ATMOSPHERE_RESOURCE);
            if (re != null) {
                re.getAtmosphereResourceEvent().setCancelled(true);
                this.invokeAtmosphereHandler(re);
                re.setIsInScope(false);
            }
        }
        catch (Throwable ex) {
            logger.debug("failed to cancel resource: " + re, ex);
        }
        finally {
            try {
                this.aliveRequests.remove(req);
                if (re != null) {
                    re.notifyListeners();
                }
            }
            finally {
                if (re != null) {
                    re.removeEventListeners();
                    re.getBroadcaster().removeAtmosphereResource(re);
                }
            }
        }
        return cancelledAction;
    }

    void shutdown() {
        this.closedDetector.shutdownNow();
        for (AtmosphereResource<HttpServletRequest, HttpServletResponse> resource : this.aliveRequests.values()) {
            try {
                resource.resume();
            }
            catch (Throwable t) {
                logger.debug("failed on resume: " + resource, t);
            }
        }
    }

    @Override
    public boolean supportWebSocket() {
        return false;
    }
}

