/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.spring;

import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class SpringObjectFactory
implements AtmosphereObjectFactory {
    private static final Logger logger = LoggerFactory.getLogger(SpringObjectFactory.class);

    public <T> T newClassInstance(AtmosphereFramework framework, Class<T> classToInstantiate) throws InstantiationException, IllegalAccessException {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{classToInstantiate});
        Object t = context.getBean(classToInstantiate);
        if (t == null) {
            logger.info("Unable to find {}. Creating the object directly.", (Object)classToInstantiate.getName());
            return classToInstantiate.newInstance();
        }
        return (T)t;
    }

    public String toString() {
        return "Spring ObjectFactory";
    }
}

