/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.spring;

import javax.servlet.ServletContext;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereObjectFactory;
import org.atmosphere.spring.SpringObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringWebObjectFactory
implements AtmosphereObjectFactory {
    private static final Logger logger = LoggerFactory.getLogger(SpringObjectFactory.class);

    public <T, U extends T> U newClassInstance(AtmosphereFramework framework, Class<T> classType, Class<U> classToInstantiate) throws InstantiationException, IllegalAccessException {
        WebApplicationContext parent = WebApplicationContextUtils.getWebApplicationContext((ServletContext)framework.getServletContext());
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        context.setParent((ApplicationContext)parent);
        context.register(new Class[]{classToInstantiate});
        context.refresh();
        Object t = context.getBean(classToInstantiate);
        if (t == null) {
            logger.info("Unable to find {}. Creating the object directly." + classToInstantiate.getName());
            return classToInstantiate.newInstance();
        }
        return (U)t;
    }

    public String toString() {
        return "Spring Web ObjectFactory";
    }
}

