/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.spring;

import java.beans.Introspector;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereObjectFactory;
import org.atmosphere.inject.Injectable;
import org.atmosphere.inject.InjectableObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringWebObjectFactory
extends InjectableObjectFactory {
    private static final Logger logger = LoggerFactory.getLogger(SpringWebObjectFactory.class);
    protected boolean preventSpringInjection = false;
    private final List<Class<?>> excludedFromInjection = new ArrayList();
    private AnnotationConfigApplicationContext context;

    public <T, U extends T> U newClassInstance(Class<T> classType, Class<U> classToInstantiate) throws InstantiationException, IllegalAccessException {
        Object t;
        if (this.preventSpringInjection && this.excludedFromInjection.contains(classType)) {
            logger.trace("Excluded from injection {}", (Object)classToInstantiate.getName());
            return classToInstantiate.newInstance();
        }
        String name = classToInstantiate.getSimpleName();
        if (!this.context.containsBeanDefinition(Introspector.decapitalize(name))) {
            this.context.register(new Class[]{classToInstantiate});
        }
        try {
            t = this.context.getAutowireCapableBeanFactory().createBean(classToInstantiate);
        }
        catch (BeanCreationException e) {
            t = super.newClassInstance(classType, classToInstantiate);
        }
        if (t == null) {
            logger.info("Unable to find {}. Creating the object directly." + classToInstantiate.getName());
            return classToInstantiate.newInstance();
        }
        return (U)t;
    }

    public AtmosphereObjectFactory allowInjectionOf(Injectable<?> injectable) {
        this.context.register(new Class[]{(Class)((ParameterizedType)injectable.getClass().getGenericSuperclass()).getActualTypeArguments()[0]});
        return this;
    }

    public String toString() {
        return "Spring Web ObjectFactory";
    }

    public void configure(AtmosphereConfig config) {
        super.configure(config);
        try {
            this.context = new AnnotationConfigApplicationContext();
            this.context.setParent((ApplicationContext)WebApplicationContextUtils.getWebApplicationContext((ServletContext)config.framework().getServletContext()));
            this.context.refresh();
            this.context.register(new Class[]{AtmosphereConfig.class});
            ((AtmosphereConfig)this.context.getBean(AtmosphereConfig.class, new Object[]{config.framework()})).populate(config);
        }
        catch (Exception ex) {
            logger.warn("Unable to configure injection", (Throwable)ex);
        }
    }
}

