/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr.packages;

import java.lang.reflect.Method;
import org.atmosphere.annotation.Processor;
import org.atmosphere.config.AtmosphereAnnotation;
import org.atmosphere.config.managed.Decoder;
import org.atmosphere.config.managed.Encoder;
import org.atmosphere.config.service.Message;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.stomp.annotation.StompEndpoint;
import org.atmosphere.stomp.annotation.StompService;
import org.atmosphere.stomp.handler.StompSendActionAtmosphereHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@AtmosphereAnnotation(value=StompEndpoint.class)
public class StompEndpointProcessor
implements Processor<Object> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void handle(AtmosphereFramework framework, Class<Object> annotatedClass) {
        Object instance;
        this.logger.info("Handling {}", (Object)annotatedClass.getName());
        try {
            instance = framework.newClassInstance(Object.class, annotatedClass);
        }
        catch (Exception iae) {
            this.logger.warn("Failed to process class annotated with {}", (Object)StompEndpoint.class.getName(), (Object)iae);
            return;
        }
        for (Method m : annotatedClass.getDeclaredMethods()) {
            Encoder encoder;
            Decoder decoder;
            String destination;
            block9: {
                this.logger.debug("Detecting annotation on method {}", (Object)m.getName());
                if (!m.isAnnotationPresent(StompService.class)) continue;
                destination = m.getAnnotation(StompService.class).destination();
                if (destination == null || destination.isEmpty()) {
                    this.logger.warn("The destination in {} must not be empty", (Object)StompService.class.getName(), (Object)new IllegalStateException());
                    continue;
                }
                if (m.isAnnotationPresent(Message.class)) {
                    try {
                        Message message = m.getAnnotation(Message.class);
                        decoder = (Decoder)framework.newClassInstance(Decoder.class, message.decoders()[0]);
                        encoder = (Encoder)framework.newClassInstance(Encoder.class, message.encoders()[0]);
                        break block9;
                    }
                    catch (Exception iae) {
                        this.logger.warn("Failed to process annotation {}", (Object)Message.class.getName(), (Object)iae);
                        continue;
                    }
                }
                decoder = null;
                encoder = null;
            }
            try {
                framework.addAtmosphereHandler(destination, (AtmosphereHandler)new StompSendActionAtmosphereHandler(instance, m, encoder, decoder, framework.getBroadcasterFactory().get((Object)destination)));
            }
            catch (IllegalArgumentException iae) {
                this.logger.warn("Method {} has not the required signature to be a {}", (Object)m.getName(), (Object)iae);
            }
        }
    }
}

