/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.stomp;

import java.io.IOException;
import java.util.Map;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceSessionFactory;
import org.atmosphere.stomp.AtmosphereStompAdapter;
import org.atmosphere.stomp.Subscriptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtmosphereStompAdapterImpl
implements AtmosphereStompAdapter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtmosphereResourceSessionFactory arsf = AtmosphereResourceSessionFactory.getDefault();

    private void callHandler(AtmosphereResource resource, Map<String, String> headers, AtmosphereFramework framework, boolean byId, Procedure call) throws IOException {
        Subscriptions retval = Subscriptions.getFromSession(this.arsf.getSession(resource));
        String mapping = byId ? retval.getDestinationForId(headers.get("id")) : headers.get("destination");
        AtmosphereFramework.AtmosphereHandlerWrapper handler = (AtmosphereFramework.AtmosphereHandlerWrapper)framework.endPointMapper().map(mapping, framework.getAtmosphereHandlers());
        if (handler != null) {
            call.apply(retval, mapping, handler);
        } else {
            this.logger.warn("No handler found for destination {}", (Object)mapping, (Object)new IllegalArgumentException());
        }
    }

    @Override
    public void subscribe(final AtmosphereResource resource, final Map<String, String> headers, final AtmosphereFramework framework) throws IOException {
        this.callHandler(resource, headers, framework, false, new Procedure(){

            public void apply(Subscriptions subscriptions, String destination, AtmosphereFramework.AtmosphereHandlerWrapper handler) throws IOException {
                subscriptions.addSubscription((String)headers.get("id"), destination);
                AtmosphereResource ar = framework.getAtmosphereConfig().resourcesFactory().find(resource.uuid());
                handler.broadcaster.addAtmosphereResource(ar == null ? resource : ar);
            }
        });
    }

    @Override
    public void unsubscribe(final AtmosphereResource resource, final Map<String, String> headers, final AtmosphereFramework framework) throws IOException {
        this.callHandler(resource, headers, framework, true, new Procedure(){

            public void apply(Subscriptions subscriptions, String destination, AtmosphereFramework.AtmosphereHandlerWrapper handler) {
                handler.broadcaster.removeAtmosphereResource(framework.getAtmosphereConfig().resourcesFactory().find(resource.uuid()));
                subscriptions.removeSubscription((String)headers.get("id"));
            }
        });
    }

    @Override
    public void send(final AtmosphereResource atmosphereResource, Map<String, String> headers, final String body, AtmosphereFramework framework) throws IOException {
        this.callHandler(atmosphereResource, headers, framework, false, new Procedure(){

            public void apply(Subscriptions subscriptions, String destination, AtmosphereFramework.AtmosphereHandlerWrapper handler) throws IOException {
                atmosphereResource.getRequest().setAttribute("org.atmosphere.stomp.body", (Object)(body != null && body.endsWith("\n") ? body.substring(0, body.length() - 1) : body));
                handler.atmosphereHandler.onRequest(atmosphereResource);
            }
        });
    }

    @Override
    public void begin(AtmosphereResource atmosphereResource) {
    }

    @Override
    public void commit(AtmosphereResource atmosphereResource, Map<String, String> headers) {
    }

    @Override
    public void abort(AtmosphereResource atmosphereResource, Map<String, String> headers) {
    }

    private static interface Procedure {
        public void apply(Subscriptions var1, String var2, AtmosphereFramework.AtmosphereHandlerWrapper var3) throws IOException;
    }
}

