/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.stomp;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceSessionFactory;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.BroadcastFilterLifecycle;
import org.atmosphere.cpr.PerRequestBroadcastFilter;
import org.atmosphere.stomp.StompInterceptor;
import org.atmosphere.stomp.Subscriptions;
import org.atmosphere.stomp.protocol.Action;
import org.atmosphere.stomp.protocol.Frame;
import org.atmosphere.stomp.protocol.StompFormat;

public class StompBroadcastFilter
implements PerRequestBroadcastFilter,
BroadcastFilterLifecycle {
    private StompFormat stompFormat;
    private AtmosphereResourceSessionFactory arsf = AtmosphereResourceSessionFactory.getDefault();

    public BroadcastFilter.BroadcastAction filter(String broadcasterId, AtmosphereResource atmosphereResource, Object originalMessage, Object message) {
        Subscriptions subscriptions = Subscriptions.getFromSession(this.arsf.getSession(atmosphereResource));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("destination", broadcasterId);
        List<String> subscriptionsIds = subscriptions.getSubscriptionsForDestination(broadcasterId);
        StringBuilder sb = new StringBuilder();
        for (String id : subscriptionsIds) {
            headers.put("message-id", String.valueOf(UUID.randomUUID()));
            headers.put("subscription", id);
            Frame frame = new Frame(Action.MESSAGE, headers, String.valueOf(message));
            sb.append(this.stompFormat.format(frame)).append("\n");
        }
        if (sb.length() == 0) {
            throw new IllegalStateException();
        }
        return new BroadcastFilter.BroadcastAction((Object)sb.toString());
    }

    public BroadcastFilter.BroadcastAction filter(String broadcasterId, Object originalMessage, Object message) {
        return new BroadcastFilter.BroadcastAction(message);
    }

    public void init(AtmosphereConfig config) {
        this.stompFormat = StompInterceptor.PropertyClass.STOMP_FORMAT_CLASS.retrieve(StompFormat.class, config);
    }

    public void destroy() {
        this.stompFormat = null;
        this.arsf = null;
    }
}

