/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.stomp;

import java.io.IOException;
import java.util.Set;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceSessionFactory;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.BroadcastFilterLifecycle;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.interceptor.AtmosphereResourceLifecycleInterceptor;
import org.atmosphere.stomp.AtmosphereStompAdapter;
import org.atmosphere.stomp.AtmosphereStompAdapterImpl;
import org.atmosphere.stomp.StompBroadcastFilter;
import org.atmosphere.stomp.Subscriptions;
import org.atmosphere.stomp.protocol.Frame;
import org.atmosphere.stomp.protocol.ParseException;
import org.atmosphere.stomp.protocol.StompFormat;
import org.atmosphere.stomp.protocol.StompFormatImpl;
import org.atmosphere.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StompInterceptor
extends AtmosphereResourceLifecycleInterceptor {
    public static final String IGNORE_ERROR = "org.atmosphere.stomp.ignoreError";
    public static final String STOMP_MESSAGE_BODY = "org.atmosphere.stomp.body";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private AtmosphereFramework framework;
    private StompFormat stompFormat;
    private AtmosphereStompAdapter adapter;
    private AtmosphereConfig atmosphereConfig;
    private AtmosphereResourceSessionFactory arsf;

    public void configure(AtmosphereConfig config) {
        super.configure(config);
        this.atmosphereConfig = config;
        this.framework = config.framework();
        this.stompFormat = PropertyClass.STOMP_FORMAT_CLASS.retrieve(StompFormat.class, config);
        this.adapter = PropertyClass.ADAPTER_CLASS.retrieve(AtmosphereStompAdapter.class, config);
        this.arsf = AtmosphereResourceSessionFactory.getDefault();
        this.framework.addAtmosphereHandler("/stomp", (AtmosphereHandler)new AbstractReflectorAtmosphereHandler.Default());
        try {
            BroadcastFilterLifecycle filter = (BroadcastFilterLifecycle)this.framework.newClassInstance(BroadcastFilterLifecycle.class, StompBroadcastFilter.class);
            this.framework.broadcasterFilters((BroadcastFilter)filter);
            filter.init(this.atmosphereConfig);
        }
        catch (InstantiationException e) {
            this.logger.error("", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.logger.error("", (Throwable)e);
        }
    }

    public Action inspect(AtmosphereResource r) {
        StringBuilder body = null;
        try {
            body = IOUtils.readEntirelyAsString((AtmosphereResource)r);
            if (body.length() == 0) {
                return Action.CONTINUE;
            }
            body.deleteCharAt(body.length() - 1);
            Frame message = this.stompFormat.parse(body.toString());
            switch (message.getAction()) {
                case SEND: {
                    this.adapter.send(r, message.getHeaders(), message.getBody(), this.framework);
                    break;
                }
                case SUBSCRIBE: {
                    this.adapter.subscribe(r, message.getHeaders(), this.framework);
                    break;
                }
                case UNSUBSCRIBE: {
                    this.adapter.unsubscribe(r, message.getHeaders(), this.framework);
                }
            }
        }
        catch (IOException ioe) {
            this.logger.error("STOMP interceptor fails", (Throwable)ioe);
        }
        catch (ParseException pe) {
            this.logger.error("Invalid STOMP string: {} ", (Object)body, (Object)pe);
        }
        return Action.SKIP_ATMOSPHEREHANDLER;
    }

    public void postInspect(AtmosphereResource atmosphereResource) {
        boolean wasAlreadySuspended = atmosphereResource.isSuspended();
        super.postInspect(atmosphereResource);
        if (!wasAlreadySuspended && atmosphereResource.isSuspended()) {
            Subscriptions s = Subscriptions.getFromSession(this.arsf.getSession(atmosphereResource));
            Set<String> destinations = s.getAllDestinations();
            for (String d : destinations) {
                BroadcasterFactory.getDefault().lookup((Object)d).addAtmosphereResource(atmosphereResource);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyClass {
        ADAPTER_CLASS("org.atmosphere.stomp.atmosphereStompAdapterClass", AtmosphereStompAdapterImpl.class.getName()),
        STOMP_FORMAT_CLASS("org.atmosphere.stomp.stompFormatClass", StompFormatImpl.class.getName());

        private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        private String propertyName;
        private String defaultClass;

        private PropertyClass(String propertyName, String defaultClass) {
            this.propertyName = propertyName;
            this.defaultClass = defaultClass;
        }

        public <T> T retrieve(Class<T> desiredType, AtmosphereConfig config) {
            String initParameter = config.getInitParameter(this.propertyName);
            String className = initParameter != null ? initParameter : this.defaultClass;
            try {
                AtmosphereFramework fwk = config.framework();
                Object retval = fwk.newClassInstance(desiredType, (Class)desiredType.getClass().cast(Class.forName(className)));
                return desiredType.cast(retval);
            }
            catch (Exception e) {
                this.logger.error("Unable to initialize {}", (Object)((Object)((Object)this)).getClass().getName(), (Object)e);
                return null;
            }
        }

        public String toString() {
            return this.propertyName;
        }
    }
}

