/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.stomp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.atmosphere.cpr.AtmosphereResourceSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subscriptions {
    private static final String ATTRIBUTE_KEY = Subscriptions.class.getName() + ".key";
    private List<Subscription> subscriptionList = new ArrayList<Subscription>();

    public static Subscriptions getFromSession(AtmosphereResourceSession session) {
        Object retval = session.getAttribute(ATTRIBUTE_KEY);
        if (retval == null) {
            retval = new Subscriptions();
            session.setAttribute(ATTRIBUTE_KEY, retval);
        }
        return (Subscriptions)Subscriptions.class.cast(retval);
    }

    public Set<String> getAllDestinations() {
        HashSet<String> destinations = new HashSet<String>();
        for (Subscription s : this.subscriptionList) {
            destinations.add(s.getDestination());
        }
        return destinations;
    }

    public void addSubscription(String id, String destination) {
        this.subscriptionList.add(new Subscription(id, destination));
    }

    public List<String> getSubscriptionsForDestination(String destination) {
        ArrayList<String> retval = new ArrayList<String>();
        for (Subscription s : this.subscriptionList) {
            if (!s.getDestination().equals(destination)) continue;
            retval.add(s.getId());
        }
        return retval;
    }

    public String getDestinationForId(String id) {
        for (Subscription s : this.subscriptionList) {
            if (!s.getId().equals(id)) continue;
            return s.getDestination();
        }
        throw new IllegalArgumentException();
    }

    public void removeSubscription(String id) {
        for (Subscription s : this.subscriptionList) {
            if (!s.getId().equals(id)) continue;
            this.subscriptionList.remove(s);
            return;
        }
    }

    class Subscription {
        private String id;
        private String destination;

        Subscription(String id, String destination) {
            this.destination = destination;
            this.id = id;
        }

        String getId() {
            return this.id;
        }

        String getDestination() {
            return this.destination;
        }
    }
}

