/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.stomp.handler;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.atmosphere.config.managed.Decoder;
import org.atmosphere.config.managed.Encoder;
import org.atmosphere.config.service.Message;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.stomp.annotation.StompEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StompSendActionAtmosphereHandler
extends AbstractReflectorAtmosphereHandler {
    private static final String IAE_MESSAGE = String.format("Method can expects as parameter '%s', '%s'. Otherwise it must provides decoders/encoders through the '%s' annotation", AtmosphereResource.class.getName(), String.class, Message.class.getName());
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Object toProxy;
    private final Method method;
    private final ParamProvider[] paramProviders;
    private final Encoder<Object, String> encoder;
    private final Broadcaster broadcaster;

    public StompSendActionAtmosphereHandler(Object toProxy, Method method, Encoder<Object, String> encoder, final Decoder<String, ?> decoder, final Broadcaster broadcaster) {
        this.toProxy = toProxy;
        this.method = method;
        this.encoder = encoder;
        this.broadcaster = broadcaster;
        Class<?>[] paramTypes = method.getParameterTypes();
        this.paramProviders = new ParamProvider[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<Object> paramType = paramTypes[i];
            if (paramType.isAssignableFrom(AtmosphereResource.class)) {
                this.paramProviders[i] = new ParamProvider(){

                    public Object getParam(AtmosphereResource atmosphereResource) {
                        return atmosphereResource;
                    }
                };
                continue;
            }
            if (paramType.isAssignableFrom(Broadcaster.class)) {
                this.paramProviders[i] = new ParamProvider(){

                    public Object getParam(AtmosphereResource atmosphereResource) {
                        return broadcaster;
                    }
                };
                continue;
            }
            if (paramType.isAssignableFrom(String.class)) {
                this.paramProviders[i] = new ParamProvider(){

                    public Object getParam(AtmosphereResource atmosphereResource) {
                        return atmosphereResource.getRequest().getAttribute("org.atmosphere.stomp.body");
                    }
                };
                continue;
            }
            if (decoder != null) {
                this.paramProviders[i] = new ParamProvider(){

                    public Object getParam(AtmosphereResource atmosphereResource) {
                        return decoder.decode((Object)atmosphereResource.getRequest().getAttribute("org.atmosphere.stomp.body").toString());
                    }
                };
                continue;
            }
            throw new IllegalArgumentException(IAE_MESSAGE);
        }
    }

    public void onRequest(AtmosphereResource atmosphereResource) throws IOException {
        try {
            Object[] params = new Object[this.paramProviders.length];
            for (int i = 0; i < params.length; ++i) {
                params[i] = this.paramProviders[i].getParam(atmosphereResource);
            }
            Object retval = this.method.invoke(this.toProxy, params);
            if (retval != null) {
                this.broadcaster.broadcast(this.encoder == null ? retval : this.encoder.encode(retval));
            }
        }
        catch (IllegalAccessException iae) {
            this.logger.warn("Failed to process class annotated {}", (Object)StompEndpoint.class.getName(), (Object)iae);
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private static interface ParamProvider {
        public Object getParam(AtmosphereResource var1);
    }
}

