/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.stomp.protocol;

import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Map;
import org.apache.activemq.apollo.stomp.BufferContent;
import org.apache.activemq.apollo.stomp.StompCodec;
import org.apache.activemq.apollo.stomp.StompContent;
import org.apache.activemq.apollo.stomp.StompFrame;
import org.atmosphere.stomp.protocol.Frame;
import org.atmosphere.stomp.protocol.ParseException;
import org.atmosphere.stomp.protocol.Parser;
import org.atmosphere.stomp.protocol.StompFormat;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import scala.Tuple2;
import scala.collection.JavaConversions;

public class StompFormatImpl
implements StompFormat {
    public Frame parse(String str) throws ParseException {
        Parser parser = new Parser(str);
        parser.parse();
        return parser.toFrame();
    }

    public String format(Frame msg) {
        DataByteArrayOutputStream dbaos = new DataByteArrayOutputStream();
        ArrayList<Tuple2> headers = new ArrayList<Tuple2>();
        for (Map.Entry<String, String> header : msg.getHeaders().entrySet()) {
            headers.add(new Tuple2((Object)new AsciiBuffer(header.getKey().toString().getBytes()), (Object)new AsciiBuffer(header.getValue().getBytes())));
        }
        BufferContent content = new BufferContent((Buffer)new AsciiBuffer(msg.getBody().getBytes(), 0, msg.getBody().length()));
        StompFrame sf = new StompFrame(new AsciiBuffer("MESSAGE".getBytes()), JavaConversions.asScalaBuffer(headers).toList(), (StompContent)content, false, JavaConversions.asScalaBuffer(new ArrayList()).toList());
        new StompCodec().encode(sf, (DataOutput)dbaos);
        String toString = new String(dbaos.getData());
        return toString.substring(0, toString.indexOf(0) + 1);
    }
}

