/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr.packages;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.atmosphere.annotation.Processor;
import org.atmosphere.config.AtmosphereAnnotation;
import org.atmosphere.config.managed.Decoder;
import org.atmosphere.config.managed.Encoder;
import org.atmosphere.config.service.Heartbeat;
import org.atmosphere.config.service.Message;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.stomp.annotation.StompEndpoint;
import org.atmosphere.stomp.annotation.StompService;
import org.atmosphere.stomp.handler.StompSendActionAtmosphereHandler;
import org.atmosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@AtmosphereAnnotation(value=StompEndpoint.class)
public class StompEndpointProcessor
implements Processor<Object> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static Method onHeartbeatMethod;
    private static Object heartbeatHandler;

    public static void invokeOnHeartbeat(AtmosphereResourceEvent event) {
        if (onHeartbeatMethod != null) {
            Utils.invoke((Object)heartbeatHandler, (Method)onHeartbeatMethod, (Object)event);
        }
    }

    public void handle(AtmosphereFramework framework, Class<Object> annotatedClass) {
        Object instance;
        this.logger.info("Handling {}", (Object)annotatedClass.getName());
        try {
            instance = framework.newClassInstance(Object.class, annotatedClass);
        }
        catch (Exception iae) {
            this.logger.warn("Failed to process class annotated with {}", (Object)StompEndpoint.class.getName(), (Object)iae);
            return;
        }
        List<Method> list = Arrays.asList(annotatedClass.getDeclaredMethods());
        heartbeatHandler = instance;
        Iterator<Method> it = list.iterator();
        while (it.hasNext() && onHeartbeatMethod == null) {
            onHeartbeatMethod = this.detectHeartbeat(it.next());
        }
        for (Method m : annotatedClass.getDeclaredMethods()) {
            this.detectStompService(framework, m, instance);
        }
    }

    private Method detectHeartbeat(Method method) {
        this.logger.debug("Detecting heartbeat annotation on method {}", (Object)method.getName());
        return method.isAnnotationPresent(Heartbeat.class) ? method : null;
    }

    private void detectStompService(AtmosphereFramework framework, Method method, Object instance) {
        this.logger.debug("Detecting annotation on method {}", (Object)method.getName());
        if (method.isAnnotationPresent(StompService.class)) {
            String destination = method.getAnnotation(StompService.class).destination();
            if (destination == null || destination.isEmpty()) {
                this.logger.warn("The destination in {} must not be empty", (Object)StompService.class.getName(), (Object)new IllegalStateException());
            } else {
                Encoder encoder;
                Decoder decoder;
                if (method.isAnnotationPresent(Message.class)) {
                    try {
                        Message message = method.getAnnotation(Message.class);
                        decoder = (Decoder)framework.newClassInstance(Decoder.class, message.decoders()[0]);
                        encoder = (Encoder)framework.newClassInstance(Encoder.class, message.encoders()[0]);
                    }
                    catch (Exception iae) {
                        this.logger.warn("Failed to process annotation {}", (Object)Message.class.getName(), (Object)iae);
                        return;
                    }
                } else {
                    decoder = null;
                    encoder = null;
                }
                try {
                    Broadcaster b = framework.getBroadcasterFactory().get((Object)destination);
                    StompSendActionAtmosphereHandler ah = new StompSendActionAtmosphereHandler(instance, method, encoder, decoder, b, onHeartbeatMethod);
                    framework.addAtmosphereHandler(destination, (AtmosphereHandler)ah);
                }
                catch (IllegalArgumentException iae) {
                    this.logger.warn("Method {} has not the required signature to be a {}", (Object)method.getName(), (Object)iae);
                }
            }
        }
    }
}

