/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.stomp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.atmosphere.cpr.AtmosphereResourceSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subscriptions {
    private static final String ATTRIBUTE_KEY = Subscriptions.class.getName() + ".key";
    private final Lock lock = new ReentrantLock();
    private List<Subscription> subscriptionList = new ArrayList<Subscription>();

    public static Subscriptions getFromSession(AtmosphereResourceSession session) {
        Object retval = session.getAttribute(ATTRIBUTE_KEY);
        if (retval == null) {
            retval = new Subscriptions();
            session.setAttribute(ATTRIBUTE_KEY, retval);
        }
        return (Subscriptions)Subscriptions.class.cast(retval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllDestinations() {
        try {
            this.lock.lock();
            HashSet<String> destinations = new HashSet<String>();
            for (Subscription s : this.subscriptionList) {
                destinations.add(s.getDestination());
            }
            HashSet<String> hashSet = destinations;
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscription(String id, String destination) {
        try {
            this.lock.lock();
            this.subscriptionList.add(new Subscription(id, destination));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSubscriptionsForDestination(String destination) {
        try {
            this.lock.lock();
            ArrayList<String> retval = new ArrayList<String>();
            for (Subscription s : this.subscriptionList) {
                if (!s.getDestination().equals(destination)) continue;
                retval.add(s.getId());
            }
            ArrayList<String> arrayList = retval;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getDestinationForId(String id) {
        try {
            this.lock.lock();
            for (Subscription s : this.subscriptionList) {
                if (!s.getId().equals(id)) continue;
                String string = s.getDestination();
                return string;
            }
            throw new IllegalArgumentException();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscription(String id) {
        try {
            this.lock.lock();
            for (Subscription s : this.subscriptionList) {
                if (!s.getId().equals(id)) continue;
                this.subscriptionList.remove(s);
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    class Subscription {
        private String id;
        private String destination;

        Subscription(String id, String destination) {
            this.destination = destination;
            this.id = id;
        }

        String getId() {
            return this.id;
        }

        String getDestination() {
            return this.destination;
        }
    }
}

