/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.stomp.handler;

import java.io.IOException;
import java.util.Map;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.stomp.Subscriptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HandlerHelper {
    INSTANCE;

    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void callHandler(AtmosphereResource resource, Map<String, String> headers, AtmosphereFramework framework, boolean byId, Procedure call) throws IOException {
        Subscriptions retval = Subscriptions.getFromSession(framework.sessionFactory().getSession(resource));
        String mapping = byId ? retval.getDestinationForId(headers.get("id")) : headers.get("destination");
        AtmosphereFramework.AtmosphereHandlerWrapper handler = (AtmosphereFramework.AtmosphereHandlerWrapper)framework.endPointMapper().map(mapping, framework.getAtmosphereHandlers());
        if (handler != null) {
            call.apply(retval, mapping, handler);
        } else {
            this.logger.warn("No handler found for destination {}", (Object)mapping, (Object)new IllegalArgumentException());
        }
    }

    public static interface Procedure {
        public void apply(Subscriptions var1, String var2, AtmosphereFramework.AtmosphereHandlerWrapper var3) throws IOException;
    }
}

