/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.stomp.interceptor;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.HeartbeatAtmosphereResourceEvent;
import org.atmosphere.cpr.packages.StompEndpointProcessor;
import org.atmosphere.interceptor.HeartbeatInterceptor;
import org.atmosphere.stomp.StompInterceptor;
import org.atmosphere.stomp.interceptor.FrameInterceptor;
import org.atmosphere.stomp.protocol.Frame;
import org.atmosphere.util.Version;

public class ConnectInterceptor
extends HeartbeatInterceptor
implements StompInterceptor {
    public static final byte[] STOMP_HEARTBEAT_DATA = new byte[]{10};
    public static final float DEFAULT_VERSION = 1.0f;
    public static final float HIGHEST_VERSION = 1.1f;
    public static final String VERSIONS = String.format("%f,%f", Float.valueOf(1.0f), Float.valueOf(1.1f));
    private static final String SERVER = "Atmosphere/" + Version.getDotedVersion();
    private ThreadLocal<Integer> desiredHeartbeat = new ThreadLocal();

    public void configure(AtmosphereConfig config) {
        super.configure(config);
        this.paddingText("hb".getBytes());
    }

    protected int extractHeartbeatInterval(AtmosphereResourceImpl resource) {
        return this.desiredHeartbeat.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Action inspect(AtmosphereFramework framework, Frame frame, FrameInterceptor.StompAtmosphereResource r) {
        try {
            if (org.atmosphere.stomp.protocol.Action.NULL.equals((Object)frame.getAction())) {
                HeartbeatAtmosphereResourceEvent event = new HeartbeatAtmosphereResourceEvent((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r.getResource()));
                r.getResource().addEventListener((AtmosphereResourceEventListener)new AtmosphereResourceEventListenerAdapter.OnHeartbeat(){

                    public void onHeartbeat(AtmosphereResourceEvent event) {
                        StompEndpointProcessor.invokeOnHeartbeat(event);
                    }
                });
                r.getResource().notifyListeners((AtmosphereResourceEvent)event);
                this.desiredHeartbeat.set(0);
                Action action = this.inspect(r.getResource());
                return action;
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            float version = this.parseVersion(frame.getHeaders().get("accept-version"));
            if (version == -1.0f) {
                headers.put("version", VERSIONS);
                r.write(org.atmosphere.stomp.protocol.Action.ERROR, headers, "Supported protocol versions are " + VERSIONS);
                Action action = Action.CANCELLED;
                return action;
            }
            Integer[] intervals = this.parseHeartBeat(frame.getHeaders().get("heart-beat"));
            int serverInterval = intervals[1];
            serverInterval = serverInterval != 0 ? Math.max((int)TimeUnit.SECONDS.convert(serverInterval, TimeUnit.MILLISECONDS), this.heartbeatFrequencyInSeconds()) : 0;
            this.desiredHeartbeat.set(serverInterval);
            Action retval = this.inspect(r.getResource());
            headers.put("version", String.valueOf(version));
            headers.put("session", r.getResource().uuid());
            headers.put("server", SERVER);
            headers.put("heart-beat", TimeUnit.MILLISECONDS.convert(serverInterval, TimeUnit.SECONDS) + "," + intervals[0]);
            r.write(org.atmosphere.stomp.protocol.Action.CONNECTED, headers);
            Action action = retval;
            return action;
        }
        finally {
            this.desiredHeartbeat.remove();
        }
    }

    private float parseVersion(String acceptVersion) {
        float retval;
        if (acceptVersion != null) {
            String[] versions;
            retval = -1.0f;
            for (String version : versions = acceptVersion.split(",")) {
                float clientVersion = Float.parseFloat(version);
                if (clientVersion != 1.0f && clientVersion != 1.1f) continue;
                retval = Math.max(retval, clientVersion);
            }
        } else {
            retval = 1.0f;
        }
        return retval;
    }

    private Integer[] parseHeartBeat(String heartbeat) {
        if (heartbeat == null) {
            return new Integer[]{0, 0};
        }
        String[] arr = heartbeat.split(",");
        return new Integer[]{Integer.parseInt(arr[0]), Integer.parseInt(arr[1])};
    }
}

