/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.stomp.interceptor;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceSessionFactory;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.BroadcastFilterLifecycle;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.stomp.StompBroadcastFilter;
import org.atmosphere.stomp.StompInterceptor;
import org.atmosphere.stomp.Subscriptions;
import org.atmosphere.stomp.interceptor.ConnectInterceptor;
import org.atmosphere.stomp.interceptor.DisconnectInterceptor;
import org.atmosphere.stomp.interceptor.SendInterceptor;
import org.atmosphere.stomp.interceptor.SubscribeInterceptor;
import org.atmosphere.stomp.interceptor.UnsubscribeInterceptor;
import org.atmosphere.stomp.protocol.Action;
import org.atmosphere.stomp.protocol.Frame;
import org.atmosphere.stomp.protocol.ParseException;
import org.atmosphere.stomp.protocol.StompFormat;
import org.atmosphere.stomp.protocol.StompFormatImpl;
import org.atmosphere.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameInterceptor
extends AtmosphereInterceptorAdapter
implements StompInterceptor {
    public static final String STOMP_MESSAGE_BODY = "org.atmosphere.stomp.body";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private AtmosphereFramework framework;
    private StompFormat stompFormat;
    private AtmosphereResourceSessionFactory arsf;
    private Map<Action, StompInterceptor> interceptors;

    public void configure(AtmosphereConfig config) {
        this.framework = config.framework();
        this.arsf = config.sessionFactory();
        this.setStompFormat(PropertyClass.STOMP_FORMAT_CLASS.retrieve(StompFormat.class, config));
        try {
            this.framework.addAtmosphereHandler("/stomp", (AtmosphereHandler)this.framework.newClassInstance(AtmosphereHandler.class, AbstractReflectorAtmosphereHandler.Default.class));
            this.interceptors = new ConcurrentHashMap<Action, StompInterceptor>();
            this.configureInterceptor(config, ConnectInterceptor.class, Action.CONNECT, Action.STOMP, Action.NULL);
            this.configureInterceptor(config, SubscribeInterceptor.class, Action.SUBSCRIBE);
            this.configureInterceptor(config, UnsubscribeInterceptor.class, Action.UNSUBSCRIBE);
            this.configureInterceptor(config, SendInterceptor.class, Action.SEND);
            this.configureInterceptor(config, DisconnectInterceptor.class, Action.DISCONNECT);
            BroadcastFilterLifecycle filter = (BroadcastFilterLifecycle)this.framework.newClassInstance(BroadcastFilterLifecycle.class, StompBroadcastFilter.class);
            this.framework.broadcasterFilters((BroadcastFilter)filter);
            filter.init(config);
        }
        catch (InstantiationException e) {
            this.logger.error("", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.logger.error("", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.atmosphere.cpr.Action inspect(AtmosphereResource r) {
        block8: {
            org.atmosphere.cpr.Action action;
            String body = null;
            body = IOUtils.readEntirelyAsString((AtmosphereResource)r).toString();
            if (body.length() == 0) {
                return org.atmosphere.cpr.Action.CONTINUE;
            }
            if (Arrays.equals(body.getBytes(), ConnectInterceptor.STOMP_HEARTBEAT_DATA)) {
                Frame f = new Frame(Action.NULL, new HashMap<String, String>());
                return this.inspect(this.framework, f, new StompAtmosphereResource(r, f));
            }
            Frame frame = this.stompFormat.parse(body.substring(0, body.length() - 1));
            StompAtmosphereResource sar = new StompAtmosphereResource(r, frame);
            try {
                action = this.inspect(this.framework, frame, sar);
            }
            catch (Throwable throwable) {
                try {
                    sar.receipt();
                    throw throwable;
                }
                catch (IOException ioe) {
                    this.logger.error("STOMP interceptor fails", (Throwable)ioe);
                    break block8;
                }
                catch (ParseException pe) {
                    this.logger.error("Invalid STOMP string: {} ", (Object)body, (Object)pe);
                }
            }
            sar.receipt();
            return action;
        }
        return org.atmosphere.cpr.Action.CANCELLED;
    }

    public void postInspect(AtmosphereResource atmosphereResource) {
        if (atmosphereResource.isSuspended()) {
            Subscriptions s = Subscriptions.getFromSession(this.arsf.getSession(atmosphereResource));
            Set<String> destinations = s.getAllDestinations();
            for (String d : destinations) {
                this.framework.getAtmosphereConfig().getBroadcasterFactory().lookup((Object)d).addAtmosphereResource(atmosphereResource);
            }
        }
    }

    @Override
    public org.atmosphere.cpr.Action inspect(AtmosphereFramework framework, Frame frame, StompAtmosphereResource r) throws IOException {
        StompInterceptor interceptor = this.interceptors.get((Object)frame.getAction());
        if (interceptor == null) {
            this.logger.warn("{} is not supported", (Object)frame.getAction().toString(), (Object)new UnsupportedOperationException());
            return org.atmosphere.cpr.Action.CANCELLED;
        }
        return interceptor.inspect(framework, frame, r);
    }

    public void setStompFormat(StompFormat stompFormat) {
        this.stompFormat = stompFormat;
    }

    private void configureInterceptor(AtmosphereConfig config, Class<? extends StompInterceptor> clazz, Action ... action) throws InstantiationException, IllegalAccessException {
        StompInterceptor interceptor = (StompInterceptor)this.framework.newClassInstance(StompInterceptor.class, clazz);
        interceptor.configure(config);
        for (Action a : action) {
            this.interceptors.put(a, interceptor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StompAtmosphereResource {
        private final AtmosphereResource resource;
        private final Frame frame;
        private boolean hasError;

        public StompAtmosphereResource(AtmosphereResource r, Frame f) {
            this.resource = r;
            this.frame = f;
        }

        public void write(Action a, Map<String, String> headers) {
            this.write(a, headers, null);
        }

        public void write(Action a, Map<String, String> headers, String message) {
            this.resource.write(FrameInterceptor.this.stompFormat.format(new Frame(a, headers, message)));
            if (!this.hasError) {
                this.hasError = Action.ERROR.equals((Object)a);
            }
        }

        private void receipt() {
            String receiptId;
            if (!this.hasError && !Action.CONNECT.equals((Object)this.frame.getAction()) && (receiptId = this.frame.getHeaders().get("receipt-id")) != null) {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("receipt-id", this.frame.getHeaders().get("receipt-id"));
                this.write(Action.RECEIPT, headers);
            }
        }

        public AtmosphereResource getResource() {
            return this.resource;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyClass {
        STOMP_FORMAT_CLASS("org.atmosphere.stomp.stompFormatClass", StompFormatImpl.class.getName());

        private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        private String propertyName;
        private String defaultClass;

        private PropertyClass(String propertyName, String defaultClass) {
            this.propertyName = propertyName;
            this.defaultClass = defaultClass;
        }

        public <T> T retrieve(Class<T> desiredType, AtmosphereConfig config) {
            String initParameter = config.getInitParameter(this.propertyName);
            String className = initParameter != null ? initParameter : this.defaultClass;
            try {
                AtmosphereFramework fwk = config.framework();
                Object retval = fwk.newClassInstance(desiredType, (Class)desiredType.getClass().cast(Class.forName(className)));
                return desiredType.cast(retval);
            }
            catch (Exception e) {
                this.logger.error("Unable to initialize {}", (Object)((Object)((Object)this)).getClass().getName(), (Object)e);
                return null;
            }
        }

        public String toString() {
            return this.propertyName;
        }
    }
}

