/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.stomp.protocol;

import java.util.Collections;
import java.util.Map;
import org.atmosphere.stomp.protocol.Action;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Frame {
    private final Action action;
    private final String body;
    private final Map<String, String> headers;

    public Frame(Action action, Map<String, String> headers, String body) {
        this.action = action;
        this.body = body;
        headers.put("content-length", String.valueOf(body == null ? 0 : body.getBytes().length));
        this.headers = Collections.unmodifiableMap(headers);
    }

    public Frame(Action action, Map<String, String> headers) {
        this(action, headers, null);
    }

    public Action getAction() {
        return this.action;
    }

    public String getBody() {
        return this.body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }
}

