/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.stomp.protocol;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.activemq.apollo.broker.store.MessageRecord;
import org.apache.activemq.apollo.stomp.StompCodec;
import org.apache.activemq.apollo.stomp.StompFrame;
import org.apache.activemq.apollo.stomp.StompFrameMessage;
import org.atmosphere.stomp.protocol.Action;
import org.atmosphere.stomp.protocol.Frame;
import org.atmosphere.stomp.protocol.ParseException;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;
import scala.Tuple2;

public class Parser {
    private String stream;
    private StompFrame sm;
    private Exception error;

    public Parser(String textStream) {
        this.stream = textStream;
    }

    public void parse() {
        try {
            MessageRecord mr = new MessageRecord();
            mr.buffer_$eq(new Buffer(this.stream.getBytes()));
            StompFrameMessage sfm = StompCodec.decode((MessageRecord)mr);
            this.sm = sfm.frame();
        }
        catch (Exception spe) {
            this.error = spe;
        }
    }

    public Frame toFrame() throws ParseException {
        if (this.sm == null && this.error == null) {
            this.parse();
            return this.toFrame();
        }
        if (this.error != null) {
            throw new ParseException(this.error);
        }
        Action action = Action.parse(this.sm.action().toString());
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Tuple2 tuple : this.sm.headers()) {
            headers.put(((AsciiBuffer)tuple._1()).toString(), ((AsciiBuffer)tuple._2()).toString());
        }
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        this.sm.content().writeTo((OutputStream)content);
        return new Frame(action, headers, new String(content.toByteArray()));
    }
}

