/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.atmosphere.container.version.JSR356WebSocket;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketEventListener;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSR356Endpoint
extends Endpoint {
    private static final Logger logger = LoggerFactory.getLogger(JSR356Endpoint.class);
    private final WebSocketProcessor webSocketProcessor;
    private AtmosphereRequest request;
    private final AtmosphereFramework framework;
    private WebSocket webSocket;
    private final int webSocketWriteTimeout;

    public JSR356Endpoint(AtmosphereFramework framework, WebSocketProcessor webSocketProcessor) {
        this.framework = framework;
        this.webSocketProcessor = webSocketProcessor;
        if (framework.isUseNativeImplementation()) {
            throw new IllegalStateException("You cannot use WebSocket native implementation with JSR356. Please set org.atmosphere.useNative to false");
        }
        String s = framework.getAtmosphereConfig().getInitParameter("org.atmosphere.websocket.maxIdleTime");
        this.webSocketWriteTimeout = s != null ? Integer.valueOf(s) : -1;
        s = framework.getAtmosphereConfig().getInitParameter("org.atmosphere.websocket.bufferSize");
        if (s != null) {
            // empty if block
        }
    }

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        this.webSocket = new JSR356WebSocket(session, this.framework.getAtmosphereConfig());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Sec-WebSocket-Version", "13");
        headers.put("Connection", "Upgrade");
        headers.put("Upgrade", "websocket");
        StringBuffer pathInfo = new StringBuffer("/");
        for (Map.Entry e : session.getPathParameters().entrySet()) {
            pathInfo.append((String)e.getValue());
        }
        try {
            this.request = new AtmosphereRequest.Builder().requestURI(session.getRequestURI().toASCIIString()).requestURL(session.getRequestURI().toASCIIString()).headers(headers).contextPath(this.framework.getServletContext().getContextPath()).pathInfo(pathInfo.toString()).build().queryString(session.getQueryString());
            this.framework.addInitParameter(ApplicationConfig.ALLOW_QUERYSTRING_AS_REQUEST, "false");
            this.webSocketProcessor.open(this.webSocket, this.request, AtmosphereResponse.newInstance(this.framework.getAtmosphereConfig(), this.request, this.webSocket));
            this.framework.addInitParameter(ApplicationConfig.ALLOW_QUERYSTRING_AS_REQUEST, "true");
        }
        catch (Throwable e) {
            try {
                session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, e.getMessage()));
            }
            catch (IOException e1) {
                logger.trace("", e);
            }
            logger.error("", e);
            return;
        }
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

            public void onMessage(String s) {
                JSR356Endpoint.this.webSocketProcessor.invokeWebSocketProtocol(JSR356Endpoint.this.webSocket, s);
            }
        });
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<ByteBuffer>(){

            public void onMessage(ByteBuffer bb) {
                byte[] b = new byte[bb.limit()];
                bb.get(b);
                JSR356Endpoint.this.webSocketProcessor.invokeWebSocketProtocol(JSR356Endpoint.this.webSocket, b, 0, b.length);
            }
        });
    }

    public void onClose(Session session, CloseReason closeCode) {
        logger.trace("{} closed {}", (Object)session, (Object)closeCode);
        this.request.destroy();
        this.webSocketProcessor.close(this.webSocket, closeCode.getCloseCode().getCode());
    }

    public void onError(Session session, Throwable t) {
        logger.error("", t);
        this.webSocketProcessor.notifyListener(this.webSocket, new WebSocketEventListener.WebSocketEvent<Throwable>(t, WebSocketEventListener.WebSocketEvent.TYPE.EXCEPTION, this.webSocket));
    }
}

