/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.config.managed;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.atmosphere.config.managed.Decoder;
import org.atmosphere.config.managed.Encoder;
import org.atmosphere.config.managed.Invoker;
import org.atmosphere.config.service.Delete;
import org.atmosphere.config.service.Disconnect;
import org.atmosphere.config.service.Get;
import org.atmosphere.config.service.Message;
import org.atmosphere.config.service.Post;
import org.atmosphere.config.service.Put;
import org.atmosphere.config.service.Ready;
import org.atmosphere.config.service.Resume;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.handler.AnnotatedProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedAtmosphereHandler
extends AbstractReflectorAtmosphereHandler
implements AnnotatedProxy {
    private Logger logger = LoggerFactory.getLogger(ManagedAtmosphereHandler.class);
    private static final List<Decoder<?, ?>> EMPTY = Collections.emptyList();
    private final Object object;
    private final List<Method> onRuntimeMethod;
    private final Method onDisconnectMethod;
    private final Method onTimeoutMethod;
    private final Method onGetMethod;
    private final Method onPostMethod;
    private final Method onPutMethod;
    private final Method onDeleteMethod;
    private final Method onReadyMethod;
    private final Method onResumeMethod;
    final Map<Method, List<Encoder<?, ?>>> encoders = new HashMap();
    final Map<Method, List<Decoder<?, ?>>> decoders = new HashMap();

    public ManagedAtmosphereHandler(Object c) {
        this.object = c;
        this.onRuntimeMethod = this.populateMessage(c, Message.class);
        this.onDisconnectMethod = this.populate(c, Disconnect.class);
        this.onTimeoutMethod = this.populate(c, Resume.class);
        this.onGetMethod = this.populate(c, Get.class);
        this.onPostMethod = this.populate(c, Post.class);
        this.onPutMethod = this.populate(c, Put.class);
        this.onDeleteMethod = this.populate(c, Delete.class);
        this.onReadyMethod = this.populate(c, Ready.class);
        this.onResumeMethod = this.populate(c, Resume.class);
        if (this.onRuntimeMethod.size() > 0) {
            this.populateEncoders();
            this.populateDecoders();
        }
    }

    @Override
    public void onRequest(final AtmosphereResource resource) throws IOException {
        AtmosphereRequest request = resource.getRequest();
        String method = request.getMethod();
        if (this.onReadyMethod != null) {
            resource.addEventListener(new AtmosphereResourceEventListenerAdapter(){

                @Override
                public void onSuspend(AtmosphereResourceEvent event) {
                    ManagedAtmosphereHandler.this.processReady(event.getResource());
                    event.getResource().removeEventListener(this);
                }
            });
        }
        if (this.onResumeMethod != null) {
            resource.addEventListener(new AtmosphereResourceEventListenerAdapter(){

                @Override
                public void onResume(AtmosphereResourceEvent event) {
                    ManagedAtmosphereHandler.this.invoke(ManagedAtmosphereHandler.this.onResumeMethod, event.getResource());
                    resource.removeEventListener(this);
                }
            });
        }
        if (method.equalsIgnoreCase("get")) {
            this.invoke(this.onGetMethod, resource);
        } else if (method.equalsIgnoreCase("post")) {
            this.invoke(this.onPostMethod, resource);
        } else if (method.equalsIgnoreCase("delete")) {
            this.invoke(this.onDeleteMethod, resource);
        } else if (method.equalsIgnoreCase("put")) {
            this.invoke(this.onPutMethod, resource);
        }
    }

    @Override
    public void onStateChange(AtmosphereResourceEvent event) throws IOException {
        Object o;
        AtmosphereResourceImpl r = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(event.getResource());
        Boolean resumeOnBroadcast = r.resumeOnBroadcast();
        if (!resumeOnBroadcast.booleanValue() && (o = r.getRequest(false).getAttribute("org.atmosphere.resumeOnBroadcast")) != null && Boolean.class.isAssignableFrom(o.getClass())) {
            resumeOnBroadcast = (Boolean)Boolean.class.cast(o);
        }
        if (resumeOnBroadcast.booleanValue()) {
            r.resumeOnBroadcast(false);
            r.getRequest(false).setAttribute("org.atmosphere.resumeOnBroadcast", false);
        }
        AtmosphereResource resource = event.getResource();
        if (event.isCancelled() || event.isClosedByClient()) {
            this.invoke(this.onDisconnectMethod, resource);
        } else if (event.isResumedOnTimeout() || event.isResuming()) {
            this.invoke(this.onTimeoutMethod, resource);
        } else {
            Object msg = event.getMessage();
            for (Method m : this.onRuntimeMethod) {
                Object o2 = Invoker.encode(this.encoders.get(m), msg);
                if (o2 == null) continue;
                event.setMessage(o2);
                break;
            }
            super.onStateChange(event);
        }
        if (resumeOnBroadcast.booleanValue() && r.isSuspended()) {
            r.resume();
        }
    }

    public Object invoke(Object msg) throws IOException {
        Object o = this.message(msg);
        if (o != null) {
            return o;
        }
        if (this.onRuntimeMethod.size() == 0) {
            return msg;
        }
        return o;
    }

    private Method populate(Object c, Class<? extends Annotation> annotation) {
        for (Method m : c.getClass().getMethods()) {
            if (!m.isAnnotationPresent(annotation)) continue;
            return m;
        }
        return null;
    }

    private List<Method> populateMessage(Object c, Class<? extends Annotation> annotation) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method m : c.getClass().getMethods()) {
            if (!m.isAnnotationPresent(annotation)) continue;
            methods.add(m);
        }
        return methods;
    }

    private void populateEncoders() {
        for (Method m : this.onRuntimeMethod) {
            CopyOnWriteArrayList<Encoder> l = new CopyOnWriteArrayList<Encoder>();
            for (Class<? extends Encoder> s : m.getAnnotation(Message.class).encoders()) {
                try {
                    l.add(s.newInstance());
                }
                catch (Exception e) {
                    this.logger.error("Unable to load encoder {}", s);
                }
            }
            this.encoders.put(m, l);
        }
        if (this.onReadyMethod != null) {
            CopyOnWriteArrayList<Encoder> l = new CopyOnWriteArrayList<Encoder>();
            for (Class<? extends Encoder> s : this.onReadyMethod.getAnnotation(Ready.class).encoders()) {
                try {
                    l.add(s.newInstance());
                }
                catch (Exception e) {
                    this.logger.error("Unable to load encoder {}", s);
                }
            }
            this.encoders.put(this.onReadyMethod, l);
        }
    }

    private void populateDecoders() {
        for (Method m : this.onRuntimeMethod) {
            CopyOnWriteArrayList<Decoder> l = new CopyOnWriteArrayList<Decoder>();
            for (Class<? extends Decoder> s : m.getAnnotation(Message.class).decoders()) {
                try {
                    l.add(s.newInstance());
                }
                catch (Exception e) {
                    this.logger.error("Unable to load encoder {}", s);
                }
            }
            this.decoders.put(m, l);
        }
    }

    protected Class<?> loadClass(String className) throws Exception {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (Throwable t) {
            return this.getClass().getClassLoader().loadClass(className);
        }
    }

    private Object invoke(Method m, Object o) {
        if (m != null) {
            try {
                Object[] objectArray;
                if (o == null) {
                    objectArray = new Object[]{};
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = o;
                }
                return m.invoke(this.object, objectArray);
            }
            catch (IllegalAccessException e) {
                this.logger.debug("", e);
            }
            catch (InvocationTargetException e) {
                this.logger.debug("", e);
            }
        }
        return null;
    }

    private Object message(Object o) {
        try {
            for (Method m : this.onRuntimeMethod) {
                Object objectToEncode;
                Object decoded = Invoker.decode(this.decoders.get(m), o);
                if (decoded == null) {
                    decoded = o;
                }
                if ((objectToEncode = Invoker.invokeMethod(m, this.object, decoded)) == null) continue;
                return Invoker.encode(this.encoders.get(m), objectToEncode);
            }
        }
        catch (Throwable t) {
            this.logger.error("", t);
        }
        return null;
    }

    private Object message(Method m, Object o) {
        if (m != null) {
            return Invoker.all(this.encoders.get(m), EMPTY, o, this.object, m);
        }
        return null;
    }

    @Override
    public Object target() {
        return this.object;
    }

    protected void processReady(AtmosphereResource r) {
        Object o = this.message(this.onReadyMethod, r);
        switch (this.onReadyMethod.getAnnotation(Ready.class).value()) {
            case RESOURCE: {
                if (o == null) break;
                if (String.class.isAssignableFrom(o.getClass())) {
                    r.write(o.toString());
                    break;
                }
                if (!byte[].class.isAssignableFrom(o.getClass())) break;
                r.write((byte[])o);
                break;
            }
            case BROADCASTER: {
                r.getBroadcaster().broadcast(o);
                break;
            }
            case ALL: {
                for (Broadcaster b : r.getAtmosphereConfig().getBroadcasterFactory().lookupAll()) {
                    b.broadcast(o);
                }
                break;
            }
        }
    }

    public String toString() {
        return "ManagedAtmosphereHandler proxy for " + this.object.getClass().getName();
    }
}

