/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.atmosphere.config.service.Singleton;
import org.atmosphere.config.service.WebSocketHandlerService;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereMappingException;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceFactory;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.util.DefaultEndpointMapper;
import org.atmosphere.util.EndpointMapper;
import org.atmosphere.util.ExecutorsFactory;
import org.atmosphere.util.VoidExecutorService;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketEventListener;
import org.atmosphere.websocket.WebSocketHandler;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocol;
import org.atmosphere.websocket.WebSocketProtocolStream;
import org.atmosphere.websocket.WebSocketStreamingHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWebSocketProcessor
implements WebSocketProcessor,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(DefaultWebSocketProcessor.class);
    private final AtmosphereFramework framework;
    private final WebSocketProtocol webSocketProtocol;
    private final AtomicBoolean loggedMsg = new AtomicBoolean(false);
    private final boolean destroyable;
    private final boolean executeAsync;
    private ExecutorService asyncExecutor;
    private ScheduledExecutorService scheduler;
    private final Map<String, WebSocketHandler> handlers = new HashMap<String, WebSocketHandler>();
    private final EndpointMapper<WebSocketHandler> mapper = new DefaultEndpointMapper<WebSocketHandler>();
    private final AtmosphereHandler voidHandler = new AtmosphereHandler(){

        @Override
        public void onRequest(AtmosphereResource resource) throws IOException {
        }

        @Override
        public void onStateChange(AtmosphereResourceEvent event) throws IOException {
        }

        @Override
        public void destroy() {
        }
    };
    private boolean wildcardMapping = false;
    private int byteBufferMaxSize = 0x200000;
    private int charBufferMaxSize = 0x200000;
    private ByteBuffer bb = ByteBuffer.allocate(8192);
    private CharBuffer cb = CharBuffer.allocate(8192);

    public DefaultWebSocketProcessor(AtmosphereFramework framework) {
        this.framework = framework;
        this.webSocketProtocol = framework.getWebSocketProtocol();
        String s = framework.getAtmosphereConfig().getInitParameter(ApplicationConfig.RECYCLE_ATMOSPHERE_REQUEST_RESPONSE);
        this.destroyable = s != null && Boolean.valueOf(s) != false;
        s = framework.getAtmosphereConfig().getInitParameter(ApplicationConfig.WEBSOCKET_PROTOCOL_EXECUTION);
        this.executeAsync = s != null && Boolean.valueOf(s) != false;
        AtmosphereConfig config = framework.getAtmosphereConfig();
        this.asyncExecutor = this.executeAsync ? ExecutorsFactory.getAsyncOperationExecutor(config, "WebSocket") : VoidExecutorService.VOID;
        this.scheduler = ExecutorsFactory.getScheduler(config);
        this.optimizeMapping();
    }

    @Override
    public WebSocketProcessor registerWebSocketHandler(String path, WebSocketHandler webSockethandler) {
        this.handlers.put(path, webSockethandler);
        return this;
    }

    @Override
    public final void open(final WebSocket webSocket, AtmosphereRequest request, AtmosphereResponse response) throws IOException {
        if (!this.loggedMsg.getAndSet(true)) {
            logger.debug("Atmosphere detected WebSocket: {}", (Object)webSocket.getClass().getName());
        }
        if (this.framework.getAtmosphereConfig().handlers().size() == 0) {
            this.framework.addAtmosphereHandler("/*", this.voidHandler);
        }
        request.headers(DefaultWebSocketProcessor.configureHeader(request)).setAttribute(WebSocket.WEBSOCKET_SUSPEND, true);
        AtmosphereResource r = AtmosphereResourceFactory.getDefault().create(this.framework.getAtmosphereConfig(), response, this.framework.getAsyncSupport());
        request.setAttribute(FrameworkConfig.INJECTED_ATMOSPHERE_RESOURCE, r);
        request.setAttribute(ApplicationConfig.SUSPENDED_ATMOSPHERE_RESOURCE_UUID, r.uuid());
        webSocket.resource(r);
        this.webSocketProtocol.onOpen(webSocket);
        this.dispatch(webSocket, request, response);
        if (this.handlers.size() != 0) {
            WebSocketHandler handler = this.mapper.map(request, this.handlers);
            if (handler == null) {
                logger.debug("No WebSocketHandler maps request for {} with mapping {}", (Object)request.getRequestURI(), this.handlers);
                throw new AtmosphereMappingException("No AtmosphereHandler maps request for " + request.getRequestURI());
            }
            handler = this.postProcessMapping(request, handler);
            webSocket.webSocketHandler(handler).resource().suspend(-1L);
            handler.onOpen(webSocket);
        }
        request.removeAttribute(FrameworkConfig.INJECTED_ATMOSPHERE_RESOURCE);
        if (webSocket.resource() != null) {
            final AsynchronousProcessor.AsynchronousProcessorHook hook = new AsynchronousProcessor.AsynchronousProcessorHook((AtmosphereResourceImpl)webSocket.resource());
            request.setAttribute(FrameworkConfig.ASYNCHRONOUS_HOOK, hook);
            final Action action = ((AtmosphereResourceImpl)webSocket.resource()).action();
            if (action.timeout() != -1L && !this.framework.getAsyncSupport().getContainerName().contains("Netty")) {
                final AtomicReference f = new AtomicReference();
                f.set(this.scheduler.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        if (WebSocket.class.isAssignableFrom(webSocket.getClass()) && System.currentTimeMillis() - ((WebSocket)WebSocket.class.cast(webSocket)).lastWriteTimeStampInMilliseconds() > action.timeout()) {
                            hook.timedOut();
                            ((Future)f.get()).cancel(true);
                        }
                    }
                }, action.timeout(), action.timeout(), TimeUnit.MILLISECONDS));
            }
        } else {
            logger.warn("AtmosphereResource was null");
        }
        this.notifyListener(webSocket, new WebSocketEventListener.WebSocketEvent<String>("", WebSocketEventListener.WebSocketEvent.TYPE.CONNECT, webSocket));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebSocketHandler postProcessMapping(AtmosphereRequest request, WebSocketHandler w) {
        if (!this.wildcardMapping()) {
            return w;
        }
        String pathInfo = null;
        try {
            pathInfo = request.getPathInfo();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        String path = pathInfo != null ? request.getServletPath() + pathInfo : request.getServletPath();
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        Map<String, WebSocketHandler> map = this.handlers;
        synchronized (map) {
            String targetPath;
            if (this.handlers.get(path) == null && w.getClass().getAnnotation(WebSocketHandlerService.class) != null && (targetPath = w.getClass().getAnnotation(WebSocketHandlerService.class).path()).indexOf("{") != -1 && targetPath.indexOf("}") != -1) {
                try {
                    boolean singleton;
                    boolean bl = singleton = w.getClass().getAnnotation(Singleton.class) != null;
                    if (!singleton) {
                        this.registerWebSocketHandler(path, (WebSocketHandler)w.getClass().newInstance());
                    } else {
                        this.registerWebSocketHandler(path, w);
                    }
                    return this.handlers.get(path);
                }
                catch (Throwable e) {
                    logger.warn("Unable to create WebSocketHandler", e);
                }
            }
        }
        return w;
    }

    private void dispatch(final WebSocket webSocket, List<AtmosphereRequest> list) {
        if (list == null) {
            return;
        }
        for (final AtmosphereRequest r : list) {
            if (r == null) continue;
            boolean b = r.dispatchRequestAsynchronously();
            this.asyncExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AtmosphereResponse w = new AtmosphereResponse(webSocket, r, DefaultWebSocketProcessor.this.destroyable);
                    try {
                        DefaultWebSocketProcessor.this.dispatch(webSocket, r, w);
                    }
                    finally {
                        r.destroy();
                        w.destroy();
                    }
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void invokeWebSocketProtocol(WebSocket webSocket, String webSocketMessage) {
        WebSocketHandler webSocketHandler = webSocket.webSocketHandler();
        if (webSocketHandler == null) {
            if (WebSocketProtocolStream.class.isAssignableFrom(this.webSocketProtocol.getClass())) {
                logger.debug("The WebServer doesn't support streaming. Wrapping the message as stream.");
                this.invokeWebSocketProtocol(webSocket, new StringReader(webSocketMessage));
                return;
            }
            List<AtmosphereRequest> list = this.webSocketProtocol.onMessage(webSocket, webSocketMessage);
            this.dispatch(webSocket, list);
        } else {
            if (WebSocketStreamingHandler.class.isAssignableFrom(webSocketHandler.getClass())) {
                logger.debug("The WebServer doesn't support streaming. Wrapping the message as stream.");
                this.invokeWebSocketProtocol(webSocket, new StringReader(webSocketMessage));
                return;
            }
            try {
                webSocketHandler.onTextMessage(webSocket, webSocketMessage);
            }
            catch (Exception ex) {
                webSocketHandler.onError(webSocket, new WebSocketProcessor.WebSocketException(ex, new AtmosphereResponse.Builder().request(webSocket.resource().getRequest()).status(500).statusMessage("Server Error").build()));
            }
        }
        this.notifyListener(webSocket, new WebSocketEventListener.WebSocketEvent<String>(webSocketMessage, WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, webSocket));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void invokeWebSocketProtocol(WebSocket webSocket, byte[] data, int offset, int length) {
        WebSocketHandler webSocketHandler = webSocket.webSocketHandler();
        if (webSocketHandler == null) {
            if (WebSocketProtocolStream.class.isAssignableFrom(this.webSocketProtocol.getClass())) {
                logger.debug("The WebServer doesn't support streaming. Wrapping the message as stream.");
                this.invokeWebSocketProtocol(webSocket, new ByteArrayInputStream(data, offset, length));
                return;
            }
            List<AtmosphereRequest> list = this.webSocketProtocol.onMessage(webSocket, data, offset, length);
            this.dispatch(webSocket, list);
        } else {
            if (WebSocketStreamingHandler.class.isAssignableFrom(webSocketHandler.getClass())) {
                logger.debug("The WebServer doesn't support streaming. Wrapping the message as stream.");
                this.invokeWebSocketProtocol(webSocket, new ByteArrayInputStream(data, offset, length));
                return;
            }
            try {
                webSocketHandler.onByteMessage(webSocket, data, offset, length);
            }
            catch (Exception ex) {
                webSocketHandler.onError(webSocket, new WebSocketProcessor.WebSocketException(ex, new AtmosphereResponse.Builder().request(webSocket.resource().getRequest()).status(500).statusMessage("Server Error").build()));
            }
        }
        this.notifyListener(webSocket, new WebSocketEventListener.WebSocketEvent<byte[]>(data, WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, webSocket));
    }

    @Override
    public void invokeWebSocketProtocol(WebSocket webSocket, InputStream stream) {
        block5: {
            WebSocketHandler webSocketHandler = webSocket.webSocketHandler();
            try {
                if (webSocketHandler == null) {
                    if (!WebSocketProtocolStream.class.isAssignableFrom(this.webSocketProtocol.getClass())) {
                        List<AtmosphereRequest> list = ((WebSocketProtocolStream)WebSocketProtocolStream.class.cast(this.webSocketProtocol)).onBinaryStream(webSocket, stream);
                        this.dispatch(webSocket, list);
                        break block5;
                    }
                    this.dispatchStream(webSocket, stream);
                    return;
                }
                if (WebSocketStreamingHandler.class.isAssignableFrom(webSocketHandler.getClass())) {
                    ((WebSocketStreamingHandler)WebSocketStreamingHandler.class.cast(webSocketHandler)).onBinaryStream(webSocket, stream);
                    break block5;
                }
                this.dispatchStream(webSocket, stream);
                return;
            }
            catch (Exception ex) {
                webSocketHandler.onError(webSocket, new WebSocketProcessor.WebSocketException(ex, new AtmosphereResponse.Builder().request(webSocket.resource().getRequest()).status(500).statusMessage("Server Error").build()));
            }
        }
        this.notifyListener(webSocket, new WebSocketEventListener.WebSocketEvent<InputStream>(stream, WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, webSocket));
    }

    @Override
    public void invokeWebSocketProtocol(WebSocket webSocket, Reader reader) {
        block5: {
            WebSocketHandler webSocketHandler = webSocket.webSocketHandler();
            try {
                if (webSocketHandler == null) {
                    if (WebSocketProtocolStream.class.isAssignableFrom(this.webSocketProtocol.getClass())) {
                        List<AtmosphereRequest> list = ((WebSocketProtocolStream)WebSocketProtocolStream.class.cast(this.webSocketProtocol)).onTextStream(webSocket, reader);
                        this.dispatch(webSocket, list);
                        break block5;
                    }
                    this.dispatchReader(webSocket, reader);
                    return;
                }
                if (WebSocketStreamingHandler.class.isAssignableFrom(webSocketHandler.getClass())) {
                    ((WebSocketStreamingHandler)WebSocketStreamingHandler.class.cast(webSocketHandler)).onTextStream(webSocket, reader);
                    break block5;
                }
                this.dispatchReader(webSocket, reader);
                return;
            }
            catch (Exception ex) {
                webSocketHandler.onError(webSocket, new WebSocketProcessor.WebSocketException(ex, new AtmosphereResponse.Builder().request(webSocket.resource().getRequest()).status(500).statusMessage("Server Error").build()));
            }
        }
        this.notifyListener(webSocket, new WebSocketEventListener.WebSocketEvent<Reader>(reader, WebSocketEventListener.WebSocketEvent.TYPE.MESSAGE, webSocket));
    }

    public final void dispatch(WebSocket webSocket, AtmosphereRequest request, AtmosphereResponse r) {
        if (request == null) {
            return;
        }
        try {
            this.framework.doCometSupport(request, r);
        }
        catch (Throwable e) {
            logger.warn("Failed invoking AtmosphereFramework.doCometSupport()", e);
            this.webSocketProtocol.onError(webSocket, new WebSocketProcessor.WebSocketException(e, new AtmosphereResponse.Builder().request(request).status(500).statusMessage("Server Error").build()));
            return;
        }
        if (r.getStatus() >= 400) {
            this.webSocketProtocol.onError(webSocket, new WebSocketProcessor.WebSocketException("Status code higher or equal than 400", r));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(WebSocket webSocket, int closeCode) {
        block18: {
            logger.trace("WebSocket closed with {}", closeCode);
            WebSocketHandler webSocketHandler = webSocket.webSocketHandler();
            this.notifyListener(webSocket, new WebSocketEventListener.WebSocketEvent<String>("", WebSocketEventListener.WebSocketEvent.TYPE.CLOSE, webSocket));
            AtmosphereResourceImpl resource = (AtmosphereResourceImpl)webSocket.resource();
            if (resource == null) {
                logger.warn("Unable to retrieve AtmosphereResource for {}", webSocket);
            } else {
                AtmosphereRequest r = resource.getRequest(false);
                AtmosphereResponse s = resource.getResponse(false);
                try {
                    this.webSocketProtocol.onClose(webSocket);
                    if (resource == null || !resource.isInScope()) break block18;
                    if (webSocketHandler != null) {
                        webSocketHandler.onClose(webSocket);
                    }
                    AsynchronousProcessor.AsynchronousProcessorHook h = (AsynchronousProcessor.AsynchronousProcessorHook)r.getAttribute(FrameworkConfig.ASYNCHRONOUS_HOOK);
                    if (!resource.isCancelled()) {
                        if (h != null) {
                            if (closeCode == 1000 && this.framework.getAsyncSupport().getContainerName().contains("Tomcat")) {
                                closeCode = 1005;
                            }
                            if (closeCode == 1005) {
                                h.closed();
                            } else {
                                h.timedOut();
                            }
                        } else if (webSocketHandler == null) {
                            logger.warn("AsynchronousProcessor.AsynchronousProcessorHook was null");
                        }
                        resource.setIsInScope(false);
                        try {
                            resource.cancel();
                        }
                        catch (IOException e) {
                            logger.trace("", e);
                        }
                    }
                    ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(resource))._destroy();
                }
                finally {
                    if (r != null) {
                        r.destroy(true);
                    }
                    if (s != null) {
                        s.destroy(true);
                    }
                    if (webSocket != null) {
                        webSocket.resource(null);
                    }
                }
            }
        }
    }

    @Override
    public void destroy() {
        boolean shared = this.framework.isShareExecutorServices();
        if (this.asyncExecutor != null && !shared) {
            this.asyncExecutor.shutdown();
        }
        if (this.scheduler != null && !shared) {
            this.scheduler.shutdown();
        }
    }

    @Override
    public void notifyListener(WebSocket webSocket, WebSocketEventListener.WebSocketEvent event) {
        AtmosphereResource resource = webSocket.resource();
        if (resource == null) {
            return;
        }
        AtmosphereResourceImpl r = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(resource);
        for (AtmosphereResourceEventListener l : r.atmosphereResourceEventListener()) {
            if (!WebSocketEventListener.class.isAssignableFrom(l.getClass())) continue;
            try {
                switch (event.type()) {
                    case CONNECT: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onConnect(event);
                        break;
                    }
                    case DISCONNECT: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onDisconnect(event);
                        break;
                    }
                    case CONTROL: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onControl(event);
                        break;
                    }
                    case MESSAGE: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onMessage(event);
                        break;
                    }
                    case HANDSHAKE: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onHandshake(event);
                        break;
                    }
                    case CLOSE: {
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onDisconnect(event);
                        ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onClose(event);
                    }
                }
            }
            catch (Throwable t) {
                logger.debug("Listener error {}", t);
                try {
                    ((WebSocketEventListener)WebSocketEventListener.class.cast(l)).onThrowable(new AtmosphereResourceEventImpl(r, false, false, t));
                }
                catch (Throwable t2) {
                    logger.warn("Listener error {}", t2);
                }
            }
        }
    }

    public static final Map<String, String> configureHeader(AtmosphereRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration<String> e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String s = e.nextElement();
            headers.put(s, request.getParameter(s));
        }
        headers.put("X-Atmosphere-Transport", "websocket");
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchStream(WebSocket webSocket, InputStream is) throws IOException {
        int read = 0;
        while (read > -1) {
            this.bb.position(this.bb.position() + read);
            if (this.bb.remaining() == 0) {
                this.resizeByteBuffer();
            }
            read = is.read(this.bb.array(), this.bb.position(), this.bb.remaining());
        }
        this.bb.flip();
        try {
            this.invokeWebSocketProtocol(webSocket, this.bb.array(), 0, this.bb.limit());
        }
        finally {
            this.bb.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchReader(WebSocket webSocket, Reader r) throws IOException {
        int read = 0;
        while (read > -1) {
            this.cb.position(this.cb.position() + read);
            if (this.cb.remaining() == 0) {
                this.resizeCharBuffer();
            }
            read = r.read(this.cb.array(), this.cb.position(), this.cb.remaining());
        }
        this.cb.flip();
        try {
            this.invokeWebSocketProtocol(webSocket, this.cb.toString());
        }
        finally {
            this.cb.clear();
        }
    }

    private void resizeByteBuffer() throws IOException {
        int maxSize = this.getByteBufferMaxSize();
        if (this.bb.limit() >= maxSize) {
            throw new IOException("Message Buffer too small");
        }
        long newSize = this.bb.limit() * 2;
        if (newSize > (long)maxSize) {
            newSize = maxSize;
        }
        ByteBuffer newBuffer = ByteBuffer.allocate((int)newSize);
        this.bb.rewind();
        newBuffer.put(this.bb);
        this.bb = newBuffer;
    }

    private void resizeCharBuffer() throws IOException {
        int maxSize = this.getCharBufferMaxSize();
        if (this.cb.limit() >= maxSize) {
            throw new IOException("Message Buffer too small");
        }
        long newSize = this.cb.limit() * 2;
        if (newSize > (long)maxSize) {
            newSize = maxSize;
        }
        CharBuffer newBuffer = CharBuffer.allocate((int)newSize);
        this.cb.rewind();
        newBuffer.put(this.cb);
        this.cb = newBuffer;
    }

    public final int getByteBufferMaxSize() {
        return this.byteBufferMaxSize;
    }

    public final void setByteBufferMaxSize(int byteBufferMaxSize) {
        this.byteBufferMaxSize = byteBufferMaxSize;
    }

    public final int getCharBufferMaxSize() {
        return this.charBufferMaxSize;
    }

    public final void setCharBufferMaxSize(int charBufferMaxSize) {
        this.charBufferMaxSize = charBufferMaxSize;
    }

    protected void optimizeMapping() {
        for (String w : this.framework.getAtmosphereConfig().handlers().keySet()) {
            if (!w.contains("{") || !w.contains("}")) continue;
            this.wildcardMapping = true;
        }
    }

    public boolean wildcardMapping() {
        return this.wildcardMapping;
    }
}

