/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core;

import java.util.ServiceLoader;
import org.vertx.java.core.Handler;
import org.vertx.java.core.VertxFactory;
import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.core.file.FileSystem;
import org.vertx.java.core.http.HttpClient;
import org.vertx.java.core.http.HttpServer;
import org.vertx.java.core.net.NetClient;
import org.vertx.java.core.net.NetServer;
import org.vertx.java.core.shareddata.SharedData;
import org.vertx.java.core.sockjs.SockJSServer;

public abstract class Vertx {
    private static VertxFactory loadFactory() {
        ServiceLoader<VertxFactory> factories = ServiceLoader.load(VertxFactory.class);
        return factories.iterator().next();
    }

    public static Vertx newVertx() {
        return Vertx.loadFactory().createVertx();
    }

    public static Vertx newVertx(String hostname) {
        return Vertx.loadFactory().createVertx(hostname);
    }

    public static Vertx newVertx(int port, String hostname) {
        return Vertx.loadFactory().createVertx(port, hostname);
    }

    public abstract NetServer createNetServer();

    public abstract NetClient createNetClient();

    public abstract HttpServer createHttpServer();

    public abstract HttpClient createHttpClient();

    public abstract SockJSServer createSockJSServer(HttpServer var1);

    public abstract FileSystem fileSystem();

    public abstract EventBus eventBus();

    public abstract SharedData sharedData();

    public abstract long setTimer(long var1, Handler<Long> var3);

    public abstract long setPeriodic(long var1, Handler<Long> var3);

    public abstract boolean cancelTimer(long var1);

    public abstract void runOnLoop(Handler<Void> var1);

    public abstract boolean isEventLoop();

    public abstract boolean isWorker();

    public abstract void stop();
}

