/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.eventbus.impl;

import org.jboss.netty.util.CharsetUtil;
import org.vertx.java.core.Handler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.eventbus.impl.DefaultEventBus;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.net.NetSocket;
import org.vertx.java.core.net.impl.ServerID;

public abstract class BaseMessage<T>
extends Message<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseMessage.class);
    protected ServerID sender;
    protected DefaultEventBus bus;
    protected String address;
    boolean send;

    protected BaseMessage(boolean send, String address, T body) {
        this.send = send;
        this.body = body;
        if (address == null) {
            throw new IllegalArgumentException("address must be specified");
        }
        this.address = address;
        this.body = body;
    }

    @Override
    public void reply(T message, Handler<Message<T>> replyHandler) {
        if (this.bus != null && this.replyAddress != null) {
            BaseMessage replyMessage = this.createReplyMessage(message);
            this.bus.sendReply(this.sender, replyMessage, replyHandler);
        }
    }

    protected BaseMessage(Buffer readBuff) {
        int pos = 1;
        byte bsend = readBuff.getByte(pos);
        this.send = bsend == 0;
        int addressLength = readBuff.getInt(++pos);
        byte[] addressBytes = readBuff.getBytes(pos += 4, pos + addressLength);
        this.address = new String(addressBytes, CharsetUtil.UTF_8);
        int port = readBuff.getInt(pos += addressLength);
        int hostLength = readBuff.getInt(pos += 4);
        byte[] hostBytes = readBuff.getBytes(pos += 4, pos + hostLength);
        String host = new String(hostBytes, CharsetUtil.UTF_8);
        this.sender = new ServerID(port, host);
        int replyAddressLength = readBuff.getInt(pos += hostLength);
        pos += 4;
        if (replyAddressLength > 0) {
            byte[] replyAddressBytes = readBuff.getBytes(pos, pos + replyAddressLength);
            pos += replyAddressLength;
            this.replyAddress = new String(replyAddressBytes, CharsetUtil.UTF_8);
        } else {
            this.replyAddress = null;
        }
        this.readBody(pos, readBuff);
    }

    protected void write(NetSocket socket) {
        int length = 6 + this.address.length() + 1 + 4 * this.sender.host.length() + 4 + (this.replyAddress == null ? 0 : this.replyAddress.length()) + this.getBodyLength();
        Buffer totBuff = new Buffer(length);
        totBuff.appendInt(0);
        totBuff.appendByte(this.type());
        totBuff.appendByte(this.send ? (byte)0 : 1);
        this.writeString(totBuff, this.address);
        totBuff.appendInt(this.sender.port);
        this.writeString(totBuff, this.sender.host);
        if (this.replyAddress != null) {
            this.writeString(totBuff, this.replyAddress);
        } else {
            totBuff.appendInt(0);
        }
        this.writeBody(totBuff);
        totBuff.setInt(0, totBuff.length() - 4);
        socket.write(totBuff);
    }

    protected void writeString(Buffer buff, String str) {
        byte[] strBytes = str.getBytes(CharsetUtil.UTF_8);
        buff.appendInt(strBytes.length);
        buff.appendBytes(strBytes);
    }

    protected abstract byte type();

    protected abstract Message<T> copy();

    protected abstract void readBody(int var1, Buffer var2);

    protected abstract void writeBody(Buffer var1);

    protected abstract int getBodyLength();

    protected abstract BaseMessage createReplyMessage(T var1);
}

